/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.config;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.awt.Color;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.chatlog.ChatLog;
import obro1961.chatpatches.config.Config;
import org.apache.commons.lang3.StringUtils;

public class YACLConfig
extends Config {
    @Override
    public class_437 getConfigScreen(class_437 parent) {
        ArrayList timeOpts = new ArrayList();
        ArrayList hoverOpts = new ArrayList();
        ArrayList counterOpts = new ArrayList();
        ArrayList compactChatOpts = new ArrayList();
        ArrayList boundaryOpts = new ArrayList();
        ArrayList chatlogOpts = new ArrayList();
        ArrayList chatlogActions = new ArrayList();
        ArrayList chatNameOpts = new ArrayList();
        ArrayList chatHudOpts = new ArrayList();
        ArrayList chatScreenOpts = new ArrayList();
        ArrayList copyMenuOpts = new ArrayList();
        ArrayList helpOpts = new ArrayList();
        ChatPatches.config.getOptions().forEach(opt -> {
            OptionFlag[] optionFlagArray;
            String key = opt.key;
            String cat = key.split("[A-Z]")[0];
            if (key.matches("caseSensitive|formatting|regex")) {
                return;
            }
            if (key.contains("counterCompact")) {
                cat = "compact";
            } else if (!class_1074.method_4663((String)("text.chatpatches.category." + cat))) {
                cat = "screen";
            } else if (key.contains("Name")) {
                cat = "name";
            } else if (key.startsWith("help")) {
                cat = "help";
            }
            if (key.contains("Color")) {
                opt = new Config.Setting<Color>(new Color((Integer)opt.get()), new Color((Integer)opt.def), key){

                    @Override
                    public Color get() {
                        return new Color((Integer)YACLConfig.this.getOption(this.key).get());
                    }

                    @Override
                    public void set(Object value) {
                        super.set(((Color)value).getRGB() - -16777216);
                    }
                };
            }
            Option.Builder builder = Option.createBuilder().name((class_2561)class_2561.method_43471((String)("text.chatpatches." + key))).description(YACLConfig.desc(opt)).controller(me -> YACLConfig.getController(me, key)).binding(YACLConfig.getBinding(opt));
            if (StringUtils.containsIgnoreCase((CharSequence)key, (CharSequence)"chat")) {
                OptionFlag[] optionFlagArray2 = new OptionFlag[1];
                optionFlagArray = optionFlagArray2;
                optionFlagArray2[0] = client -> client.field_1705.method_1743().method_1817();
            } else {
                optionFlagArray = new OptionFlag[]{};
            }
            Option yaclOpt = builder.flag(optionFlagArray).build();
            switch (cat) {
                case "time": {
                    timeOpts.add(yaclOpt);
                    break;
                }
                case "hover": {
                    hoverOpts.add(yaclOpt);
                    break;
                }
                case "counter": {
                    counterOpts.add(yaclOpt);
                    break;
                }
                case "compact": {
                    compactChatOpts.add(yaclOpt);
                    break;
                }
                case "boundary": {
                    boundaryOpts.add(yaclOpt);
                    break;
                }
                case "chatlog": {
                    chatlogOpts.add(yaclOpt);
                    break;
                }
                case "name": {
                    chatNameOpts.add(yaclOpt);
                    break;
                }
                case "chat": {
                    chatHudOpts.add(yaclOpt);
                    break;
                }
                case "screen": {
                    chatScreenOpts.add(yaclOpt);
                    break;
                }
                case "copy": {
                    copyMenuOpts.add(yaclOpt);
                    break;
                }
                case "help": {
                    helpOpts.add(yaclOpt);
                }
            }
        });
        List<String> actionKeys = List.of("chatlogClear", "chatlogClearHistory", "chatlogClearMessages", "chatlogLoad", "chatlogSave", "chatlogBackup", "chatlogOpenFolder");
        for (String key : actionKeys) {
            Object[] args = new Object[]{key.equals("chatlogClearMessages") ? ChatLog.messageCount() : (key.equals("chatlogClearHistory") ? ChatLog.historyCount() : -1)};
            chatlogActions.add((Option<?>)YACLConfig.action(key, args));
        }
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"text.chatpatches.title")).category(YACLConfig.category("time", timeOpts, new OptionGroup[0])).category(YACLConfig.category("hover", hoverOpts, new OptionGroup[0])).category(YACLConfig.category("counter", counterOpts, YACLConfig.group("counter.compact", compactChatOpts, class_2583.field_24360.method_10958((class_2558)new class_2558.class_10608(URI.create("https://modrinth.com/mod/compact-chat")))))).category(YACLConfig.category("boundary", boundaryOpts, new OptionGroup[0])).category(YACLConfig.category("chatlog", chatlogOpts, YACLConfig.group("chatlog.actions", chatlogActions, null))).category(YACLConfig.category("chat", List.of(), YACLConfig.group("chat.name", chatNameOpts, null), YACLConfig.group("chat.hud", chatHudOpts, null), YACLConfig.group("chat.screen", chatScreenOpts, null))).category(YACLConfig.category("copy", copyMenuOpts, new OptionGroup[0])).category(YACLConfig.category("help", List.of(YACLConfig.action("help.reloadConfig", -1), (Option)helpOpts.getFirst(), YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.dateFormat"), "https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html"), YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.formatCodes"), "https://minecraft.wiki/w/Formatting_codes"), YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.faq"), "https://github.com/mrbuilder1961/ChatPatches#faq"), YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.regex"), "https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html"), YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.regexTester"), "https://regex101.com/")), new OptionGroup[0])).save(Config::write);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            builder.category(YACLConfig.category("debug", List.of(ButtonOption.createBuilder().name((class_2561)class_2561.method_43470((String)"Print GitHub Option table")).action((screen, option) -> {
                StringBuilder str = new StringBuilder();
                ChatPatches.config.getOptions().forEach(opt -> str.append("\n| %s | %s | %s | `text.chatpatches.%s` |".formatted(class_1074.method_4662((String)("text.chatpatches." + opt.key), (Object[])new Object[0]), opt.getType().equals(Integer.class) && opt.key.contains("Color") ? "`0x%06x`".formatted((int)((Integer)opt.def)) : (opt.getType().equals(String.class) ? "`\"" + String.valueOf(opt.def) + "\"`" : "`" + String.valueOf(opt.def) + "`"), class_1074.method_4662((String)("text.chatpatches.desc." + opt.key), (Object[])new Object[0]), opt.key)));
                ChatPatches.LOGGER.warn("[YACLConfig.printGithubTables] {}", (Object)str);
            }).build()), new OptionGroup[0]));
        }
        return builder.build().generateScreen(parent);
    }

    private static <T> ControllerBuilder<T> getController(Option<T> opt, String key) {
        if (key.matches("^.*(?:Str|Date|Format)$")) {
            return StringControllerBuilder.create(opt);
        }
        if (key.contains("Color")) {
            return ColorControllerBuilder.create(opt);
        }
        if (ChatPatches.config.getOption(key).get() instanceof Integer) {
            return ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create(opt).range((Number)YACLConfig.getMinOrMax(key, true), (Number)YACLConfig.getMinOrMax(key, false))).step((Number)YACLConfig.getInterval(key));
        }
        return BooleanControllerBuilder.create(opt).coloured(true);
    }

    private static BiConsumer<YACLScreen, ButtonOption> getAction(String key) {
        return (screen, option) -> {
            if (key.contains("Clear")) {
                if (!key.contains("History")) {
                    ChatLog.clearMessages();
                }
                if (!key.contains("Messages")) {
                    ChatLog.clearHistory();
                }
            } else if (key.equals("chatlogLoad")) {
                ChatLog.load(true);
            } else if (key.equals("chatlogSave")) {
                ChatLog.serialize();
            } else if (key.equals("chatlogBackup")) {
                ChatLog.backup();
            } else if (key.equals("chatlogOpenFolder")) {
                class_156.method_668().method_672(ChatLog.PATH.getParent().toFile());
            } else if (key.equals("help.reloadConfig")) {
                YACLConfig.read();
                YACLConfig.write();
            }
        };
    }

    private static <T> Binding<T> getBinding(Config.Setting<?> option) {
        Config.Setting<?> o = option;
        if (o.key.contains("Date")) {
            return Binding.generic(o.def, o::get, inc -> {
                try {
                    new SimpleDateFormat(inc.toString());
                    o.set(inc);
                }
                catch (IllegalArgumentException e) {
                    ChatPatches.LOGGER.error("[YACLConfig.getBinding] Invalid date format '{}' provided for '{}'", inc, (Object)o.key);
                }
            });
        }
        if (o.key.contains("Format")) {
            return Binding.generic(o.def, o::get, inc -> {
                if (inc.toString().contains("$")) {
                    o.set(inc);
                }
            });
        }
        return Binding.generic(o.def, o::get, o::set);
    }

    private static int getMinOrMax(String key, boolean min) {
        if (min) {
            return switch (key) {
                case "counterCompactDistance" -> -1;
                case "chatShift" -> -50;
                default -> 0;
            };
        }
        return switch (key) {
            case "counterCompactDistance" -> 1024;
            case "chatlogSaveInterval" -> 180;
            case "chatWidth" -> mc.method_22683().method_4486() - 12;
            case "chatHeight" -> mc.method_22683().method_4502() - 12;
            case "chatMaxMessages" -> Short.MAX_VALUE;
            default -> 100;
        };
    }

    private static int getInterval(String key) {
        return switch (key) {
            case "chatMaxMessages" -> 16;
            default -> 1;
        };
    }

    private static ConfigCategory category(String key, List<Option<?>> options, OptionGroup ... groups) {
        ConfigCategory.Builder builder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)("text.chatpatches.category." + key)));
        if (class_1074.method_4663((String)("text.chatpatches.category.desc." + key))) {
            builder.tooltip(new class_2561[]{class_2561.method_43471((String)("text.chatpatches.category.desc." + key))});
        }
        if (groups.length > 0) {
            builder.groups(List.of(groups));
        }
        if (!options.isEmpty()) {
            builder.options(options);
        }
        return builder.build();
    }

    private static OptionGroup group(String key, List<Option<?>> options, class_2583 descriptionStyle) {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)("text.chatpatches.category." + key))).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)("text.chatpatches.category.desc." + key)).method_27696(descriptionStyle != null ? descriptionStyle : class_2583.field_24360)})).options(options).build();
    }

    private static OptionDescription desc(Config.Setting<?> opt) {
        OptionDescription.Builder builder = OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)("text.chatpatches.desc." + opt.key))});
        String image = "textures/preview/" + opt.key.replaceAll("([A-Z])", "_$1").toLowerCase(Locale.ROOT) + ".webp";
        class_2960 id = class_2960.method_60655((String)"chatpatches", (String)image);
        try {
            if (mc.method_1478().method_14486(id).isPresent()) {
                builder.webpImage(id);
            } else {
                ChatPatches.LOGGER.debug("[YACLConfig.desc] Couldn't find '{}'", (Object)image);
            }
        }
        catch (Throwable e) {
            ChatPatches.LOGGER.error("[YACLConfig.desc] An error occurred while trying to use '{}:{}' :", new Object[]{"chatpatches", image, e});
        }
        return builder.build();
    }

    private static Option<class_2561> label(class_5250 labelText, String urlTooltip) {
        return LabelOption.create((class_2561)labelText.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(urlTooltip)))));
    }

    private static ButtonOption action(String key, Object ... args) {
        Object o = new Object();
        return ButtonOption.createBuilder().name((class_2561)class_2561.method_43469((String)("text.chatpatches." + key), (Object[])(args[0].equals(-1) ? new Object[]{} : args))).description(YACLConfig.desc(new Config.Setting<Object>(o, o, key))).action(YACLConfig.getAction(key)).available(!key.matches("chatlog(Load|Save)") || YACLConfig.mc.field_1687 != null).build();
    }
}

