/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import java.io.EOFException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_268;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_642;
import net.minecraft.class_7417;
import net.minecraft.class_745;
import net.minecraft.class_746;
import net.minecraft.class_8828;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.accessor.ChatHudAccessor;
import obro1961.chatpatches.config.YACLConfig;
import obro1961.chatpatches.util.ChatUtils;
import obro1961.chatpatches.util.RenderUtils;
import obro1961.chatpatches.util.TextUtils;
import org.spongepowered.asm.mixin.Unique;

public class Config {
    public static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("chatpatches.json");
    public static final Config DEFAULTS = new Config();
    protected static final FabricLoader FABRIC = FabricLoader.getInstance();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected static final class_310 mc = class_310.method_1551();
    protected static String lastWorld = "";
    public boolean time = true;
    public String timeDate = "HH:mm:ss";
    public String timeFormat = "[$]";
    public int timeColor = 0xFF55FF;
    public boolean hover = true;
    public String hoverDate = "MM/dd/yyyy";
    public String hoverFormat = "$";
    public int hoverColor = 0xFFFFFF;
    public boolean counter = true;
    public String counterFormat = "&8(&7x&r$&8)";
    public int counterColor = 0xFFFF55;
    public boolean counterCheckStyle = false;
    public boolean counterCompact = false;
    public int counterCompactDistance = 0;
    public boolean boundary = true;
    public String boundaryFormat = "&8[&r$&8]";
    public int boundaryColor = 0x55FFFF;
    public boolean chatlog = true;
    public int chatlogSaveInterval = 0;
    public boolean chatHidePacket = true;
    public int chatWidth = 0;
    public int chatHeight = 0;
    public int chatMaxMessages = 16384;
    public boolean chatName = true;
    public String chatNameFormat = "<$>";
    public int chatNameColor = 0xFFFFFF;
    public int chatShift = 0;
    public boolean dynamicChatShift = true;
    public boolean messageDrafting = false;
    public boolean onlyInvasiveDrafting = false;
    public boolean searchDrafting = true;
    public boolean hideSearchButton = false;
    public boolean vanillaClearing = false;
    public int copyColor = 0x55FFFF;
    public String copyReplyFormat = "/msg $ ";
    public boolean caseSensitive = true;
    public boolean formatting = false;
    public boolean regex = false;
    public boolean helpLogMessageStructures = false;

    public static Config create() {
        boolean accessibleInGame = FABRIC.isModLoaded("modmenu") || FABRIC.isModLoaded("catalogue") && FABRIC.isModLoaded("menulogue");
        ChatPatches.config = accessibleInGame ? new YACLConfig() : DEFAULTS;
        Config.read();
        Config.write();
        return ChatPatches.config;
    }

    public class_437 getConfigScreen(class_437 parent) {
        class_310 mc = class_310.method_1551();
        boolean suggestYACL = class_155.method_31372() >= 759;
        String link = "https://modrinth.com/mod/" + (suggestYACL ? "yacl" : "cloth-config");
        return new class_410(clicked -> {
            if (clicked) {
                class_407.method_49623((class_437)parent, (String)link);
            } else {
                mc.method_1507(parent);
            }
        }, (class_2561)class_2561.method_43471((String)"text.chatpatches.help.missing"), (class_2561)class_2561.method_43469((String)"text.chatpatches.desc.help.missing", (Object[])new Object[]{suggestYACL ? "YACL" : "Cloth Config"}), class_5244.field_41873, class_5244.field_24339);
    }

    private class_5250 makeObject(String formatStr, String varStr, String prefix, String suffix, class_2583 style) {
        return TextUtils.text(prefix + TextUtils.fillVars(formatStr, varStr) + suffix).method_27696(RenderUtils.BLANK_STYLE.method_27702(style));
    }

    public class_5250 makeTimestamp(Date when) {
        return this.makeObject(this.timeFormat, new SimpleDateFormat(this.timeDate).format(when), "", " ", RenderUtils.BLANK_STYLE.method_36139(this.timeColor));
    }

    public class_2583 makeHoverStyle(Date when) {
        class_5250 hoverText = this.makeObject(this.hoverFormat, new SimpleDateFormat(this.hoverDate).format(when), "", "", RenderUtils.BLANK_STYLE.method_36139(this.hoverColor));
        return RenderUtils.BLANK_STYLE.method_10949((class_2568)(this.hover ? new class_2568.class_10613((class_2561)hoverText) : null)).method_10958((class_2558)(this.hover ? new class_2558.class_10610(hoverText.getString()) : null)).method_10975(String.valueOf(when.getTime())).method_36139(this.timeColor);
    }

    public class_5250 formatPlayername(GameProfile profile) {
        class_2583 style = class_2583.field_24360.method_36139(this.chatNameColor);
        try {
            class_268 team = Config.mc.field_1687.method_8428().method_1164(profile.getName());
            class_2583 hoverStyle = new class_745(Config.mc.field_1687, profile).method_5476().method_10866().method_27702(style);
            String[] configFormat = this.chatNameFormat.split("\\$");
            ArrayList<class_2561> components = new ArrayList<class_2561>(team != null ? 5 : 3);
            components.add((class_2561)TextUtils.text(configFormat[0]));
            components.add((class_2561)TextUtils.text(profile.getName()));
            components.add((class_2561)TextUtils.text(configFormat[1] + " "));
            if (team != null) {
                components.add(1, team.method_1144());
                components.add(3, team.method_1136());
            }
            return TextUtils.newText((class_7417)class_8828.field_46625, components, hoverStyle);
        }
        catch (RuntimeException e) {
            ChatPatches.LOGGER.error("[Config.formatPlayername] /!\\ An error occurred while trying to format '{}'s playername /!\\", (Object)profile.getName());
            if (Config.mc.field_1687 == null) {
                e.addSuppressed(new IllegalStateException("[Config#formatPlayername] Expected existing ClientWorld"));
            }
            ChatPatches.logReportMsg(e);
            return this.makeObject(this.chatNameFormat, profile.getName(), "", " ", style);
        }
    }

    public class_5250 makeDupeCounter(int dupes) {
        return this.makeObject(this.counterFormat, Integer.toString(dupes), " ", "", RenderUtils.BLANK_STYLE.method_36139(this.counterColor));
    }

    public class_2561 makeBoundaryLine(String levelName) {
        return ChatUtils.buildMessage(null, null, null, (class_2561)this.makeObject(this.boundaryFormat, levelName, "", "", RenderUtils.BLANK_STYLE.method_36139(this.boundaryColor)));
    }

    public void sendBoundaryLine() {
        String current;
        if (!ChatPatches.config.boundary || ChatPatches.config.vanillaClearing) {
            return;
        }
        ChatHudAccessor chat = (ChatHudAccessor)Config.mc.field_1705.method_1743();
        if (mc.method_1496()) {
            v0 = "C_" + mc.method_1576().method_27728().method_150();
        } else {
            class_642 class_6422 = mc.method_1558();
            if (class_6422 instanceof class_642) {
                class_642 entry = class_6422;
                v0 = "S_" + (entry.field_3752.isBlank() ? entry.field_3761 : entry.field_3752);
            } else {
                v0 = current = "";
            }
        }
        if (!(chat.chatpatches$getMessages().isEmpty() || current.startsWith("S_") && lastWorld.startsWith("S_") && current.equals(lastWorld))) {
            try {
                lastWorld = current;
                String levelName = ((String)lastWorld).substring(2);
                boolean time = ChatPatches.config.time;
                ChatPatches.config.time = false;
                Config.mc.field_1705.method_1743().method_1812(ChatPatches.config.makeBoundaryLine(levelName));
                ChatPatches.config.time = time;
            }
            catch (Exception e) {
                ChatPatches.LOGGER.warn("[Config.sendBoundaryLine] An error occurred while adding the boundary line:", (Throwable)e);
            }
        }
    }

    @Unique
    public int calcDynamicChatShift() {
        class_746 player = Config.mc.field_1724;
        if (!ChatPatches.config.dynamicChatShift || player == null) {
            return this.chatShift;
        }
        int armor = player.method_6096();
        float absorption = player.method_6067();
        float health = player.method_6063();
        double scale = Config.mc.field_1705.method_1743().method_1814();
        int armorHeightMultiplier = armor == 0 ? 0 : 1 + (armor - 1) / 20;
        int healthHeightMultiplier = (int)(health + absorption - 1.0f) / 20;
        float healthScale = healthHeightMultiplier > 7 ? 0.3f : 0.00583333f * (float)Math.pow(healthHeightMultiplier, 3.0) - 0.0722619f * (float)Math.pow(healthHeightMultiplier, 2.0) + 0.154048f * (float)healthHeightMultiplier + 0.918571f;
        return armorHeightMultiplier * class_3532.method_15357((double)(10.0 / scale)) + healthHeightMultiplier * class_3532.method_15357((double)((double)(10.0f * healthScale) / scale)) + this.chatShift;
    }

    public static void read() {
        if (Files.exists(PATH, new LinkOption[0])) {
            try {
                String rawData = Files.readString(PATH);
                if (rawData.length() < 2 || !rawData.startsWith("{") || !rawData.endsWith("}")) {
                    throw new EOFException("ChatPatches config file is empty or corrupted");
                }
                ChatPatches.config = (Config)GSON.fromJson(rawData, ChatPatches.config.getClass());
                ChatPatches.LOGGER.info("[Config.read] Loaded config info from '{}'!", (Object)PATH);
            }
            catch (JsonIOException | JsonSyntaxException | EOFException e) {
                ChatPatches.LOGGER.info("[Config.read] The config couldn't be loaded; backing up and resetting:", e);
                Config.writeCopy();
                ChatPatches.config = DEFAULTS;
            }
            catch (IOException e) {
                ChatPatches.LOGGER.error("[Config.read] An error occurred while trying to load config data from '{}'; resetting:", (Object)PATH, (Object)e);
                ChatPatches.config = DEFAULTS;
            }
        } else {
            ChatPatches.LOGGER.info("[Config.read] No config file found; using default values");
        }
    }

    public static void write() {
        try (FileWriter fw = new FileWriter(PATH.toFile());){
            GSON.toJson((Object)ChatPatches.config, ChatPatches.config.getClass(), (Appendable)fw);
            ChatPatches.LOGGER.info("[Config.write] Saved config info to '{}'!", (Object)PATH);
        }
        catch (Exception e) {
            ChatPatches.LOGGER.error("[Config.write] An error occurred while trying to save the config to '{}':", (Object)PATH, (Object)e);
        }
    }

    public static void writeCopy() {
        try {
            Files.copy(PATH, PATH.resolveSibling("chatpatches_" + class_156.method_44893() + ".json"), new CopyOption[0]);
        }
        catch (IOException e) {
            ChatPatches.LOGGER.warn("[Config.writeCopy] An error occurred trying to write a copy of the original config file:", (Throwable)e);
        }
    }

    public List<Setting<?>> getOptions() {
        ArrayList options = new ArrayList(this.getClass().getFields().length);
        try {
            for (Field f : this.getClass().getFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                options.add(new Setting<Object>(f.get(ChatPatches.config), f.get(DEFAULTS), f.getName()));
            }
        }
        catch (IllegalAccessException e) {
            ChatPatches.logReportMsg(e);
        }
        return options;
    }

    public <T> Setting<T> getOption(String key) {
        return this.getOptions().stream().filter(opt -> opt.key.equals(key)).findFirst().orElse(new Setting<Object>(new Object(), new Object(), key));
    }

    public static class Setting<T> {
        public final String key;
        public final T def;
        private T val;

        public Setting(T val, T def, String key) {
            this.val = Objects.requireNonNull(val, "Cannot create a setting option without a value");
            this.def = Objects.requireNonNull(def, "Cannot create a setting option without a default value");
            this.key = Objects.requireNonNull(key, "Cannot create a setting option without a lang key");
        }

        public T get() {
            return this.val;
        }

        public Class<T> getType() {
            return this.def.getClass();
        }

        public void set(Object obj) {
            try {
                Object inc = obj;
                if (inc != null && !inc.equals(this.val)) {
                    ChatPatches.config.getClass().getField(this.key).set(ChatPatches.config, inc);
                    this.val = inc;
                }
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                ChatPatches.LOGGER.error("[Setting.set({})] An error occurred trying to change config option '{}':", obj, (Object)this.key);
                ChatPatches.logReportMsg(e);
            }
        }
    }
}

