/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.chatlog;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_3518;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_7591;
import net.minecraft.class_8824;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.accessor.ChatHudAccessor;
import org.jetbrains.annotations.Nullable;

public class ChatLog {
    public static final Codec<Pair<ObjectList<class_2561>, ObjectList<String>>> CODEC = Codec.pair((Codec)class_8824.field_46597.listOf().xmap(ChatLog::newSyncedObjectList, Function.identity()).fieldOf("messages").codec(), (Codec)Codec.STRING.listOf().xmap(ChatLog::newSyncedObjectList, Function.identity()).fieldOf("history").codec());
    public static final Path PATH = FabricLoader.getInstance().getGameDir().resolve("logs").resolve("chatlog.json");
    public static final class_7591 RESTORED_INDICATOR = new class_7591(3682229, null, (class_2561)class_2561.method_43471((String)"text.chatpatches.restored"), "Restored");
    private static final int DEFAULT_SIZE = 100;
    private static final int IO_THRESHOLD_SUGGESTION = 1000;
    private static final String EMPTY_JSON = "{\"messages\":[],\"history\":[]}";
    private static final ObjectList<?> EMPTY_LIST = ChatLog.newSyncedObjectList(null);
    private static final class_310 mc = class_310.method_1551();
    private static boolean restoring = false;
    private static int lastHistoryCount = -1;
    private static int lastMessageCount = -1;
    private static int ticksUntilSave = ChatPatches.config.chatlogSaveInterval * 1200;
    private static ObjectList<class_2561> messages = EMPTY_LIST;
    private static ObjectList<String> history = EMPTY_LIST;

    static <T> ObjectList<T> newSyncedObjectList(@Nullable List<T> source) {
        return ObjectLists.synchronize((ObjectList)(source == null ? new ObjectArrayList(100) : new ObjectArrayList(source)));
    }

    public static boolean isRestoring() {
        return restoring;
    }

    public static void addMessage(class_2561 message) {
        if (restoring) {
            return;
        }
        ChatLog.ensureCapacity();
        messages.add((Object)message);
    }

    public static void addHistory(String sentMessage) {
        if (restoring) {
            return;
        }
        ChatLog.ensureCapacity();
        history.add((Object)sentMessage);
    }

    public static void clearMessages() {
        messages.clear();
    }

    public static void clearHistory() {
        history.clear();
    }

    public static int messageCount() {
        return messages.size();
    }

    public static int historyCount() {
        return history.size();
    }

    private static void ensureCapacity() {
        if (ChatLog.messageCount() > ChatPatches.config.chatMaxMessages) {
            messages.removeElements(0, ChatLog.messageCount() - ChatPatches.config.chatMaxMessages);
        }
        if (ChatLog.historyCount() > ChatPatches.config.chatMaxMessages) {
            history.removeElements(0, ChatLog.historyCount() - ChatPatches.config.chatMaxMessages);
        }
    }

    private static void updateMessageCounts() {
        lastMessageCount = ChatLog.messageCount();
        lastHistoryCount = ChatLog.historyCount();
    }

    public static void deserialize() {
        String rawJson = EMPTY_JSON;
        long start = System.currentTimeMillis();
        ChatPatches.LOGGER.info("[ChatLog.deserialize] Reading...");
        if (Files.exists(PATH, new LinkOption[0])) {
            try {
                rawJson = Files.readString(PATH);
            }
            catch (MalformedInputException notUTF8) {
                Charset def = Charset.defaultCharset();
                ChatPatches.LOGGER.warn("[ChatLog.deserialize] File encoding was '{}', not UTF-8. Complex text characters may have been corrupted!", (Object)def.name());
                try {
                    rawJson = Files.readString(PATH, def);
                }
                catch (IOException e2) {
                    ChatPatches.LOGGER.error("[ChatLog.deserialize] Couldn't parse '{}' in UTF-8 or '{}', generating a new one:", new Object[]{PATH, def.name(), e2});
                    rawJson = EMPTY_JSON;
                    ChatLog.backup();
                }
            }
            catch (IOException e3) {
                ChatPatches.LOGGER.error("[ChatLog.deserialize] Something went wrong accessing '{}':", (Object)PATH, (Object)e3);
                rawJson = EMPTY_JSON;
                ChatLog.backup();
            }
        }
        try {
            if (rawJson.equals(EMPTY_JSON)) {
                messages = ChatLog.newSyncedObjectList(null);
                history = ChatLog.newSyncedObjectList(null);
            } else {
                JsonObject json = class_3518.method_15285((String)rawJson);
                ChatPatches.usingUnsafeCodec = true;
                Pair deserializedPair = CODEC.parse(ChatPatches.jsonOps(), (Object)json).resultOrPartial(e -> {
                    ChatPatches.logReportMsg((Throwable)new JsonParseException(e));
                    ChatLog.backup();
                }).orElseGet(() -> Pair.of(ChatLog.newSyncedObjectList(null), ChatLog.newSyncedObjectList(null)));
                ChatPatches.usingUnsafeCodec = false;
                messages = (ObjectList)deserializedPair.getFirst();
                history = (ObjectList)deserializedPair.getSecond();
            }
            ChatLog.ensureCapacity();
            ChatLog.updateMessageCounts();
            ChatPatches.LOGGER.info("[ChatLog.deserialize] Parsed {} messages and {} sent messages!", (Object)lastMessageCount, (Object)lastHistoryCount);
        }
        catch (RuntimeException e4) {
            ChatPatches.LOGGER.error("[ChatLog.deserialize] An unexpected error occurred while trying to parse '{}', backing it up and generating a new one:", (Object)PATH, (Object)e4);
            ChatLog.backup();
            messages = ChatLog.newSyncedObjectList(null);
            history = ChatLog.newSyncedObjectList(null);
        }
        ChatPatches.logDuration(start, 1000L);
    }

    public static void serialize() {
        if (!ChatPatches.config.chatlog) {
            return;
        }
        if (messages.size() == lastMessageCount && history.size() == lastHistoryCount || messages.isEmpty() && history.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        ChatPatches.LOGGER.info("[ChatLog.serialize] Saving...");
        try {
            ChatPatches.usingUnsafeCodec = true;
            JsonElement json = (JsonElement)CODEC.encodeStart(ChatPatches.jsonOps(), (Object)Pair.of(messages, history)).resultOrPartial(e -> ChatPatches.logReportMsg((Throwable)new JsonParseException(e))).orElseThrow();
            ChatPatches.usingUnsafeCodec = false;
            Files.writeString(PATH, (CharSequence)class_3518.method_43680((JsonElement)json), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            ChatLog.updateMessageCounts();
            ChatPatches.LOGGER.info("[ChatLog.serialize] Saved {} messages and {} sent messages to '{}'!", new Object[]{lastMessageCount, lastHistoryCount, PATH});
        }
        catch (IOException | RuntimeException e2) {
            ChatPatches.LOGGER.error("[ChatLog.serialize] An unexpected error occurred while trying to save:", (Throwable)e2);
            ChatPatches.LOGGER.warn("[ChatLog.serialize] Dumping data: {}", (Object)EMPTY_JSON.replace("[]", messages.stream().map(class_2561::getString).toList().toString()).replace("[]", history.toString()));
        }
        ChatPatches.logDuration(start, 1000L);
    }

    public static void backup() {
        try {
            Path backupPath = PATH.resolveSibling("chatlog_" + class_156.method_44893() + ".json");
            Files.copy(PATH, backupPath, new CopyOption[0]);
            ChatPatches.LOGGER.info("[ChatLog.backup] Successfully backed up the current chat log to '{}':", (Object)backupPath);
        }
        catch (IOException e) {
            ChatPatches.LOGGER.warn("[ChatLog.backup] Couldn't backup '{}':", (Object)PATH, (Object)e);
        }
    }

    public static void restore() {
        if (ChatLog.messageCount() > 0 && ChatLog.historyCount() > 0) {
            class_338 chat = ChatLog.mc.field_1705.method_1743();
            restoring = true;
            history.forEach(arg_0 -> ((class_338)chat).method_1803(arg_0));
            messages.forEach(msg -> chat.method_44811(msg, null, RESTORED_INDICATOR));
            restoring = false;
            ChatLog.hideRecentMessages();
        }
        ChatPatches.LOGGER.info("[ChatLog.restore] Restored {} messages and {} history messages!", (Object)ChatLog.messageCount(), (Object)ChatLog.historyCount());
    }

    public static void hideRecentMessages() {
        if (ChatLog.messageCount() > 0 && ChatLog.historyCount() > 0) {
            int ticks = ChatLog.mc.field_1705.method_1738();
            ((ChatHudAccessor)ChatLog.mc.field_1705.method_1743()).chatpatches$getVisibleMessages().replaceAll(ln -> ticks - ln.comp_895() < 200 ? new class_303.class_7590(-(200 + ln.comp_895()), ln.comp_896(), ln.comp_897(), ln.comp_898()) : ln);
        }
    }

    public static void load(boolean force) {
        if (ChatPatches.config.chatlog && (messages == EMPTY_LIST && history == EMPTY_LIST || force)) {
            ChatLog.deserialize();
            ChatLog.restore();
        }
    }

    public static void tickSaveCounter() {
        if (ChatPatches.config.chatlogSaveInterval > 0 && ticksUntilSave == 0) {
            ChatLog.serialize();
        }
        if (--ticksUntilSave < 0) {
            ticksUntilSave = ChatPatches.config.chatlogSaveInterval * 1200;
        }
    }

    public static void saveIfPaused(class_437 screen) {
        if (ChatPatches.config.chatlogSaveInterval == 0 && (!mc.method_1569() || screen instanceof class_433)) {
            ChatLog.serialize();
        }
    }
}

