/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_6903;
import obro1961.chatpatches.chatlog.ChatLog;
import obro1961.chatpatches.config.Config;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatPatches
implements ClientModInitializer {
    public static final String MOD_ID = "chatpatches";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"chatpatches");
    public static boolean usingUnsafeCodec = false;
    public static Config config = Config.create();

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public void onInitializeClient() {
        ClientPlayConnectionEvents.DISCONNECT.register((network, client) -> ChatLog.serialize());
        ScreenEvents.AFTER_INIT.register((client, screen, sW, sH) -> ChatLog.saveIfPaused(screen));
        ClientTickEvents.END_WORLD_TICK.register(world -> ChatLog.tickSaveCounter());
        ClientPlayConnectionEvents.JOIN.register((network, packetSender, client) -> {
            ChatLog.load(false);
            config.sendBoundaryLine();
            ChatLog.hideRecentMessages();
        });
        LOGGER.info("[ChatPatches()] Finished setting up!");
    }

    public static void logReportMsg(@NotNull Throwable error) {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        String clazz = walker.getCallerClass().getSimpleName();
        String method = walker.walk(frames -> ((StackWalker.StackFrame)frames.skip(1L).findFirst().orElseThrow()).getMethodName());
        if (method.isBlank()) {
            method = error.getStackTrace()[0].getMethodName();
        }
        LOGGER.error("[" + clazz + "." + method + "] /!\\ Please report this error on GitHub or Discord with the full log file attached! /!\\", error);
    }

    public static <X extends Throwable> X logAndThrowReportMsg(@NotNull X error) throws X {
        ChatPatches.logReportMsg(error);
        throw error;
    }

    public static void logDuration(long start, long threshold) {
        double duration = (double)(System.currentTimeMillis() - start) / 1000.0;
        double max = (double)threshold / 1000.0;
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        String clazz = walker.getCallerClass().getSimpleName();
        String method = walker.walk(frames -> ((StackWalker.StackFrame)frames.skip(1L).findFirst().orElseThrow()).getMethodName());
        if (duration >= max) {
            LOGGER.warn("[{}.{}] Took {} seconds, but should've taken less than {}s. Consider reporting this to the GitHub or Discord", new Object[]{clazz, method, duration, max});
        } else {
            LOGGER.info("[{}.{}] Took {} seconds", new Object[]{clazz, method, duration});
        }
    }

    public static class_6903<JsonElement> jsonOps() throws NullPointerException {
        class_638 class_6382 = class_310.method_1551().field_1687;
        if (class_6382 instanceof class_638) {
            class_638 world = class_6382;
            return world.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE);
        }
        throw ChatPatches.logAndThrowReportMsg(new NullPointerException("[ChatPatches#jsonOps] Expected existing ClientWorld"));
    }
}

