/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.util;

import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.gui.UIHelper;
import com.nettakrim.signed_paintings.mixin.TextureManagerAccessor;
import com.nettakrim.signed_paintings.rendering.OverlayInfo;
import com.nettakrim.signed_paintings.util.ImageData;
import com.nettakrim.signed_paintings.util.ImageDataLoadInterface;
import com.nettakrim.signed_paintings.util.ImageStatus;
import com.nettakrim.signed_paintings.util.URLAlias;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.BufferUtils;

public class ImageManager {
    private final File data;
    private final ArrayList<URLAlias> urlAliases;
    private final Map<class_2960, Boolean> transparencyCache = new HashMap<class_2960, Boolean>();
    private final HashMap<String, ImageData> urlToImageData;
    private final HashMap<String, OverlayInfo> itemNameToOverlay;
    private final HashMap<String, ArrayList<ImageDataLoadInterface>> pendingImageLoads;
    public final ArrayList<String> blockedURLs;
    public final ArrayList<String> allowedDomains;
    public final ArrayList<String> imgurApiKeys;
    public boolean autoBlockNew = false;
    private boolean changesMade = false;

    public boolean hasPartialTransparency(class_2960 id) {
        return this.transparencyCache.getOrDefault(id, false);
    }

    private void checkAndCacheTransparency(class_2960 id, BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            this.transparencyCache.put(id, false);
            SignedPaintingsClient.info("Cannot check transparency for null BufferedImage: " + String.valueOf(id), false);
            return;
        }
        if (this.transparencyCache.containsKey(id)) {
            return;
        }
        boolean hasPartial = false;
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        try {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int color = bufferedImage.getRGB(x, y);
                    int alpha = color >> 24 & 0xFF;
                    if (alpha <= 0 || alpha >= 255) continue;
                    hasPartial = true;
                    break;
                }
                if (!hasPartial) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            SignedPaintingsClient.info("Error checking transparency for " + String.valueOf(id) + ": " + e.getMessage(), true);
        }
        this.transparencyCache.put(id, hasPartial);
    }

    public ImageManager() {
        this.urlAliases = new ArrayList();
        this.urlToImageData = new HashMap();
        this.itemNameToOverlay = new HashMap();
        this.pendingImageLoads = new HashMap();
        this.blockedURLs = new ArrayList();
        this.allowedDomains = new ArrayList();
        this.imgurApiKeys = new ArrayList();
        this.data = FabricLoader.getInstance().getConfigDir().resolve("signed_paintings.txt").toFile();
        try {
            if (this.data.exists()) {
                Scanner scanner = new Scanner(this.data);
                if (scanner.hasNextLine()) {
                    scanner.nextLine();
                }
                int phase = 0;
                int lines = 0;
                while (scanner.hasNextLine()) {
                    String s = scanner.nextLine();
                    if (s.startsWith("-")) {
                        ++phase;
                        lines = 0;
                        continue;
                    }
                    ++lines;
                    if (phase == 0) {
                        this.blockedURLs.add(s);
                        continue;
                    }
                    if (phase == 1) {
                        this.allowedDomains.add(s);
                        continue;
                    }
                    if (phase == 2) {
                        SignedPaintingsClient.loggingEnabled = s.equals("true");
                        continue;
                    }
                    if (phase == 3) {
                        boolean active = s.equals("true");
                        switch (lines) {
                            case 0: {
                                SignedPaintingsClient.renderSigns = active;
                            }
                            case 1: {
                                SignedPaintingsClient.renderBanners = active;
                            }
                            case 2: {
                                SignedPaintingsClient.renderShields = active;
                            }
                            case 3: {
                                SignedPaintingsClient.reduceCulling = active;
                            }
                            case 4: {
                                UIHelper.setBackgroundEnabled(active);
                            }
                        }
                        continue;
                    }
                    if (phase != 4) continue;
                    this.imgurApiKeys.add(s);
                }
                scanner.close();
            } else {
                this.changesMade = true;
            }
        }
        catch (IOException e) {
            SignedPaintingsClient.info("Failed to load data", true);
        }
        if (this.imgurApiKeys.isEmpty()) {
            this.imgurApiKeys.add("2b12ffa92e72e63");
            this.imgurApiKeys.add("274478faed23e08");
            this.imgurApiKeys.add("c1802a39166b9d0");
        }
    }

    public void save() {
        if (this.data.exists() && !this.changesMade) {
            return;
        }
        try {
            if (!this.data.exists()) {
                this.data.createNewFile();
            }
            FileWriter writer = new FileWriter(this.data);
            StringBuilder s = new StringBuilder("- Blocked Painting URLs -");
            for (String url : this.blockedURLs) {
                s.append("\n").append(url);
            }
            s.append("\n- Allowed URL Domains -");
            for (String url : this.allowedDomains) {
                s.append("\n").append(url);
            }
            s.append("\n- Detailed Logs -");
            s.append("\n").append(SignedPaintingsClient.loggingEnabled ? "true" : "false");
            s.append("\n- Rendering Toggles -");
            s.append("\n").append(SignedPaintingsClient.renderSigns ? "true" : "false");
            s.append("\n").append(SignedPaintingsClient.renderBanners ? "true" : "false");
            s.append("\n").append(SignedPaintingsClient.renderShields ? "true" : "false");
            s.append("\n").append(SignedPaintingsClient.reduceCulling ? "true" : "false");
            s.append("\n").append(UIHelper.isBackgroundEnabled() ? "true" : "false");
            s.append("\n- Imgur API Keys (get your own at https://api.imgur.com/oauth2/addclient) -");
            for (String key : this.imgurApiKeys) {
                s.append("\n").append(key);
            }
            writer.write(s.toString());
            writer.close();
            this.changesMade = false;
        }
        catch (IOException e) {
            SignedPaintingsClient.info("Failed to save data", true);
        }
    }

    public void loadImage(String url, ImageDataLoadInterface onLoadCallback) {
        boolean blocked;
        if (url.equals("https://")) {
            return;
        }
        ImageData imageData = this.urlToImageData.get(url);
        boolean bl = blocked = this.blockedURLs.contains(url) || this.domainBlocked(url);
        if (!blocked && this.autoBlockNew) {
            SignedPaintingsClient.sayRaw(class_2561.method_43469((String)"signed_paintings.commands.block.notify.base", (Object[])new Object[]{class_2561.method_43469((String)"signed_paintings.commands.block.notify.text", (Object[])new Object[]{url}).method_10862(class_2583.field_24360.method_27703(SignedPaintingsClient.textColor).method_10958((class_2558)new class_2558.class_10610("/paintings:block remove " + url)))}).method_10862(class_2583.field_24360.method_27703(SignedPaintingsClient.nameTextColor)));
            this.blockedURLs.add(url);
            blocked = true;
        }
        if (imageData != null) {
            if (imageData.ready || blocked) {
                onLoadCallback.onLoad(imageData);
            } else {
                this.pendingImageLoads.get(url).add(onLoadCallback);
            }
        } else {
            ArrayList<ImageDataLoadInterface> list = new ArrayList<ImageDataLoadInterface>();
            list.add(onLoadCallback);
            this.registerImage(url, list, blocked);
        }
    }

    private void registerImage(String url, ArrayList<ImageDataLoadInterface> onLoadCallbacks, boolean blocked) {
        ImageData data = new ImageData();
        this.urlToImageData.put(url, data);
        if (blocked) {
            for (ImageDataLoadInterface imageDataLoadInterface : onLoadCallbacks) {
                imageDataLoadInterface.onLoad(data);
            }
            return;
        }
        this.pendingImageLoads.put(url, onLoadCallbacks);
        SignedPaintingsClient.info("Started loading image from " + url, false);
        this.downloadImageBuffer(url).orTimeout(60L, TimeUnit.SECONDS).handleAsync((image, ex) -> {
            if (image == null || ex != null) {
                this.urlToImageData.remove(url);
                SignedPaintingsClient.info("Couldn't load image " + url + "\n" + ex.toString(), true);
            } else {
                SignedPaintingsClient.info("Loaded image " + url, false);
                this.onImageLoad((BufferedImage)image, url, data);
                for (ImageDataLoadInterface imageDataLoadInterface : onLoadCallbacks) {
                    imageDataLoadInterface.onLoad(data);
                }
                this.pendingImageLoads.remove(url);
            }
            return null;
        });
    }

    private void onImageLoad(BufferedImage image, String url, ImageData data) {
        class_2960 identifier = class_2960.method_60655((String)"signed_paintings", (String)this.createIdentifierSafeStringFromURL(url));
        ImageManager.saveBufferedImageAsIdentifier(image, identifier);
        data.onImageReady(image, identifier);
        SignedPaintingsClient.info("Ready to render Image " + url, true);
    }

    private String createIdentifierSafeStringFromURL(String url) {
        StringBuilder builder = new StringBuilder();
        url = url.toLowerCase(Locale.ROOT);
        for (int i = 0; i < url.length(); ++i) {
            char character = url.charAt(i);
            if (!(character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '/') && character != '.') continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static void saveBufferedImageAsIdentifier(BufferedImage bufferedImage, class_2960 identifier) {
        block4: {
            try {
                if (SignedPaintingsClient.imageManager != null) {
                    SignedPaintingsClient.imageManager.checkAndCacheTransparency(identifier, bufferedImage);
                } else {
                    SignedPaintingsClient.info("ImageManager instance not available for transparency check: " + String.valueOf(identifier), true);
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", stream);
                byte[] bytes = stream.toByteArray();
                ByteBuffer data = BufferUtils.createByteBuffer((int)bytes.length).put(bytes);
                data.flip();
                class_310.method_1551().execute(() -> {
                    try {
                        class_1011 img = class_1011.method_4324((ByteBuffer)data);
                        class_1043 texture = new class_1043(() -> ((class_2960)identifier).toString(), img);
                        class_310.method_1551().method_1531().method_4616(identifier, (class_1044)texture);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Throwable e) {
                SignedPaintingsClient.info("Failed to convert/register BufferedImage for identifier \"" + String.valueOf(identifier) + "\": " + e.getMessage(), true);
                if (SignedPaintingsClient.imageManager == null) break block4;
                SignedPaintingsClient.imageManager.transparencyCache.put(identifier, false);
            }
        }
    }

    public static void removeImage(class_2960 identifier) {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4615(identifier));
    }

    public static boolean hasImage(class_2960 identifier) {
        return ImageManager.getTexture(identifier) != null;
    }

    public static class_1044 getTexture(class_2960 identifier) {
        return ((TextureManagerAccessor)SignedPaintingsClient.client.method_1531()).getTextures().get(identifier);
    }

    private CompletableFuture<BufferedImage> downloadImageBuffer(String urlStr) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (ImageManager.isValid(urlStr)) {
                    URLConnection connection = URI.create(urlStr).toURL().openConnection();
                    connection.setRequestProperty("User-Agent", "Signed Paintings mod");
                    connection.setRequestProperty("Sec-Fetch-Site", "same-site");
                    connection.setRequestProperty("Referer", "https://imgur.com/");
                    connection.connect();
                    return ImageIO.read(connection.getInputStream());
                }
                SignedPaintingsClient.info("invalid url string " + urlStr, false);
                return null;
            }
            catch (Throwable e) {
                SignedPaintingsClient.info("error downloading image: " + String.valueOf(e), true);
                return null;
            }
        });
    }

    public static boolean isValid(String url) {
        try {
            URI.create(url).toURL();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void registerURLAlias(URLAlias urlAlias) {
        this.urlAliases.add(urlAlias);
    }

    public void registerAllowedDomain(String url) {
        if (this.allowedDomains.contains(url)) {
            return;
        }
        this.allowedDomains.add(url);
    }

    public boolean domainBlocked(String url) {
        for (String allowed : this.allowedDomains) {
            if (!url.startsWith(allowed)) continue;
            return false;
        }
        return true;
    }

    public String applyURLInferences(String text) {
        Object url;
        int index;
        if (((String)text).startsWith("ftp://")) {
            return text;
        }
        if (((String)text).contains("i.imgur.com") && (index = ((String)text).lastIndexOf(46)) != -1) {
            String file = ((String)text).substring(index);
            String domain = ((String)text).substring(0, index);
            if (file.length() > 4 && (file.startsWith(".png") || file.startsWith(".gif") || file.startsWith(".jpg"))) {
                text = domain + file.substring(0, 4);
            }
        }
        if (!((String)(url = this.applyURLAliases((String)text))).contains("://")) {
            url = "https://" + (String)url;
        }
        if (((String)url).startsWith("https://images-ext-1.discordapp.net/external/")) {
            url = "https://" + ((String)url).replaceAll(".*https/", "");
        }
        return url;
    }

    private String applyURLAliases(String text) {
        String url = text.contains("://") ? text.split("://", 2)[1] : text;
        for (URLAlias urlAlias : this.urlAliases) {
            url = urlAlias.tryApply(url);
        }
        return url;
    }

    public String getShortestURLInference(String url) {
        if (url.startsWith("https://")) {
            url = url.substring(8);
        }
        for (URLAlias urlAlias : this.urlAliases) {
            url = urlAlias.getShortestAlias(url);
        }
        return url;
    }

    public int reloadAll() {
        this.pendingImageLoads.clear();
        int i = 0;
        for (ImageData imageData : this.urlToImageData.values()) {
            i += imageData.reload();
        }
        this.urlToImageData.clear();
        this.itemNameToOverlay.clear();
        return i;
    }

    public int reloadUrl(String url) {
        ImageData imageData = this.urlToImageData.remove(url);
        if (imageData != null) {
            return imageData.reload();
        }
        return 0;
    }

    public ArrayList<ImageStatus> getAllStatus() {
        ArrayList<ImageStatus> imageStatuses = new ArrayList<ImageStatus>();
        this.urlToImageData.forEach((url, imageData) -> imageStatuses.add(imageData.getStatus().setUrl((String)url)));
        return imageStatuses;
    }

    public ImageStatus getUrlStatus(String url) {
        ImageData imageData = this.urlToImageData.get(url);
        if (imageData != null) {
            return imageData.getStatus().setUrl(url);
        }
        return null;
    }

    public int getUrlSuggestions(SuggestionsBuilder builder) {
        for (Map.Entry<String, ImageData> entry : this.urlToImageData.entrySet()) {
            if (!entry.getValue().ready) continue;
            builder.suggest(entry.getKey());
        }
        return this.urlToImageData.size();
    }

    public Set<String> getUrls() {
        return this.urlToImageData.keySet();
    }

    public OverlayInfo getOverlayInfo(String name) {
        OverlayInfo info = this.itemNameToOverlay.get(name);
        if (info == null || info.needsReload()) {
            info = new OverlayInfo();
            info.loadOverlay(name);
            this.itemNameToOverlay.put(name, info);
        }
        return info;
    }

    public void makeChange() {
        this.changesMade = true;
    }
}

