/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.util;

import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.util.ImageManager;
import com.nettakrim.signed_paintings.util.ImageStatus;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import org.joml.Vector2i;

public class ImageData {
    private BufferedImage baseImage;
    private class_2960 baseIdentifier;
    private class_2960 workingIdentifier;
    private final HashMap<Vector2i, class_2960> images = new HashMap();
    public boolean ready = false;
    public boolean needsReload = false;
    public int width;
    public int height;
    private int workingWidth;
    private int workingHeight;

    public void onImageReady(BufferedImage image, class_2960 baseIdentifier) {
        this.baseImage = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.baseIdentifier = baseIdentifier;
        SignedPaintingsClient.info(baseIdentifier.toString(), false);
        this.workingIdentifier = baseIdentifier.method_48331("_working");
        Vector2i d = new Vector2i(this.width, this.height);
        this.images.put(d, baseIdentifier);
        this.ready = true;
    }

    public class_2960 getBaseIdentifier() {
        return this.baseIdentifier;
    }

    public class_2960 getIdentifier(int width, int height, boolean working) {
        Vector2i resolution = new Vector2i(width, height);
        class_2960 identifier = this.images.get(resolution);
        if (identifier != null) {
            return identifier;
        }
        if (working) {
            if (width != this.workingWidth || height != this.workingHeight) {
                this.workingWidth = width;
                this.workingHeight = height;
                ImageManager.saveBufferedImageAsIdentifier(this.scaleImage(this.baseImage, width, height), this.workingIdentifier);
            }
            return this.workingIdentifier;
        }
        class_2960 newIdentifier = this.baseIdentifier.method_48331("_" + width + "x" + height);
        ImageManager.saveBufferedImageAsIdentifier(this.scaleImage(this.baseImage, width, height), newIdentifier);
        this.images.put(resolution, newIdentifier);
        return newIdentifier;
    }

    private BufferedImage scaleImage(BufferedImage referenceImage, int width, int height) {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        BufferedImage resizedImage = new BufferedImage(width, height, referenceImage.getType());
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.drawImage(referenceImage, 0, 0, width, height, null);
        graphics2D.dispose();
        return resizedImage;
    }

    public int reload() {
        this.ready = false;
        int i = 0;
        if (ImageManager.hasImage(this.workingIdentifier)) {
            ++i;
        }
        ImageManager.removeImage(this.baseIdentifier);
        ImageManager.removeImage(this.workingIdentifier);
        for (class_2960 identifier : this.images.values()) {
            ImageManager.removeImage(identifier);
            ++i;
        }
        this.needsReload = true;
        this.images.clear();
        return i;
    }

    public ImageStatus getStatus() {
        ImageStatus imageStatus = new ImageStatus();
        this.images.forEach((key, value) -> imageStatus.addResolution((Vector2i)key, this.getBytes(Objects.requireNonNull(((class_1043)ImageManager.getTexture(value)).method_4525())), value != this.baseIdentifier));
        imageStatus.ready = this.ready;
        return imageStatus;
    }

    private long getBytes(class_1011 image) {
        long bytesPerPixel = image.method_4318().method_4335();
        return (long)(image.method_4307() * image.method_4323()) * bytesPerPixel;
    }
}

