/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.commands.SignedPaintingsCommands;
import java.io.File;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class UploadCommand {
    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode uploadNode = ClientCommandManager.literal((String)"paintings:upload").build();
        LiteralCommandNode urlNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"url").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(UploadCommand::uploadUrl))).build();
        LiteralCommandNode screenshotNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"screenshot").then(ClientCommandManager.argument((String)"file", (ArgumentType)StringArgumentType.greedyString()).suggests(SignedPaintingsCommands.screenshots).executes(UploadCommand::uploadScreenshot))).build();
        LiteralCommandNode fileNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"file").then(ClientCommandManager.argument((String)"file", (ArgumentType)StringArgumentType.greedyString()).executes(UploadCommand::uploadFile))).build();
        uploadNode.addChild((CommandNode)urlNode);
        uploadNode.addChild((CommandNode)screenshotNode);
        uploadNode.addChild((CommandNode)fileNode);
        return uploadNode;
    }

    private static int uploadUrl(CommandContext<FabricClientCommandSource> context) {
        String url = StringArgumentType.getString(context, (String)"url");
        class_5250 text = class_2561.method_43469((String)"signed_paintings.commands.upload", (Object[])new Object[]{url}).method_10862(SignedPaintingsClient.getUrlButton(url));
        SignedPaintingsClient.say(text);
        SignedPaintingsClient.uploadManager.uploadUrlToImgur(SignedPaintingsClient.imageManager.applyURLInferences(url), UploadCommand::onLoad);
        return 1;
    }

    private static int uploadScreenshot(CommandContext<FabricClientCommandSource> context) {
        String filename = StringArgumentType.getString(context, (String)"file");
        return UploadCommand.uploadFile(SignedPaintingsClient.getScreenshotDirectory() + filename);
    }

    private static int uploadFile(CommandContext<FabricClientCommandSource> context) {
        String filename = StringArgumentType.getString(context, (String)"file");
        return UploadCommand.uploadFile(filename);
    }

    private static int uploadFile(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            SignedPaintingsClient.say("signed_paintings.commands.upload.no_file", filename);
            return -1;
        }
        class_5250 text = class_2561.method_43469((String)"signed_paintings.commands.upload", (Object[])new Object[]{filename}).method_10862(SignedPaintingsClient.getUrlButton(filename));
        SignedPaintingsClient.say(text);
        SignedPaintingsClient.uploadManager.uploadFileToImgur(file, UploadCommand::onLoad);
        return 1;
    }

    private static void onLoad(String link) {
        if (link != null) {
            class_5250 text = class_2561.method_43469((String)"signed_paintings.commands.upload.done", (Object[])new Object[]{link}).method_10862(SignedPaintingsClient.getUrlButton(link));
            SignedPaintingsClient.say(text);
        } else {
            SignedPaintingsClient.say("commands.upload.fail", new Object[0]);
        }
    }
}

