/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.commands.SignedPaintingsCommands;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class BlockCommand {
    public static final SuggestionProvider<FabricClientCommandSource> blocked = (context, builder) -> {
        for (String url : SignedPaintingsClient.imageManager.blockedURLs) {
            builder.suggest(url);
        }
        if (SignedPaintingsClient.imageManager.blockedURLs.size() >= 2) {
            builder.suggest("all");
        }
        return CompletableFuture.completedFuture(builder.build());
    };

    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode blockNode = ClientCommandManager.literal((String)"paintings:block").build();
        LiteralCommandNode addNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).suggests(SignedPaintingsCommands.images).executes(BlockCommand::block))).build();
        LiteralCommandNode removeNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).suggests(blocked).executes(BlockCommand::unblock))).build();
        LiteralCommandNode listNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").executes(BlockCommand::list)).build();
        LiteralCommandNode autoNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"auto").executes(BlockCommand::auto)).build();
        blockNode.addChild((CommandNode)addNode);
        blockNode.addChild((CommandNode)removeNode);
        blockNode.addChild((CommandNode)listNode);
        blockNode.addChild((CommandNode)autoNode);
        return blockNode;
    }

    private static int block(CommandContext<FabricClientCommandSource> context) {
        String url = StringArgumentType.getString(context, (String)"url");
        if (url.equals("all")) {
            SignedPaintingsClient.imageManager.blockedURLs.addAll(SignedPaintingsClient.imageManager.getUrls());
            class_5250 text = class_2561.method_43471((String)"signed_paintings.commands.block.add.all");
            for (String newBlock : SignedPaintingsClient.imageManager.getUrls()) {
                text.method_10852((class_2561)class_2561.method_43469((String)"signed_paintings.commands.block.list", (Object[])new Object[]{newBlock}).method_10862(SignedPaintingsClient.getUrlButton(newBlock)));
            }
            SignedPaintingsClient.imageManager.reloadAll();
            SignedPaintingsClient.longSay(text);
        } else {
            SignedPaintingsClient.imageManager.blockedURLs.add(url);
            SignedPaintingsClient.imageManager.reloadUrl(url);
            SignedPaintingsClient.sayStyled("commands.block.add", SignedPaintingsClient.getUrlButton(url), url);
        }
        SignedPaintingsClient.imageManager.makeChange();
        return 1;
    }

    private static int unblock(CommandContext<FabricClientCommandSource> context) {
        String url = StringArgumentType.getString(context, (String)"url");
        boolean success = true;
        if (SignedPaintingsClient.imageManager.autoBlockNew) {
            BlockCommand.auto(context);
        }
        if (url.equals("all")) {
            SignedPaintingsClient.imageManager.blockedURLs.clear();
            SignedPaintingsClient.imageManager.reloadAll();
            SignedPaintingsClient.say("commands.block.remove.all", new Object[0]);
        } else {
            success = SignedPaintingsClient.imageManager.blockedURLs.remove(url);
            SignedPaintingsClient.imageManager.reloadUrl(url);
            SignedPaintingsClient.sayStyled("commands.block.remove", SignedPaintingsClient.getUrlButton(url), url);
        }
        if (success) {
            SignedPaintingsClient.imageManager.makeChange();
        }
        return success ? 1 : 0;
    }

    private static int list(CommandContext<FabricClientCommandSource> context) {
        class_5250 text = class_2561.method_43471((String)"signed_paintings.commands.block.list.start");
        for (String url : SignedPaintingsClient.imageManager.blockedURLs) {
            text.method_10852((class_2561)class_2561.method_43469((String)"signed_paintings.commands.block.list", (Object[])new Object[]{url}).method_10862(SignedPaintingsClient.getUrlButton(url)));
        }
        if (SignedPaintingsClient.imageManager.blockedURLs.isEmpty()) {
            text.method_10852((class_2561)class_2561.method_43471((String)"signed_paintings.commands.block.list.none"));
        }
        SignedPaintingsClient.longSay(text);
        return 1;
    }

    private static int auto(CommandContext<FabricClientCommandSource> context) {
        boolean bl = SignedPaintingsClient.imageManager.autoBlockNew = !SignedPaintingsClient.imageManager.autoBlockNew;
        if (SignedPaintingsClient.imageManager.autoBlockNew) {
            SignedPaintingsClient.longSay(class_2561.method_43471((String)"signed_paintings.commands.block.auto.on"));
        } else {
            SignedPaintingsClient.say("commands.block.auto.off", new Object[0]);
        }
        return 1;
    }
}

