/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.mixin.compat.glfw;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.compat.CursorTracker;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursor;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={GLFW.class}, remap=false)
public abstract class GLFWMixin {
    @WrapMethod(method={"nglfwCreateCursor"})
    private static long trackCustomCursor(long image, int xhot, int yhot, Operation<Long> original) {
        if (ExternalCursorTracker.consumeInternalCursor(image)) {
            return (Long)original.call(new Object[]{image, xhot, yhot});
        }
        String packageName = ExternalCursorTracker.getWalker().walk(ExternalCursorTracker::getCallerPackage);
        long id = (Long)original.call(new Object[]{image, xhot, yhot});
        if (ExternalCursorTracker.isInternalPackage(packageName)) {
            return id;
        }
        ExternalCursorTracker.trackCursor(id, packageName.hashCode());
        MinecraftCursor.LOGGER.warn("[minecraft-cursor] Detected custom cursor from '{}'. Expect compatibility issues.", (Object)packageName);
        return id;
    }

    @WrapMethod(method={"glfwCreateStandardCursor"})
    private static long mapStandardCursor(int shape, Operation<Long> original) {
        CursorType cursorType;
        long id = (Long)original.call(new Object[]{shape});
        switch (shape) {
            case 221185: {
                CursorType cursorType2 = CursorType.DEFAULT;
                break;
            }
            case 221188: {
                CursorType cursorType2 = CursorType.POINTER;
                break;
            }
            case 221186: {
                CursorType cursorType2 = CursorType.TEXT;
                break;
            }
            case 221187: {
                CursorType cursorType2 = CursorType.CROSSHAIR;
                break;
            }
            case 221189: {
                CursorType cursorType2 = CursorType.RESIZE_EW;
                break;
            }
            case 221190: {
                CursorType cursorType2 = CursorType.RESIZE_NS;
                break;
            }
            case 221191: {
                CursorType cursorType2 = CursorType.RESIZE_NWSE;
                break;
            }
            case 221192: {
                CursorType cursorType2 = CursorType.RESIZE_NESW;
                break;
            }
            case 221193: {
                CursorType cursorType2 = CursorType.GRABBING;
                break;
            }
            case 221194: {
                CursorType cursorType2 = CursorType.NOT_ALLOWED;
                break;
            }
            default: {
                CursorType cursorType2 = cursorType = null;
            }
        }
        if (cursorType != null) {
            ExternalCursor externalCursor = ExternalCursorTracker.get().getTrackedCursor(id);
            if (externalCursor == null) {
                String packageName = ExternalCursorTracker.getWalker().walk(ExternalCursorTracker::getCallerPackage);
                MinecraftCursor.LOGGER.info("[minecraft-cursor] Remapping cursor to '{}' from '{}'", (Object)cursorType.getKey(), (Object)packageName);
                ExternalCursorTracker.trackCursor(id, packageName.hashCode(), cursorType);
            } else {
                externalCursor.update(cursorType);
            }
        }
        return id;
    }

    @WrapMethod(method={"glfwDestroyCursor"})
    private static void removeCursor(long cursor, Operation<Void> original) {
        original.call(new Object[]{cursor});
        ExternalCursorTracker.get().untrackCursor(cursor);
    }

    @WrapMethod(method={"glfwSetCursor"})
    private static void setMinecraftCursor(long window, long cursor, Operation<Void> original) {
        if (!ExternalCursorTracker.isTracking() || window != CursorTypeUtil.WINDOW || !MinecraftCursor.CONFIG.isRemapCursorsEnabled()) {
            original.call(new Object[]{window, cursor});
            return;
        }
        CursorTracker tracker = ExternalCursorTracker.get();
        if (!tracker.isTracking(cursor) && cursor != 0L) {
            original.call(new Object[]{window, cursor});
            return;
        }
        if (cursor == 0L) {
            String packageName = ExternalCursorTracker.getWalker().walk(ExternalCursorTracker::getCallerPackage);
            if (ExternalCursorTracker.isInternalPackage(packageName)) {
                original.call(new Object[]{window, cursor});
            } else {
                tracker.updateCursor(packageName.hashCode(), CursorType.DEFAULT);
                if (!tracker.isCustom()) {
                    original.call(new Object[]{window, CursorManager.INSTANCE.getCurrentId()});
                }
            }
            return;
        }
        ExternalCursor trackedCursor = tracker.getTrackedCursor(cursor);
        if (trackedCursor == null || trackedCursor.getCursorType() == ExternalCursor.CUSTOM || !CursorManager.INSTANCE.isEnabled(trackedCursor.getCursorType())) {
            original.call(new Object[]{window, cursor});
            tracker.updateCursor(trackedCursor == null ? 0 : trackedCursor.getCaller(), ExternalCursor.CUSTOM);
            return;
        }
        tracker.updateCursor(trackedCursor.getCaller(), trackedCursor.getCursorType());
        if (!tracker.isCustom()) {
            original.call(new Object[]{window, CursorManager.INSTANCE.getCurrentId()});
        }
    }
}

