/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.widget.OptionsListWidget;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdaptiveOptionsPanel
extends AbstractOptionsPanel {
    private static final class_7919 ADAPTIVE_INFO = class_7919.method_47407((class_2561)class_2561.method_43471((String)"minecraft-cursor.options.adapt.tooltip"));
    private static final class_2561 ITEM_SLOT = class_2561.method_43471((String)"minecraft-cursor.options.adapt.item_slot");
    private static final class_2561 ITEM_GRAB = class_2561.method_43471((String)"minecraft-cursor.options.adapt.item_grab");
    private static final class_2561 CREATIVE_TABS = class_2561.method_43471((String)"minecraft-cursor.options.adapt.creative_tabs");
    private static final class_2561 ENCHANTMENTS = class_2561.method_43471((String)"minecraft-cursor.options.adapt.enchantments");
    private static final class_2561 STONECUTTER = class_2561.method_43471((String)"minecraft-cursor.options.adapt.stonecutter");
    private static final class_2561 LOOM = class_2561.method_43471((String)"minecraft-cursor.options.adapt.loom");
    private static final class_2561 ADVANCEMENTS = class_2561.method_43471((String)"minecraft-cursor.options.adapt.advancements");
    private static final class_2561 WORLD = class_2561.method_43471((String)"minecraft-cursor.options.adapt.world");
    private static final class_2561 SERVER = class_2561.method_43471((String)"minecraft-cursor.options.adapt.server");
    private static final class_2561 INACTIVE_WIDGETS = class_2561.method_43471((String)"minecraft-cursor.options.adapt.inactive_widgets");
    private static final int CURSOR_SIZE_STEP = 8;
    private final CursorAnimationHelper animationHelper;
    private final Runnable refreshCursors;
    private OptionsListWidget optionsList;

    public AdaptiveOptionsPanel(class_2561 title, CursorAnimationHelper animationHelper, Runnable refreshCursors) {
        super(title);
        this.animationHelper = animationHelper;
        this.refreshCursors = refreshCursors;
    }

    @Override
    protected void initContents() {
        this.optionsList = new OptionsListWidget(this.getMinecraft(), this.getFont(), 20, this.getSpacing());
        boolean adaptive = CursorManager.INSTANCE.isAdaptive();
        this.optionsList.addToggle(adaptive, this::toggleAdaptive, ENABLE_TEXT, ADAPTIVE_INFO, true);
        this.addOption(MinecraftCursor.CONFIG.isItemSlotEnabled(), MinecraftCursor.CONFIG::setItemSlotEnabled, ITEM_SLOT, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isItemGrabbingEnabled(), MinecraftCursor.CONFIG::setItemGrabbingEnabled, ITEM_GRAB, CursorType.GRABBING, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isInactiveWidgetsEnabled(), MinecraftCursor.CONFIG::setInactiveWidgetsEnabled, INACTIVE_WIDGETS, CursorType.NOT_ALLOWED, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isCreativeTabsEnabled(), MinecraftCursor.CONFIG::setCreativeTabsEnabled, CREATIVE_TABS, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isEnchantmentsEnabled(), MinecraftCursor.CONFIG::setEnchantmentsEnabled, ENCHANTMENTS, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isStonecutterRecipesEnabled(), MinecraftCursor.CONFIG::setStonecutterRecipesEnabled, STONECUTTER, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isLoomPatternsEnabled(), MinecraftCursor.CONFIG::setLoomPatternsEnabled, LOOM, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isAdvancementTabsEnabled(), MinecraftCursor.CONFIG::setAdvancementTabsEnabled, ADVANCEMENTS, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isWorldIconEnabled(), MinecraftCursor.CONFIG::setWorldIconEnabled, WORLD, CursorType.POINTER, adaptive);
        this.addOption(MinecraftCursor.CONFIG.isServerIconEnabled(), MinecraftCursor.CONFIG::setServerIconEnabled, SERVER, CursorType.POINTER, adaptive);
        this.optionsList.search(this.getSearch());
        this.addRenderableWidget(this.optionsList);
    }

    private void addOption(boolean value, Consumer<Boolean> consumer, class_2561 label, CursorType cursorType, boolean active) {
        this.optionsList.addToggle(value && active, consumer, this.index(label), this.prefixCursor(cursorType), null, active);
    }

    private OptionsListWidget.Prefix prefixCursor(CursorType cursorType) {
        Cursor cursor = Objects.requireNonNull(CursorManager.INSTANCE.getCursor(cursorType));
        return (guiGraphics, font, x, y, height) -> {
            int adjustedHeight = height - height % 8;
            int offsetY = y + (height - adjustedHeight) / 2;
            this.animationHelper.drawSprite(guiGraphics, cursor, x, offsetY, adjustedHeight);
            return adjustedHeight;
        };
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.optionsList != null) {
            this.optionsList.method_55445(this.getWidth(), this.computeMaxHeight(y));
            this.optionsList.method_48229(x, y);
        }
    }

    @Override
    protected void searched(@NotNull String search, @Nullable class_2561 matched) {
        if (this.optionsList != null) {
            this.optionsList.search(search);
        }
    }

    private void toggleAdaptive(boolean adaptive) {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            if (cursor.getType().isDefault()) continue;
            Cursor loadedCursor = cursor;
            if (adaptive && !cursor.isLoaded() && this.loadCursor(cursor)) {
                loadedCursor = Objects.requireNonNull(CursorManager.INSTANCE.getCursor(cursor.getType()));
            }
            loadedCursor.enable(adaptive);
            MinecraftCursor.CONFIG.getOrCreateSettings(loadedCursor).setEnabled(adaptive);
        }
        this.refreshCursors.run();
        this.refreshWidgets();
        this.repositionElements();
    }
}

