/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogBrowserScreen;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogItem;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.AdaptiveOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.CompatibilityOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.CursorOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.DebugOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.GlobalOptionsPanel;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_8021;
import org.jetbrains.annotations.NotNull;

public class ConfigurationScreen
extends CatalogBrowserScreen {
    private static final class_2561 GLOBAL_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.global");
    private static final class_2561 ADAPTIVE_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.adapt");
    private static final class_2561 COMPAT_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.compat");
    private static final class_2561 CURSORS_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.cursor-types");
    private static final class_2561 DEBUG_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.debug");
    private static final int SPACING = 8;
    private static final int HEADER_HEIGHT = 20;
    private static final int SIDEBAR_WIDTH = 140;
    private static final int MAX_CONTENT_WIDTH = 264;
    private static final int LIST_CURSOR_SIZE = 16;
    private static final CatalogItem GLOBAL_CATEGORY = new CatalogItem("global", GLOBAL_TEXT);
    private static final CatalogItem CURSORS_CATEGORY = new CatalogItem("cursors", CURSORS_TEXT);
    private final CursorAnimationHelper animationHelper = new CursorAnimationHelper();
    private CatalogItem defaultItem;

    public ConfigurationScreen(class_437 previous) {
        super((class_2561)class_2561.method_43471((String)"minecraft-cursor.options"), 20, 140, 264, 8, previous);
    }

    @Override
    public void method_25419() {
        MinecraftCursor.CONFIG.save();
        super.method_25419();
    }

    @Override
    protected void initItems() {
        this.addGlobalItems();
        this.addAdaptiveItems();
        this.addCursorItems();
        this.addCompatibilityItems();
        this.addDebugItems();
    }

    @Override
    protected void postInit() {
        this.selectItem(this.defaultItem);
    }

    private void addGlobalItems() {
        this.addCategoryOnly(GLOBAL_CATEGORY, new GlobalOptionsPanel(this::refreshCursors));
    }

    private void addAdaptiveItems() {
        this.addCategoryOnly(new CatalogItem("adaptive", ADAPTIVE_TEXT), new AdaptiveOptionsPanel(ADAPTIVE_TEXT, this.animationHelper, this::refreshCursors));
    }

    private void addCompatibilityItems() {
        this.addCategoryOnly(new CatalogItem("compatibility", COMPAT_TEXT), new CompatibilityOptionsPanel(COMPAT_TEXT));
    }

    private void addCursorItems() {
        for (CatalogItem cursorItem : this.createCursorItems()) {
            if (CursorType.DEFAULT.getKey().equals(cursorItem.id())) {
                this.defaultItem = cursorItem;
            }
            this.addOrUpdateItem(CURSORS_CATEGORY, cursorItem, new CursorOptionsPanel(this.animationHelper, this::refreshCursors, GLOBAL_CATEGORY, Objects.requireNonNull(CursorManager.INSTANCE.getCursor(cursorItem.id()))));
        }
    }

    private void addDebugItems() {
        this.addCategoryOnly(new CatalogItem("debug", DEBUG_TEXT), new DebugOptionsPanel(DEBUG_TEXT));
    }

    private int renderListCursor(class_332 guiGraphics, class_327 font, CatalogItem item, class_8021 bounds, int spacing, int mouseX, int mouseY, float partialTick) {
        Cursor cursor = CursorManager.INSTANCE.getCursor(item.id());
        if (cursor != null && cursor.isLoaded()) {
            int prefixX = bounds.method_46426() + spacing;
            int prefixY = bounds.method_46427() + (bounds.method_25364() - 16) / 2;
            this.animationHelper.drawSprite(guiGraphics, cursor, prefixX, prefixY, 16);
        }
        return 16;
    }

    private void refreshCursors() {
        this.addCursorItems();
        this.refreshItems();
    }

    private List<CatalogItem> createCursorItems() {
        return CursorManager.INSTANCE.getCursors().stream().map(cursor -> new CatalogItem(cursor.getTypeKey(), (class_2561)cursor.getText().method_27661().method_27692(ConfigurationScreen.getCursorFormat(cursor)), this::renderListCursor)).toList();
    }

    private static class_124 getCursorFormat(@NotNull Cursor cursor) {
        if (cursor.isEnabled()) {
            return class_124.field_1068;
        }
        if (cursor.isLoaded()) {
            return class_124.field_1080;
        }
        return class_124.field_1063;
    }
}

