/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands.admin_subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.spyglass_astronomy.SpaceDataManager;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class YearLengthCommand {
    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode yearLengthNode = ClientCommandManager.literal((String)"yearlength").build();
        LiteralCommandNode queryNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"query").executes(YearLengthCommand::queryYearLength)).build();
        LiteralCommandNode resetNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reset").executes(YearLengthCommand::resetYearLength)).build();
        LiteralCommandNode setNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"days", (ArgumentType)FloatArgumentType.floatArg((float)0.125f)).executes(YearLengthCommand::setYearLength))).build();
        yearLengthNode.addChild((CommandNode)queryNode);
        yearLengthNode.addChild((CommandNode)resetNode);
        yearLengthNode.addChild((CommandNode)setNode);
        return yearLengthNode;
    }

    private static int setYearLength(CommandContext<FabricClientCommandSource> context) {
        return YearLengthCommand.setYearLength(FloatArgumentType.getFloat(context, (String)"days"));
    }

    private static int resetYearLength(CommandContext<FabricClientCommandSource> context) {
        return YearLengthCommand.setYearLength(8.0f);
    }

    public static int setYearLength(float yearLength) {
        SpyglassAstronomyClient.say("commands.admin.yearlength.set", Float.toString(yearLength), Float.toString(SpyglassAstronomyClient.spaceDataManager.getYearLength()));
        SpyglassAstronomyClient.spaceDataManager.setYearLength(yearLength);
        SpyglassAstronomyClient.generatePlanets(null, true);
        SpaceDataManager.makeChange();
        return 1;
    }

    private static int queryYearLength(CommandContext<FabricClientCommandSource> context) {
        SpyglassAstronomyClient.say("commands.admin.yearlength.query", Float.toString(SpyglassAstronomyClient.spaceDataManager.getYearLength()));
        return 1;
    }
}

