/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands.admin_subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.SpaceDataManager;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.StarLine;
import com.nettakrim.spyglass_astronomy.commands.SpyglassAstronomyCommands;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2196;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ConstellationsCommand {
    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode constellationsNode = ClientCommandManager.literal((String)"constellations").build();
        LiteralCommandNode addNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"data", (ArgumentType)class_2196.method_9340()).executes(ConstellationsCommand::addConstellation))).build();
        LiteralCommandNode removeNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").executes(ConstellationsCommand::removeSelectedConstellation)).then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2196.method_9340()).suggests(SpyglassAstronomyCommands.constellations).executes(ConstellationsCommand::removeConstellation))).build();
        LiteralCommandNode removeAllNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"removeall").executes(ConstellationsCommand::removeAllConstellations)).build();
        LiteralCommandNode generateNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"generate").executes(ConstellationsCommand::generateConstellations)).build();
        constellationsNode.addChild((CommandNode)addNode);
        constellationsNode.addChild((CommandNode)removeNode);
        constellationsNode.addChild((CommandNode)removeAllNode);
        constellationsNode.addChild((CommandNode)generateNode);
        return constellationsNode;
    }

    private static int addConstellation(CommandContext<FabricClientCommandSource> context) {
        String dataRaw = SpyglassAstronomyCommands.getMessageText(context, "data");
        int index = dataRaw.indexOf(32);
        if (index == -1) {
            SpyglassAstronomyClient.say("commands.admin.constellations.add.fail.data", dataRaw);
            return -1;
        }
        Constellation constellation = SpaceDataManager.decodeConstellation(null, dataRaw.substring(index + 1), dataRaw.substring(0, index));
        if (constellation.getLines().size() == 0) {
            SpyglassAstronomyClient.say("commands.admin.constellations.add.fail.data", constellation.name);
            return -1;
        }
        int max = 0;
        for (StarLine line : constellation.getLines()) {
            int star = line.getOtherStar(-1);
            max = Math.max(Math.max(line.getOtherStar(star), star), max);
        }
        if (max >= SpyglassAstronomyClient.getStarCount()) {
            if (max < 4096) {
                SpyglassAstronomyClient.say("commands.admin.constellations.add.fail.stars", constellation.name, max, SpyglassAstronomyClient.getStarCount());
            } else {
                SpyglassAstronomyClient.say("commands.admin.constellations.add.fail.data", constellation.name);
            }
            return -1;
        }
        return ConstellationsCommand.addConstellation(constellation, true, true);
    }

    public static int addConstellation(Constellation constellation, boolean select, boolean sayFeedback) {
        Constellation potentialMatch = null;
        for (Constellation targetConstellation : SpyglassAstronomyClient.constellations) {
            boolean intersects = false;
            boolean isDifferent = false;
            for (StarLine line : constellation.getLines()) {
                if (targetConstellation.lineIntersects(line)) {
                    intersects = true;
                } else {
                    isDifferent = true;
                }
                if (!intersects || !targetConstellation.hasNoMatchingLine(line)) continue;
                isDifferent = true;
                break;
            }
            if (!intersects) continue;
            if (!isDifferent) {
                for (StarLine line : targetConstellation.getLines()) {
                    if (!constellation.hasNoMatchingLine(line)) continue;
                    isDifferent = true;
                    break;
                }
            }
            if (isDifferent) {
                if (potentialMatch == null && !constellation.isUnnamed() && constellation.name.equals(targetConstellation.name)) {
                    potentialMatch = targetConstellation;
                    continue;
                }
                if (sayFeedback) {
                    SpyglassAstronomyClient.say("commands.admin.constellations.add.fail.collision", constellation.name, targetConstellation.name);
                }
                if (select) {
                    targetConstellation.select();
                }
                return -1;
            }
            if (constellation.isUnnamed() || constellation.name.equals(targetConstellation.name)) {
                if (sayFeedback) {
                    SpyglassAstronomyClient.say("commands.admin.constellations.add.fail.collision", constellation.name, targetConstellation.name);
                }
                if (select) {
                    targetConstellation.select();
                }
                return -1;
            }
            if (sayFeedback) {
                SpyglassAstronomyClient.say("commands.name.constellation.rename", targetConstellation.name, constellation.name);
            }
            targetConstellation.name = constellation.name;
            if (select) {
                targetConstellation.select();
            }
            SpaceDataManager.makeChange();
            return 1;
        }
        if (potentialMatch == null) {
            if (sayFeedback) {
                SpyglassAstronomyClient.say("commands.admin.constellations.add", constellation.name);
            }
        } else {
            if (sayFeedback) {
                SpyglassAstronomyClient.say("commands.admin.constellations.add.edit", potentialMatch.name);
            }
            ConstellationsCommand.clearConnections(potentialMatch);
            SpyglassAstronomyClient.constellations.remove(potentialMatch);
        }
        if (select) {
            constellation.select();
        }
        constellation.initaliseStarLines();
        SpyglassAstronomyClient.constellations.add(constellation);
        SpyglassAstronomyClient.spaceRenderingManager.scheduleConstellationsUpdate();
        SpaceDataManager.makeChange();
        return 1;
    }

    private static int removeConstellation(CommandContext<FabricClientCommandSource> context) {
        Constellation constellation = SpyglassAstronomyCommands.getConstellation(context);
        return ConstellationsCommand.removeConstellation(constellation);
    }

    private static int removeSelectedConstellation(CommandContext<FabricClientCommandSource> context) {
        Constellation constellation = Constellation.selected;
        Constellation.deselect();
        return ConstellationsCommand.removeConstellation(constellation);
    }

    private static int removeConstellation(Constellation constellation) {
        if (constellation == null) {
            SpyglassAstronomyClient.say("commands.admin.constellations.remove.nothingselected", new Object[0]);
            return -1;
        }
        SpyglassAstronomyClient.say("commands.admin.constellations.remove", constellation.name);
        ConstellationsCommand.clearConnections(constellation);
        SpyglassAstronomyClient.constellations.remove(constellation);
        SpyglassAstronomyClient.spaceRenderingManager.scheduleConstellationsUpdate();
        SpaceDataManager.makeChange();
        return 1;
    }

    private static int removeAllConstellations(CommandContext<FabricClientCommandSource> context) {
        SpyglassAstronomyClient.say("commands.admin.constellations.remove.all", SpyglassAstronomyClient.constellations.size());
        for (Constellation constellation : SpyglassAstronomyClient.constellations) {
            ConstellationsCommand.clearConnections(constellation);
        }
        SpyglassAstronomyClient.constellations.clear();
        SpyglassAstronomyClient.spaceRenderingManager.scheduleConstellationsUpdate();
        SpaceDataManager.makeChange();
        return 1;
    }

    private static int generateConstellations(CommandContext<FabricClientCommandSource> context) {
        class_5819 random = class_5819.method_43049((long)SpyglassAstronomyClient.spaceDataManager.getStarSeed());
        int constellations = random.method_39332(15, 20);
        int spawned = 0;
        float phi = (float)Math.PI * (class_3532.method_15355((float)5.0f) - 1.0f);
        for (int i = 0; i < constellations; ++i) {
            float x = 1.0f - (float)i / (float)(constellations - 1) * 2.0f;
            float radius = class_3532.method_15355((float)(1.0f - x * x));
            float theta = phi * (float)i;
            float y = class_3532.method_15362((float)theta) * radius;
            float z = class_3532.method_15374((float)theta) * radius;
            Vector3f position = new Vector3f(x, y, z);
            position.add(random.method_43057() * 0.3f - 0.15f, random.method_43057() * 0.3f - 0.15f, random.method_43057() * 0.3f - 0.15f);
            position.normalize();
            if (!ConstellationsCommand.createRandomConstellation(random, position)) continue;
            ++spawned;
        }
        SpyglassAstronomyClient.say("commands.admin.constellations.generate", Integer.toString(spawned));
        SpyglassAstronomyClient.spaceRenderingManager.scheduleConstellationsUpdate();
        SpaceDataManager.makeChange();
        return 1;
    }

    private static boolean createRandomConstellation(class_5819 random, Vector3f location) {
        Star lastStar = null;
        Vector3f lastPosition = location;
        int lines = 0;
        int maxLines = random.method_39332(4, 8);
        int maxConnections = random.method_39332(3, 5);
        float maxAngle = maxLines <= 5 ? 0.98f : (maxConnections <= 3 ? 0.975f : 0.97f);
        Constellation constellation = new Constellation();
        block0: while (lines < maxLines) {
            for (Star star : SpyglassAstronomyClient.stars) {
                Vector3f starPos;
                if (star.getAlpha() < random.method_43057() * 2.0f || (starPos = star.getPositionAsVector3f()).distanceSquared((Vector3fc)lastPosition) > 0.1f * (star.getAlpha() + 0.5f) || starPos.distanceSquared((Vector3fc)location) > 0.2f) continue;
                if (lastStar != null) {
                    StarLine starLine = new StarLine(star.index, lastStar.index, false);
                    Vector3f direction = new Vector3f((Vector3fc)starPos).sub((Vector3fc)lastPosition);
                    boolean failedCheck = false;
                    for (StarLine line : constellation.getLines()) {
                        Star[] stars;
                        if (!line.intersects(star.index, lastStar.index) || !(class_3532.method_15379((float)direction.angleCos((Vector3fc)(stars = line.getStars())[0].getPositionAsVector3f().sub((Vector3fc)stars[1].getPositionAsVector3f()))) > maxAngle)) continue;
                        failedCheck = true;
                        break;
                    }
                    if (failedCheck) continue;
                    constellation.addLine(starLine);
                    if (++lines >= maxLines) continue block0;
                }
                int connections = 0;
                for (StarLine line : constellation.getLines()) {
                    if (!line.hasStar(star.index)) continue;
                    ++connections;
                }
                if (connections < maxConnections && !(random.method_43057() * star.getAlpha() > 0.25f)) continue;
                lastStar = star;
                lastPosition = starPos;
            }
        }
        return ConstellationsCommand.addConstellation(constellation, false, false) == 1;
    }

    private static void clearConnections(Constellation constellation) {
        for (StarLine line : constellation.getLines()) {
            for (Star star : line.getStars()) {
                star.clearAllConnections();
            }
        }
    }
}

