/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.RootCommandNode;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import com.nettakrim.spyglass_astronomy.commands.AdminCommand;
import com.nettakrim.spyglass_astronomy.commands.HideCommand;
import com.nettakrim.spyglass_astronomy.commands.InfoCommand;
import com.nettakrim.spyglass_astronomy.commands.NameCommand;
import com.nettakrim.spyglass_astronomy.commands.SelectCommand;
import com.nettakrim.spyglass_astronomy.commands.ShareCommand;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2196;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class SpyglassAstronomyCommands {
    public static final SuggestionProvider<FabricClientCommandSource> constellations = (context, builder) -> {
        for (Constellation constellation : SpyglassAstronomyClient.constellations) {
            builder.suggest(constellation.name);
        }
        return CompletableFuture.completedFuture(builder.build());
    };
    public static final SuggestionProvider<FabricClientCommandSource> stars = (context, builder) -> {
        for (Star star : SpyglassAstronomyClient.stars) {
            if (star.isUnnamed()) continue;
            builder.suggest(star.name);
        }
        return CompletableFuture.completedFuture(builder.build());
    };
    public static final SuggestionProvider<FabricClientCommandSource> orbitingBodies = (context, builder) -> {
        for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
            if (orbitingBody.isUnnamed()) continue;
            builder.suggest(orbitingBody.name);
        }
        return CompletableFuture.completedFuture(builder.build());
    };

    public static void initialize() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            RootCommandNode root = dispatcher.getRoot();
            root.addChild(AdminCommand.getCommandNode());
            root.addChild(HideCommand.getCommandNode());
            root.addChild(InfoCommand.getCommandNode());
            root.addChild(NameCommand.getCommandNode());
            root.addChild(SelectCommand.getCommandNode());
            root.addChild(ShareCommand.getCommandNode());
        });
    }

    public static Constellation getConstellation(CommandContext<FabricClientCommandSource> context) {
        String name = SpyglassAstronomyCommands.getMessageText(context);
        for (Constellation constellation : SpyglassAstronomyClient.constellations) {
            if (!constellation.name.equals(name)) continue;
            return constellation;
        }
        SpyglassAstronomyClient.say("commands.find.constellation.fail", name);
        return null;
    }

    public static Star getStar(CommandContext<FabricClientCommandSource> context) {
        String name = SpyglassAstronomyCommands.getMessageText(context);
        for (Star star : SpyglassAstronomyClient.stars) {
            if (star.name == null || !star.name.equals(name)) continue;
            return star;
        }
        SpyglassAstronomyClient.say("commands.find.star.fail", name);
        return null;
    }

    public static OrbitingBody getOrbitingBody(CommandContext<FabricClientCommandSource> context) {
        String name = SpyglassAstronomyCommands.getMessageText(context);
        for (OrbitingBody orbitingBody : SpyglassAstronomyClient.orbitingBodies) {
            if (orbitingBody.name == null || !orbitingBody.name.equals(name)) continue;
            return orbitingBody;
        }
        SpyglassAstronomyClient.say("commands.find.planet.fail", name);
        return null;
    }

    public static String getMessageText(CommandContext<FabricClientCommandSource> context) {
        return SpyglassAstronomyCommands.getMessageText(context, "name");
    }

    public static String getMessageText(CommandContext<FabricClientCommandSource> context, String name) {
        class_2196.class_2197 messageFormat = (class_2196.class_2197)context.getArgument(name, class_2196.class_2197.class);
        return messageFormat.comp_2653();
    }

    public static class_2561 getClickHere(String actionKey, String command, boolean run, Object ... formatting) {
        return class_2561.method_43471((String)"spyglass_astronomy.commands.share.click").method_10862(class_2583.field_24360.method_10958((class_2558)(run ? new class_2558.class_10609(command) : new class_2558.class_10610(command))).method_27703(SpyglassAstronomyClient.buttonTextColor)).method_10852((class_2561)class_2561.method_43469((String)("spyglass_astronomy." + actionKey), (Object[])formatting).method_10862(class_2583.field_24360.method_27703(SpyglassAstronomyClient.textColor)));
    }
}

