/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.spyglass_astronomy.SpaceRenderingManager;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class HideCommand
implements Command<FabricClientCommandSource> {
    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode hideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sga:hide").executes((Command)new HideCommand())).build();
        LiteralCommandNode constellationsHideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"constellations").executes(HideCommand::hideConstellations)).build();
        LiteralCommandNode starsHideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"stars").executes(HideCommand::hideStars)).build();
        LiteralCommandNode orbitingBodiesHideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"planets").executes(HideCommand::hideOrbitingBodies)).build();
        LiteralCommandNode oldStarsHideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vanillastars").executes(HideCommand::hideOldStars)).build();
        LiteralCommandNode dayTimeHideNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"daytime").executes(HideCommand::hideDaytime)).build();
        hideNode.addChild((CommandNode)constellationsHideNode);
        hideNode.addChild((CommandNode)starsHideNode);
        hideNode.addChild((CommandNode)orbitingBodiesHideNode);
        hideNode.addChild((CommandNode)oldStarsHideNode);
        hideNode.addChild((CommandNode)dayTimeHideNode);
        return hideNode;
    }

    public int run(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        boolean active;
        SpaceRenderingManager.constellationsVisible = active = !SpaceRenderingManager.constellationsVisible && !SpaceRenderingManager.starsVisible && !SpaceRenderingManager.orbitingBodiesVisible && !SpaceRenderingManager.oldStarsVisible;
        SpaceRenderingManager.starsVisible = active;
        SpaceRenderingManager.orbitingBodiesVisible = active;
        SpaceRenderingManager.oldStarsVisible = false;
        HideCommand.sayHideUpdate("all", active);
        return 1;
    }

    private static int hideConstellations(CommandContext<FabricClientCommandSource> context) {
        SpaceRenderingManager.constellationsVisible = !SpaceRenderingManager.constellationsVisible;
        HideCommand.sayHideUpdate("constellations", SpaceRenderingManager.constellationsVisible);
        return 1;
    }

    private static int hideStars(CommandContext<FabricClientCommandSource> context) {
        SpaceRenderingManager.starsVisible = !SpaceRenderingManager.starsVisible;
        HideCommand.sayHideUpdate("stars", SpaceRenderingManager.starsVisible);
        return 1;
    }

    private static int hideOrbitingBodies(CommandContext<FabricClientCommandSource> context) {
        SpaceRenderingManager.orbitingBodiesVisible = !SpaceRenderingManager.orbitingBodiesVisible;
        HideCommand.sayHideUpdate("planets", SpaceRenderingManager.orbitingBodiesVisible);
        return 1;
    }

    private static int hideOldStars(CommandContext<FabricClientCommandSource> context) {
        SpaceRenderingManager.oldStarsVisible = !SpaceRenderingManager.oldStarsVisible;
        HideCommand.sayHideUpdate("vanillastars", SpaceRenderingManager.oldStarsVisible);
        return 1;
    }

    private static int hideDaytime(CommandContext<FabricClientCommandSource> context) {
        SpaceRenderingManager.starsAlwaysVisible = !SpaceRenderingManager.starsAlwaysVisible;
        HideCommand.sayHideUpdate("daytime", SpaceRenderingManager.starsAlwaysVisible);
        return 1;
    }

    private static void sayHideUpdate(String base, boolean active) {
        SpyglassAstronomyClient.say("commands.hide." + base + (active ? ".show" : ".hide"), new Object[0]);
    }
}

