/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.Star;
import net.minecraft.class_287;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class StarLine {
    public static float distance = 1.1f;
    public static float width = 0.15f;
    public static float visibilityMultiplier = 0.35f;
    private int starAIndex;
    private int starBIndex;
    private Vector3f starAPosition;
    private Vector3f starBPosition;
    private int[] starAColor;
    private int[] starBColor;
    private Vector3f vertexA1;
    private Vector3f vertexA2;
    private Vector3f vertexB1;
    private Vector3f vertexB2;

    public StarLine(int startIndex, int endIndex, boolean starsReady) {
        this.starAIndex = startIndex;
        this.starBIndex = endIndex;
        if (starsReady) {
            this.initialise();
        }
    }

    public void initialise() {
        Star starA = SpyglassAstronomyClient.stars.get(this.starAIndex);
        this.starAPosition = starA.getRenderedPosition();
        this.starAColor = starA.getColor();
        starA.connect();
        Star starB = SpyglassAstronomyClient.stars.get(this.starBIndex);
        this.starBPosition = starB.getRenderedPosition();
        this.starBColor = starB.getColor();
        starB.connect();
        this.calculateVertices();
    }

    public StarLine(Star startStar) {
        this.starAIndex = startStar.index;
        this.starBIndex = -1;
        this.starAPosition = startStar.getRenderedPosition();
        this.starAColor = startStar.getColor();
        this.starBPosition = startStar.getRenderedPosition();
        this.starBColor = new int[]{255, 255, 255, 255};
    }

    public void updateDrawing(Vector3f position) {
        this.starBPosition = position;
        this.calculateVertices();
    }

    public boolean finishDrawing(Star endStar) {
        if (this.starAIndex == endStar.index) {
            return false;
        }
        if (this.getSquaredLength() > 20000.0f) {
            return false;
        }
        this.starBIndex = endStar.index;
        this.starBPosition = endStar.getRenderedPosition();
        this.starBColor = endStar.getColor();
        endStar.connect();
        SpyglassAstronomyClient.stars.get(this.starAIndex).connect();
        this.calculateVertices();
        return true;
    }

    public float getSquaredLength() {
        Vector3f length = new Vector3f(this.starAPosition.x, this.starAPosition.y, this.starAPosition.z);
        length.sub((Vector3fc)this.starBPosition);
        return SpyglassAstronomyClient.getSquaredDistance(length.x, length.y, length.z);
    }

    public void calculateVertices() {
        Vector3f direction = new Vector3f(this.starBPosition.x, this.starBPosition.y, this.starBPosition.z);
        direction.sub((Vector3fc)this.starAPosition);
        float dirX = direction.x;
        float dirY = direction.y;
        float dirZ = direction.z;
        float sqrDistance = dirX * dirX + dirY * dirY + dirZ * dirZ;
        direction.normalize();
        direction.mul(distance * (Math.min(class_3532.method_15355((float)sqrDistance), 4.0f) / 4.0f));
        Vector3f perpendicular = new Vector3f((Vector3fc)direction);
        perpendicular.cross((Vector3fc)this.starAPosition);
        perpendicular.normalize();
        perpendicular.mul(width);
        float posAX = this.starAPosition.x + direction.x;
        float posAY = this.starAPosition.y + direction.y;
        float posAZ = this.starAPosition.z + direction.z;
        this.vertexA1 = new Vector3f(posAX + perpendicular.x, posAY + perpendicular.y, posAZ + perpendicular.z);
        this.vertexA2 = new Vector3f(posAX - perpendicular.x, posAY - perpendicular.y, posAZ - perpendicular.z);
        perpendicular = new Vector3f(-direction.x, -direction.y, -direction.z);
        perpendicular.cross((Vector3fc)this.starAPosition);
        perpendicular.normalize();
        perpendicular.mul(width);
        float posBX = this.starBPosition.x - direction.x;
        float posBY = this.starBPosition.y - direction.y;
        float posBZ = this.starBPosition.z - direction.z;
        this.vertexB1 = new Vector3f(posBX + perpendicular.x, posBY + perpendicular.y, posBZ + perpendicular.z);
        this.vertexB2 = new Vector3f(posBX - perpendicular.x, posBY - perpendicular.y, posBZ - perpendicular.z);
    }

    public void setVertices(class_287 bufferBuilder, boolean isSelected) {
        if (this.vertexA1 == null) {
            this.calculateVertices();
        }
        float drawingMultipler = 1.0f;
        if (this.starBIndex == -1) {
            drawingMultipler = class_3532.method_15363((float)((20000.0f - this.getSquaredLength()) / 5000.0f), (float)0.0f, (float)1.0f);
        }
        int ar = this.starAColor[0];
        int br = this.starBColor[0];
        int bg = this.starAColor[1];
        int ag = this.starBColor[1];
        int bb = this.starAColor[2];
        int ab = this.starBColor[2];
        int aa = (int)((float)this.starAColor[3] * visibilityMultiplier * drawingMultipler);
        int ba = (int)((float)this.starBColor[3] * visibilityMultiplier * drawingMultipler);
        if (isSelected) {
            ar = (int)((float)ag * 0.8f);
            br = (int)((float)bg * 0.8f);
            ag = (int)((float)ag * 0.5f);
            bg = (int)((float)bg * 0.5f);
            ab = (int)Math.min((float)ab * 1.5f, 255.0f);
            bb = (int)Math.min((float)bb * 1.5f, 255.0f);
            aa *= 2;
            ba *= 2;
        }
        bufferBuilder.method_22912(this.vertexA1.x, this.vertexA1.y, this.vertexA1.z).method_1336(ar, ag, ab, aa);
        bufferBuilder.method_22912(this.vertexA2.x, this.vertexA2.y, this.vertexA2.z).method_1336(ar, ag, ab, aa);
        bufferBuilder.method_22912(this.vertexB1.x, this.vertexB1.y, this.vertexB1.z).method_1336(br, bg, bb, ba);
        bufferBuilder.method_22912(this.vertexB2.x, this.vertexB2.y, this.vertexB2.z).method_1336(br, bg, bb, ba);
    }

    public void clear() {
        SpyglassAstronomyClient.stars.get(this.starAIndex).disconnect();
        SpyglassAstronomyClient.stars.get(this.starBIndex).disconnect();
    }

    public Star[] getStars() {
        return new Star[]{SpyglassAstronomyClient.stars.get(this.starAIndex), SpyglassAstronomyClient.stars.get(this.starBIndex)};
    }

    public boolean isSame(int a, int b) {
        return a == this.starAIndex && b == this.starBIndex || a == this.starBIndex && b == this.starAIndex;
    }

    public boolean isSame(StarLine other) {
        return this.isSame(other.starAIndex, other.starBIndex);
    }

    public boolean intersects(int a, int b) {
        return a == this.starAIndex || b == this.starBIndex || a == this.starBIndex || b == this.starAIndex;
    }

    public boolean intersects(StarLine other) {
        return this.intersects(other.starAIndex, other.starBIndex);
    }

    public boolean hasStar(int star) {
        return this.starAIndex == star || this.starBIndex == star;
    }

    public int getOtherStar(int star) {
        return this.starAIndex == star ? this.starBIndex : this.starAIndex;
    }
}

