/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy;

import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.OrbitingBody;
import com.nettakrim.spyglass_astronomy.Star;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class Knowledge {
    private Level starKnowledge;
    private Level orbitKnowledge;
    private boolean bypass;
    private int planets;
    private int comets;

    public void updateStarKnowledge(ArrayList<Constellation> constellations, ArrayList<Star> stars) {
        int namedStars = 0;
        for (Star star : stars) {
            if (star.isUnnamed()) continue;
            ++namedStars;
        }
        if (constellations.size() >= 20 && namedStars >= 8) {
            this.starKnowledge = Level.MASTER;
            return;
        }
        if (constellations.size() >= 10 && namedStars >= 3) {
            this.starKnowledge = Level.EXPERT;
            return;
        }
        if (constellations.size() >= 5) {
            this.starKnowledge = Level.ADEPT;
            return;
        }
        this.starKnowledge = Level.NOVICE;
    }

    public class_5250 getInstructionsToStarKnowledgeStage(int stage) {
        return switch (stage) {
            case 1 -> class_2561.method_43469((String)"spyglass_astronomy.commands.info.starknowledge.toadept", (Object[])new Object[]{"5"});
            case 2 -> class_2561.method_43469((String)"spyglass_astronomy.commands.info.starknowledge.toexpert", (Object[])new Object[]{"10", "3"});
            case 3 -> class_2561.method_43469((String)"spyglass_astronomy.commands.info.starknowledge.tomaster", (Object[])new Object[]{"20", "8"});
            default -> class_2561.method_43473();
        };
    }

    public void updateOrbitKnowledge(ArrayList<OrbitingBody> orbitingBodies, int planets, int comets) {
        int namedPlanets = 0;
        int namedComets = 0;
        this.planets = planets;
        this.comets = comets;
        for (OrbitingBody orbitingBody : orbitingBodies) {
            if (orbitingBody.isUnnamed()) continue;
            if (orbitingBody.isPlanet) {
                ++namedPlanets;
                continue;
            }
            ++namedComets;
        }
        if (namedPlanets >= planets - 1 && namedComets >= comets - 1) {
            this.orbitKnowledge = Level.MASTER;
            return;
        }
        if (namedPlanets >= planets / 3 * 2 && namedComets >= 2) {
            this.orbitKnowledge = Level.EXPERT;
            return;
        }
        if (namedPlanets >= planets / 3 || namedComets >= 1) {
            this.orbitKnowledge = Level.ADEPT;
            return;
        }
        this.orbitKnowledge = Level.NOVICE;
    }

    public class_5250 getInstructionsToOrbitKnowledgeStage(int stage) {
        return switch (stage) {
            case 1 -> class_2561.method_43469((String)"spyglass_astronomy.commands.info.orbitknowledge.toadept", (Object[])new Object[]{Integer.toString(this.planets / 3), "1"});
            case 2 -> class_2561.method_43469((String)"spyglass_astronomy.commands.info.orbitknowledge.toexpert", (Object[])new Object[]{Integer.toString(this.planets / 3 * 2), "2"});
            case 3 -> class_2561.method_43469((String)"spyglass_astronomy.commands.info.orbitknowledge.tomaster", (Object[])new Object[]{Integer.toString(this.planets - 1), Integer.toString(this.comets - 1)});
            default -> class_2561.method_43473();
        };
    }

    private void updateFlags(Level level, int[] flags, int index) {
        int current = switch (level.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
        };
        flags[index] = flags[index] == -1 ? current : Math.min(flags[index], current);
    }

    public class_2561 getKnowledgeInstructions(int[] flags) {
        return this.getInstructionsToStarKnowledgeStage(flags[0]).method_10852((class_2561)this.getInstructionsToOrbitKnowledgeStage(flags[1]));
    }

    public boolean starKnowledgeAtleast(Level level, int[] flags) {
        boolean isAtleast;
        boolean bl = isAtleast = this.bypass || this.knowledgeAtleast(this.starKnowledge, level);
        if (!isAtleast) {
            this.updateFlags(level, flags, 0);
        }
        return isAtleast;
    }

    public boolean orbitKnowledgeAtleast(Level level, int[] flags) {
        boolean isAtleast;
        boolean bl = isAtleast = this.bypass || this.knowledgeAtleast(this.orbitKnowledge, level);
        if (!isAtleast) {
            this.updateFlags(level, flags, 1);
        }
        return isAtleast;
    }

    private boolean knowledgeAtleast(Level a, Level b) {
        if (b == a) {
            return true;
        }
        if (a == Level.MASTER) {
            return true;
        }
        if (b == Level.NOVICE) {
            return true;
        }
        return a == Level.EXPERT && b == Level.ADEPT;
    }

    public boolean bypassKnowledge() {
        this.bypass = !this.bypass;
        return this.bypass;
    }

    public static enum Level {
        NOVICE,
        ADEPT,
        EXPERT,
        MASTER;

    }
}

