/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import work.lclpnet.notica.api.MutablePlayerConfig;
import work.lclpnet.notica.api.PlayerConfig;

public class PlayerConfigEntry
implements PlayerConfig,
MutablePlayerConfig {
    private static final String VOLUME_KEY = "volume";
    private float volume = 1.0f;
    private boolean extendedRangeSupported = false;
    private boolean dirty = true;

    @Override
    public void setExtendedRangeSupported(boolean supported) {
        this.extendedRangeSupported = supported;
    }

    @Override
    public void setVolume(float volume) {
        if (this.volume == volume) {
            return;
        }
        this.volume = Math.max(0.0f, Math.min(1.0f, volume));
        this.markDirty();
    }

    @Override
    public boolean isExtendedRangeSupported() {
        return this.extendedRangeSupported;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    void markClean() {
        this.dirty = false;
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10548(VOLUME_KEY, this.volume);
    }

    public void readNbt(class_2487 nbt) {
        if (nbt.method_10545(VOLUME_KEY)) {
            this.volume = nbt.method_10583(VOLUME_KEY).orElse(Float.valueOf(1.0f)).floatValue();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void copyClient(PlayerConfig config) {
        this.volume = config.getVolume();
    }
}

