/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.util;

public class NoteHelper {
    public static final byte LOWEST_VANILLA_KEY = 33;
    public static final byte HIGHEST_VANILLA_KEY = 57;
    public static final byte OCTAVE_KEYS = 12;
    public static final byte TWO_OCTAVES_KEYS = 24;
    public static final short KEY_PITCH_FACTOR = 100;
    public static final short OCTAVE_PITCH = 1200;

    private NoteHelper() {
    }

    public static float transposedPitch(byte key, short pitch) {
        for (key = (byte)(key + (byte)(pitch / 100)); key < 33; key = (byte)(key + 12)) {
        }
        while (key > 57) {
            key = (byte)(key - 12);
        }
        return NoteHelper.clampPitch((short)(key * 100 + pitch % 100));
    }

    public static float normalizedPitch(byte key, short pitch) {
        key = (byte)(key + (byte)(pitch / 100));
        short range = (short)Math.floor((double)(key - 33) / 24.0);
        key = (byte)(key - (byte)(range * 2 * 12));
        return NoteHelper.clampPitch((short)(key * 100 + pitch % 100));
    }

    private static float clampPitch(short pitch) {
        float alPitch = NoteHelper.openAlPitch(pitch);
        return Math.max(0.5f, Math.min(2.0f, alPitch));
    }

    public static float openAlPitch(short pitch) {
        pitch = (short)(pitch - 3300);
        return (float)Math.pow(2.0, (double)(pitch - 1200) / 1200.0);
    }

    public static float normalizePanning(float panning) {
        return -(panning - 100.0f) * 0.01f;
    }

    public static float normalizePanning(short layerPanning, short notePanning) {
        if (layerPanning == 100) {
            return NoteHelper.normalizePanning(notePanning);
        }
        return NoteHelper.normalizePanning((float)(layerPanning + notePanning) * 0.5f);
    }

    public static boolean isOutsideVanillaRange(byte key, short pitch) {
        return (key = (byte)(key + (byte)(pitch / 100))) < 33 || key > 57;
    }

    public static String getExtendedSoundName(String baseName, byte key, short pitch) {
        int range;
        if ((key = (byte)(key + (byte)(pitch / 100))) < 33) {
            range = -1 * (int)Math.ceil((double)(33 - key) / 24.0);
        } else if (key > 57) {
            range = (int)Math.ceil((double)(key - 57) / 24.0);
        } else {
            return baseName;
        }
        return baseName + "_" + range;
    }
}

