/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.networking;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import work.lclpnet.kibu.networking.protocol.ClientProtocolHandler;
import work.lclpnet.notica.api.PlayerConfig;
import work.lclpnet.notica.api.SongSlice;
import work.lclpnet.notica.event.SongVolumeChangedCallback;
import work.lclpnet.notica.impl.ClientMusicBackend;
import work.lclpnet.notica.impl.ClientSongRepository;
import work.lclpnet.notica.impl.PendingSong;
import work.lclpnet.notica.network.NoticaNetworking;
import work.lclpnet.notica.network.packet.MusicOptionsS2CPacket;
import work.lclpnet.notica.network.packet.PlaySongS2CPacket;
import work.lclpnet.notica.network.packet.RequestSongC2SPacket;
import work.lclpnet.notica.network.packet.RespondSongS2CPacket;
import work.lclpnet.notica.network.packet.SongSeekS2CPacket;
import work.lclpnet.notica.network.packet.StopSongBidiPacket;
import work.lclpnet.notica.util.ByteHelper;
import work.lclpnet.notica.util.PlayerConfigEntry;

@Environment(value=EnvType.CLIENT)
public class NoticaClientNetworking {
    private final ClientSongRepository songRepository;
    private final ClientMusicBackend controller;
    private final PlayerConfigEntry playerConfig;
    private final Logger logger;

    public NoticaClientNetworking(ClientSongRepository songRepository, ClientMusicBackend controller, PlayerConfigEntry playerConfig, Logger logger) {
        this.songRepository = songRepository;
        this.controller = controller;
        this.playerConfig = playerConfig;
        this.logger = logger;
    }

    public void register() {
        new ClientProtocolHandler(NoticaNetworking.PROTOCOL, this.logger).register();
        ClientPlayNetworking.registerGlobalReceiver(PlaySongS2CPacket.ID, this::onPlaySong);
        ClientPlayNetworking.registerGlobalReceiver(RespondSongS2CPacket.ID, this::onRespondSong);
        ClientPlayNetworking.registerGlobalReceiver(StopSongBidiPacket.ID, this::onStopSong);
        ClientPlayNetworking.registerGlobalReceiver(MusicOptionsS2CPacket.ID, this::onMusicOptionsSync);
        ClientPlayNetworking.registerGlobalReceiver(SongSeekS2CPacket.ID, this::onSongSeek);
    }

    private void onPlaySong(PlaySongS2CPacket payload, ClientPlayNetworking.Context context) {
        Thread.startVirtualThread(() -> this.playSong(payload));
    }

    private void playSong(PlaySongS2CPacket payload) {
        class_2960 songId = payload.getSongId();
        byte[] checksum = payload.checksum();
        int startTick = payload.getStartTick();
        PendingSong song = this.songRepository.get(checksum);
        if (song == null) {
            song = this.acceptUnknownSong(payload, songId, checksum, startTick);
        } else if (startTick < song.getStartTick()) {
            this.acceptUnknownRegion(payload, song, songId);
        }
        this.controller.playSong(song, songId, payload.getPlaybackOptions(), startTick);
    }

    @NotNull
    private PendingSong acceptUnknownSong(PlaySongS2CPacket packet, class_2960 songId, byte[] checksum, int startTick) {
        this.logger.debug("Song {} ({}) is not cached, requesting it...", (Object)songId, (Object)ByteHelper.toHexString(checksum, 32));
        PendingSong song = new PendingSong(packet.header(), checksum, startTick);
        SongSlice slice = packet.slice();
        this.logger.debug("Got initial slice {} for song {}", (Object)slice, (Object)songId);
        song.accept(slice);
        if (song.loopConfig().enabled() && startTick > 0) {
            this.request(songId, 0, 0);
        } else if (!packet.last()) {
            this.requestNext(songId, slice);
        }
        this.songRepository.add(song);
        return song;
    }

    private void acceptUnknownRegion(PlaySongS2CPacket packet, PendingSong song, class_2960 songId) {
        SongSlice slice = packet.slice();
        song.accept(slice);
        if (packet.last()) {
            return;
        }
        this.logger.debug("Cached song is missing parts, requesting the song from the beginning...");
        this.request(songId, 0, 0);
    }

    private void onStopSong(StopSongBidiPacket payload, ClientPlayNetworking.Context context) {
        class_2960 songId = payload.songId();
        this.controller.stopSong(songId);
    }

    private void onMusicOptionsSync(MusicOptionsS2CPacket payload, ClientPlayNetworking.Context context) {
        PlayerConfig config = payload.config();
        this.playerConfig.copyClient(config);
        context.client().execute(() -> ((SongVolumeChangedCallback)SongVolumeChangedCallback.EVENT.invoker()).onVolumeChanged());
    }

    private void onSongSeek(SongSeekS2CPacket payload, ClientPlayNetworking.Context context) {
        this.controller.seekSongTo(payload.songId(), payload.ticks(), payload.absolute());
    }

    private void onRespondSong(RespondSongS2CPacket payload, ClientPlayNetworking.Context context) {
        Thread.startVirtualThread(() -> this.receiveSong(payload));
    }

    private void receiveSong(RespondSongS2CPacket payload) {
        class_2960 songId = payload.songId();
        SongSlice slice = payload.slice();
        PendingSong song = this.songRepository.get(songId);
        if (song == null) {
            this.logger.debug("Cannot receive song slice for unknown song {}", (Object)songId);
            return;
        }
        this.logger.debug("Received song slice {} for song {}", (Object)slice, (Object)songId);
        song.accept(slice);
        if (payload.last()) {
            this.logger.debug("Song slice response was the last one. Song request for song {} completed", (Object)songId);
        } else {
            this.requestNext(songId, slice);
        }
    }

    private void requestNext(class_2960 songId, SongSlice prev) {
        this.request(songId, prev.tickEnd(), prev.layerEnd() + 1);
    }

    private void request(class_2960 songId, int tickOffset, int layerOffset) {
        if (!ClientPlayNetworking.canSend(RequestSongC2SPacket.ID)) {
            this.logger.debug("Server didn't declare the ability to accept song requests, aborting song request");
            return;
        }
        this.logger.debug("Requesting song slice {}, {} of song {}", new Object[]{tickOffset, layerOffset, songId});
        RequestSongC2SPacket packet = new RequestSongC2SPacket(songId, tickOffset, layerOffset);
        ClientPlayNetworking.send((class_8710)packet);
    }
}

