/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.network;

import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import work.lclpnet.notica.api.Index;
import work.lclpnet.notica.api.NoteEvent;
import work.lclpnet.notica.api.SongSlice;
import work.lclpnet.notica.api.data.Note;
import work.lclpnet.notica.api.data.NoteContainer;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.MutableNoteEvent;

public record ConcreteSongSlice(Index<? extends NoteContainer> layers, int tickStart, int tickEnd, int layerStart, int layerEnd) implements SongSlice
{
    public ConcreteSongSlice(Song song, int tickStart, int tickEnd, int layerStart, int layerEnd) {
        this(song.layers(), tickStart, tickEnd, layerStart, layerEnd);
    }

    @Override
    @NotNull
    public Iterator<NoteEvent> iterator() {
        final int minLayerIndex = this.layers.streamKeysOrdered().min().orElse(0);
        final int maxLayerIndex = this.layers.streamKeysOrdered().max().orElse(-1);
        return new Iterator<NoteEvent>(){
            final MutableNoteEvent noteEvent = new MutableNoteEvent();
            int tick;
            int layerIndex;
            boolean hasNext;
            boolean done;
            {
                this.tick = ConcreteSongSlice.this.tickStart;
                this.layerIndex = Math.max(minLayerIndex, ConcreteSongSlice.this.layerStart);
                this.hasNext = false;
                this.done = false;
            }

            @Override
            public boolean hasNext() {
                if (!this.hasNext) {
                    this.advance();
                }
                return !this.done;
            }

            private void advance() {
                while (this.tick <= ConcreteSongSlice.this.tickEnd) {
                    int untilLayer = this.tick == ConcreteSongSlice.this.tickEnd ? ConcreteSongSlice.this.layerEnd : maxLayerIndex;
                    while (this.layerIndex <= untilLayer) {
                        Note note;
                        NoteContainer layer = ConcreteSongSlice.this.layers.get(this.layerIndex);
                        if (layer != null && (note = layer.notes().get(this.tick)) != null) {
                            this.noteEvent.set(this.tick, this.layerIndex, note);
                            this.hasNext = true;
                            ++this.layerIndex;
                            return;
                        }
                        ++this.layerIndex;
                    }
                    this.layerIndex = minLayerIndex;
                    ++this.tick;
                }
                this.done = true;
            }

            @Override
            public NoteEvent next() {
                this.hasNext = false;
                return this.noteEvent;
            }
        };
    }
}

