/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.lwjgl.BufferUtils;
import work.lclpnet.notica.api.data.Note;
import work.lclpnet.notica.impl.mix.Compressor;
import work.lclpnet.notica.impl.mix.GainReduction;
import work.lclpnet.notica.impl.mix.NoteSampler;
import work.lclpnet.notica.impl.mix.Scope;
import work.lclpnet.notica.impl.mix.SongAudioStream;
import work.lclpnet.notica.impl.mix.UnifiedSoundLoader;

@Environment(value=EnvType.CLIENT)
public class SoundMixer {
    private static final int BASE_BUFFER_COUNT = 4;
    private static final float MAX_SOUND_SECONDS = 16.0f;
    private final AudioFormat format;
    private final NoteSampler noteSampler;
    private final Compressor compressor;
    private final int bufferSize;
    private final int bufferFrames;
    private final ByteBuffer directBuffer;
    private final Scope rootScope;
    private final Scope[] workerScopes;
    private final int extraBufferCount;
    private int currentBuffer = 0;
    private int remainingBuffers = 0;

    public SoundMixer(AudioFormat format, NoteSampler noteSampler, int bufferBytes, int scopeCount) {
        int bufferSize;
        this.format = format;
        this.noteSampler = noteSampler;
        if (format.getChannels() != 2) {
            throw new IllegalArgumentException("Implementation expects stereo audio format");
        }
        GainReduction gainReduction = this.createGainReduction(format);
        this.compressor = new Compressor(gainReduction, format);
        int sampleBytes = format.getSampleSizeInBits() / 8;
        this.bufferSize = bufferSize = bufferBytes / sampleBytes;
        this.bufferFrames = bufferSize / format.getChannels();
        ByteOrder order = format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.directBuffer = BufferUtils.createByteBuffer((int)bufferBytes).order(order);
        float bufferDurationSeconds = SongAudioStream.getSeconds(format, this.bufferFrames);
        this.extraBufferCount = (int)Math.ceil(16.0f / bufferDurationSeconds);
        int bufferCount = 4 + this.extraBufferCount;
        if (scopeCount > 1) {
            this.rootScope = new Scope(0, bufferCount, bufferSize);
            this.workerScopes = new Scope[scopeCount];
            for (int i = 0; i < scopeCount; ++i) {
                this.workerScopes[i] = this.createScope();
            }
        } else {
            this.rootScope = new Scope(this.extraBufferCount, bufferCount, bufferSize);
            this.workerScopes = new Scope[0];
        }
    }

    @NotNull
    private GainReduction createGainReduction(AudioFormat format) {
        int sampleRate = (int)format.getSampleRate();
        float lookaheadSec = 0.01f;
        float thresholdDb = (float)(Math.log10(0.999969482421875) * 20.0);
        float attackSec = 0.02f;
        float releaseSec = 0.2f;
        float holdSec = 0.002f;
        float ratio = Float.POSITIVE_INFINITY;
        float crestReleaseSec = 0.2f;
        float adaptationSec = 2.0f;
        return new GainReduction(sampleRate, lookaheadSec, thresholdDb, attackSec, releaseSec, holdSec, ratio, crestReleaseSec, adaptationSec);
    }

    public float getCompressorLookAheadSeconds() {
        return (float)this.compressor.gainReduction().getLookaheadSamples() / this.format.getSampleRate();
    }

    private Scope createScope() {
        return new Scope(this.extraBufferCount, this.rootScope.getBufferCount(), this.bufferSize);
    }

    public boolean putSound(Note note, float volume, short layerPanning, int frameOffset, Scope scope) {
        int frameCount = this.bindSample(note, volume, layerPanning, scope);
        return this.mixSample(frameOffset, frameCount, scope);
    }

    public int bindSample(Note note, float volume, short layerPanning, Scope scope) {
        return this.noteSampler.sample(note, volume, layerPanning, scope.getSampleBuffer());
    }

    public boolean mixSample(int frameOffset, int frameCount, Scope scope) {
        if (frameCount <= 0) {
            return false;
        }
        if (this.notEnoughSpace(frameOffset, frameCount, scope)) {
            return false;
        }
        this.mixSample(scope.getSampleBuffer(), frameCount, frameOffset, scope);
        return true;
    }

    @VisibleForTesting
    boolean notEnoughSpace(int frameOffset, int frameCount, Scope scope) {
        int bufferSpan = this.bufferSpan(frameOffset, frameCount);
        return bufferSpan > scope.getBufferCount();
    }

    @VisibleForTesting
    int bufferSpan(int frameOffset, int frameCount) {
        int channels = 2;
        int sampleCount = frameCount * 2;
        int sampleOffset = frameOffset * 2;
        int startBuffer = sampleOffset / this.bufferSize;
        int endBuffer = (sampleOffset + sampleCount - 1) / this.bufferSize;
        return endBuffer - startBuffer + 1;
    }

    @VisibleForTesting
    void mixSample(float[] sample, int frameCount, int totalFrameOffset, Scope scope) {
        int bufferOffset = totalFrameOffset / this.bufferFrames;
        int frameOffset = totalFrameOffset % this.bufferFrames;
        int bufferIdx = (this.currentBuffer + bufferOffset) % scope.getBufferCount();
        int writtenFrames = this.mixOffset(sample, frameCount, bufferIdx, frameOffset, scope);
        this.mixRest(sample, frameCount, bufferIdx, writtenFrames, scope);
    }

    private int mixOffset(float[] sample, int frameCount, int bufferIdx, int frameOffset, Scope scope) {
        int i;
        int len = Math.max(0, Math.min(frameCount, this.bufferFrames - frameOffset));
        float[] buffer = scope.getBuffer(bufferIdx);
        for (i = 0; i < len; ++i) {
            int n = frameOffset + i;
            buffer[n] = buffer[n] + sample[i];
        }
        for (i = 0; i < len; ++i) {
            int n = this.bufferFrames + frameOffset + i;
            buffer[n] = buffer[n] + sample[frameCount + i];
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mixRest(float[] sample, int frameCount, int bufferIdx, int writtenFrames, Scope scope) {
        int remain = frameCount - writtenFrames;
        int span = this.bufferSpan(0, remain);
        SoundMixer soundMixer = this;
        synchronized (soundMixer) {
            this.remainingBuffers = Math.max(this.remainingBuffers, span + 1);
        }
        for (int i = 1; i <= span; ++i) {
            int j;
            int writtenSoFar = writtenFrames + (i - 1) * this.bufferFrames;
            int remainingFrames = frameCount - writtenSoFar;
            int len = Math.max(0, Math.min(this.bufferFrames, remainingFrames));
            int idx = (bufferIdx + i) % scope.getBufferCount();
            float[] buffer = scope.getBuffer(idx);
            for (j = 0; j < len; ++j) {
                int n = j;
                buffer[n] = buffer[n] + sample[j + writtenSoFar];
            }
            for (j = 0; j < len; ++j) {
                int n = this.bufferFrames + j;
                buffer[n] = buffer[n] + sample[frameCount + j + writtenSoFar];
            }
        }
    }

    public ByteBuffer applyCompressor(int frameCount, Scope scope) {
        float[] samples = scope.getBuffer(this.currentBuffer);
        float[] next = scope.getBuffer((this.currentBuffer + 1) % scope.getBufferCount());
        this.compressor.process(frameCount, samples, next, this.directBuffer);
        return this.directBuffer;
    }

    public ByteBuffer applyClamping(int frameCount, Scope scope) {
        this.directBuffer.position(0);
        this.directBuffer.limit(this.directBuffer.capacity());
        float[] samples = scope.getBuffer(this.currentBuffer);
        UnifiedSoundLoader.toInterleavedBytes(samples, frameCount, this.directBuffer, this.format);
        this.directBuffer.flip();
        return this.directBuffer;
    }

    public void reset() {
        this.currentBuffer = 0;
        this.rootScope.reset();
        this.compressor.reset();
    }

    public void advanceBuffer() {
        this.rootScope.resetBuffer(this.currentBuffer);
        for (Scope workerScope : this.workerScopes) {
            workerScope.resetBuffer(this.currentBuffer);
        }
        this.currentBuffer = (this.currentBuffer + 1) % this.rootScope.getBufferCount();
        this.remainingBuffers = Math.max(0, this.remainingBuffers - 1);
    }

    public synchronized boolean isDone() {
        return this.remainingBuffers <= 0;
    }

    public Scope getWorkerScope(int i) {
        if (this.workerScopes.length == 0 && i == 0) {
            return this.rootScope;
        }
        return this.workerScopes[i];
    }

    public void combineScopes() {
        if (this.workerScopes.length == 0) {
            return;
        }
        Scope rootScope = this.rootScope;
        rootScope.copy(this.workerScopes[0]);
        for (int i = 1; i < this.workerScopes.length; ++i) {
            rootScope.add(this.workerScopes[i]);
        }
    }

    @Generated
    public AudioFormat getFormat() {
        return this.format;
    }

    @Generated
    public int getBufferFrames() {
        return this.bufferFrames;
    }

    @Generated
    public Scope getRootScope() {
        return this.rootScope;
    }
}

