/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4234;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.slf4j.Logger;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.ds.BlockingSendReceive;
import work.lclpnet.notica.impl.ds.SemiBlockingSendReceive;
import work.lclpnet.notica.impl.ds.SendReceive;
import work.lclpnet.notica.impl.mix.BufferProcessor;
import work.lclpnet.notica.impl.mix.SongMixer;
import work.lclpnet.notica.impl.mix.SoundMixer;

@Environment(value=EnvType.CLIENT)
public class SongAudioStream
implements class_4234 {
    private static final int PREPARE_COUNT = 5;
    private static final int TIMEOUT_MS = 10000;
    private final AudioFormat format;
    private final Song song;
    private final SoundMixer soundMixer;
    private final SongMixer songMixer;
    private final BufferProcessor bufferProcessor;
    private final Logger logger;
    private final ByteBuffer[] preparedBuffers;
    private final int bufferBytes;
    private final SendReceive<ByteBuffer> queue;
    private final boolean loopEnabled;
    @Nullable
    private Thread producer = null;
    @Nullable
    private Thread watchdog = null;
    private Runnable onUpdate = () -> {};
    private boolean first = true;
    private boolean ended = false;
    private int tick = 0;
    private int prepareIdx = 0;
    private int frameOffset = 0;
    private int loopCount;

    public SongAudioStream(AudioFormat format, SoundMixer soundMixer, SongMixer songMixer, Song song, BufferProcessor bufferProcessor, Logger logger, int bufferBytes, boolean loopEnabled, boolean shouldBlock) {
        this.format = format;
        this.soundMixer = soundMixer;
        this.songMixer = songMixer;
        this.song = song;
        this.bufferProcessor = bufferProcessor;
        this.logger = logger;
        this.bufferBytes = bufferBytes;
        this.queue = shouldBlock ? new BlockingSendReceive(4, 10000) : new SemiBlockingSendReceive(4, 10000);
        this.preparedBuffers = new ByteBuffer[5];
        for (int i = 0; i < 5; ++i) {
            this.preparedBuffers[i] = BufferUtils.createByteBuffer((int)bufferBytes);
        }
        this.loopEnabled = loopEnabled && song.loopConfig().enabled();
        this.loopCount = song.loopConfig().loopCount();
    }

    public float getBufferSeconds() {
        return SongAudioStream.getSeconds(this.format, SongAudioStream.getFrameCount(this.format, this.bufferBytes));
    }

    public static int getByteSize(AudioFormat format, float seconds) {
        return (int)(seconds * (float)format.getSampleSizeInBits() / 8.0f * (float)format.getChannels() * format.getSampleRate());
    }

    public static int getFrameCount(AudioFormat format, int byteSize) {
        return (int)((float)byteSize / ((float)format.getSampleSizeInBits() / 8.0f * (float)format.getChannels()));
    }

    public static float getSeconds(AudioFormat format, int frameCount) {
        return (float)frameCount / format.getSampleRate();
    }

    public AudioFormat method_19719() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteBuffer method_19720(int size) {
        ByteBuffer buf;
        SongAudioStream songAudioStream = this;
        synchronized (songAudioStream) {
            if (this.ended && this.queue.isEmpty()) {
                this.logger.debug("Song has ended");
                return null;
            }
            if (this.queue.isEmpty() && (this.producer == null || !this.producer.isAlive())) {
                this.logger.error("No producer active");
                return null;
            }
        }
        try {
            buf = this.queue.take();
        }
        catch (InterruptedException e) {
            this.logger.debug("Interrupted while waiting for producer, ending...");
            return null;
        }
        if (buf == null) {
            this.logger.debug("No more elements in the queue, song will be stopped");
        }
        return buf;
    }

    public CompletableFuture<Void> startProducer(int initialSegments) {
        this.logger.debug("Starting a new producer when the old one has shut down...");
        return this.whenThreadsShutdown().thenCompose(nil -> this.startNewProducer(initialSegments));
    }

    private synchronized CompletableFuture<Void> startNewProducer(int segments) {
        if (segments > 5) {
            throw new IllegalStateException("Too much segments requested");
        }
        this.soundMixer.reset();
        this.reset();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AtomicBoolean crashed = new AtomicBoolean(false);
        Thread processor = Thread.ofVirtual().name("Song Audio Preprocessor").start(() -> {
            this.logger.debug("New producer #{} has started", (Object)Thread.currentThread().threadId());
            boolean active = true;
            while (active && !Thread.currentThread().isInterrupted()) {
                active = this.prepare(this.bufferBytes);
                if (!active) {
                    this.logger.debug("Producer #{} is done", (Object)Thread.currentThread().threadId());
                }
                crashed.set(false);
                if (this.queue.size() < segments || future.isDone()) continue;
                future.complete(null);
            }
            this.logger.debug("Song audio producer shutdown: {}", (Object)Thread.currentThread());
            future.complete(null);
        });
        this.watchdog = Thread.ofVirtual().name("Song Audio Preprocessor Watchdog").start(() -> {
            while (processor.isAlive()) {
                if (crashed.getAndSet(true)) {
                    this.logger.debug("Song audio preprocessor seems to have crashed or is dead-locked, shutting it down...");
                    processor.interrupt();
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ignored) {
                    this.logger.debug("Song watchdog got interrupted for producer #{}", (Object)processor.threadId());
                    break;
                }
            }
            this.logger.debug("Song audio watchdog for producer #{} shutdown: {}", (Object)processor.threadId(), (Object)Thread.currentThread());
        });
        this.producer = processor;
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepare(int size) {
        ByteBuffer preparedBuffer;
        Object loop;
        SongAudioStream songAudioStream = this;
        synchronized (songAudioStream) {
            if (this.ended) {
                this.logger.debug("Song has already ended (producer #{})", (Object)Thread.currentThread().threadId());
                return false;
            }
        }
        int frameCount = SongAudioStream.getFrameCount(this.format, size);
        float bufferSeconds = SongAudioStream.getSeconds(this.format, frameCount - this.frameOffset);
        if (this.first) {
            bufferSeconds += this.soundMixer.getCompressorLookAheadSeconds();
            this.first = false;
        }
        int songDurationTicks = this.song.durationTicks();
        int durationTicks = this.song.tempo().durationTicks(this.tick, bufferSeconds);
        int endTick = Math.min(this.tick + durationTicks, songDurationTicks + 1);
        if (endTick > songDurationTicks) {
            loop = this.song.loopConfig();
            if (this.loopEnabled && (loop.infinite() || this.loopCount > 0)) {
                this.loopCount = Math.max(0, this.loopCount - 1);
                int interval = Math.max(2, Math.min(8, this.song.signature())) * 4;
                int adjustedEndTick = songDurationTicks + interval - songDurationTicks % interval;
                int ticksUntilAdjustedEnd = adjustedEndTick - this.tick - 1;
                float endSeconds = this.song.tempo().durationSeconds(this.tick, ticksUntilAdjustedEnd);
                this.frameOffset = this.songMixer.mixTicks(this.tick, adjustedEndTick, this.frameOffset);
                this.frameOffset %= this.soundMixer.getBufferFrames();
                this.tick = loop.loopStartTick();
                float remainingSeconds = Math.max(0.0f, bufferSeconds - endSeconds);
                int remainingTicks = this.song.tempo().durationTicks(this.tick, remainingSeconds);
                endTick = Math.min(this.tick + remainingTicks, songDurationTicks + 1);
            }
        }
        if (this.tick >= endTick) {
            if (this.soundMixer.isDone()) {
                loop = this;
                synchronized (loop) {
                    this.ended = true;
                }
                this.logger.debug("Song is done (producer #{})", (Object)Thread.currentThread().threadId());
                return false;
            }
        } else {
            this.onUpdate.run();
            this.frameOffset = Math.max(0, this.songMixer.mixTicks(this.tick, endTick, this.frameOffset) - this.soundMixer.getBufferFrames());
        }
        ByteBuffer buf = this.bufferProcessor.process(frameCount, this.soundMixer.getRootScope());
        SongAudioStream adjustedEndTick = this;
        synchronized (adjustedEndTick) {
            if (Thread.currentThread().isInterrupted()) {
                this.logger.debug("Song producer #{} was interrupted while processing", (Object)Thread.currentThread().threadId());
                return false;
            }
            preparedBuffer = this.preparedBuffers[this.prepareIdx];
            this.copyBuffer(buf, preparedBuffer);
            this.soundMixer.advanceBuffer();
            this.tick = endTick;
            this.prepareIdx = (this.prepareIdx + 1) % this.preparedBuffers.length;
        }
        try {
            if (!this.queue.offer(preparedBuffer)) {
                this.logger.debug("Song audio queue didn't get polled for the specified timeout. Shutting down producer...");
                return false;
            }
        }
        catch (InterruptedException ignored) {
            this.logger.debug("Song producer #{} was interrupted while waiting for the queue to be polled", (Object)Thread.currentThread().threadId());
            return false;
        }
        return true;
    }

    private void copyBuffer(ByteBuffer src, ByteBuffer dst) {
        dst.position(0);
        dst.limit(dst.capacity());
        if (src.remaining() > dst.remaining()) {
            throw new IllegalStateException("Src buffer is bigger than dst buffer");
        }
        dst.put(src);
        dst.flip();
    }

    public synchronized void close() {
        this.logger.debug("Closing song audio stream...");
        this.stopThreads();
    }

    public CompletableFuture<Void> setTick(int tick) {
        this.logger.debug("Setting playback tick when the old producer has shut down...");
        return this.whenThreadsShutdown().thenRun(() -> {
            SongAudioStream songAudioStream = this;
            synchronized (songAudioStream) {
                this.reset();
                this.tick = Math.max(0, tick);
            }
        });
    }

    public synchronized void reset() {
        this.prepareIdx = 0;
        this.first = true;
        this.frameOffset = 0;
        this.queue.clear();
        this.soundMixer.reset();
    }

    private synchronized void stopThreads() {
        if (this.producer != null && this.producer.isAlive()) {
            this.logger.debug("Stopping producer #{}", (Object)this.producer.threadId());
            this.producer.interrupt();
        }
        if (this.watchdog != null && this.watchdog.isAlive()) {
            this.logger.debug("Stopping watchdog #{}", (Object)this.watchdog.threadId());
            this.watchdog.interrupt();
        }
    }

    private synchronized CompletableFuture<Void> whenThreadsShutdown() {
        if (!(this.producer != null && this.producer.isAlive() || this.watchdog != null && this.watchdog.isAlive())) {
            return CompletableFuture.completedFuture(null);
        }
        this.stopThreads();
        return CompletableFuture.runAsync(this::waitForThreads);
    }

    private synchronized void waitForThreads() {
        if (this.producer != null && this.producer.isAlive()) {
            try {
                this.logger.debug("Waiting for previous producer to shut down...");
                this.producer.join();
                this.logger.debug("Previous producer shut down");
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for previous producer to shut down", e);
            }
        }
        if (this.watchdog != null && this.watchdog.isAlive()) {
            try {
                this.logger.debug("Waiting for previous watchdog to shut down...");
                this.watchdog.join();
                this.logger.debug("Previous watchdog shut down");
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for previous watchdog to shut down", e);
            }
        }
    }

    @Generated
    public int getBufferBytes() {
        return this.bufferBytes;
    }

    @Generated
    public void setOnUpdate(Runnable onUpdate) {
        this.onUpdate = onUpdate;
    }
}

