/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import work.lclpnet.notica.api.data.Layer;
import work.lclpnet.notica.api.data.Note;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.mix.Scope;
import work.lclpnet.notica.impl.mix.SongMixer;
import work.lclpnet.notica.impl.mix.SoundMixer;

@Environment(value=EnvType.CLIENT)
public class ParallelBatchSongMixer
implements SongMixer {
    private final SoundMixer soundMixer;
    private final Song song;
    private final int workerCount;
    private float songVolume = 1.0f;

    public ParallelBatchSongMixer(SoundMixer soundMixer, Song song, int workerCount) {
        this.soundMixer = soundMixer;
        this.song = song;
        this.workerCount = workerCount;
    }

    @Override
    public void setSongVolume(float songVolume) {
        this.songVolume = songVolume;
    }

    @Override
    public int mixTicks(int startTick, int endTick, int frameOffset) {
        HashMap<BatchNote, List<BatchNote>> batches = new HashMap<BatchNote, List<BatchNote>>();
        frameOffset = this.batchNotes(startTick, endTick, frameOffset, batches);
        this.dispatchParallel(batches);
        return frameOffset;
    }

    private int batchNotes(int startTick, int endTick, int frameOffset, Map<BatchNote, List<BatchNote>> batches) {
        float sampleRate = this.soundMixer.getFormat().getSampleRate();
        for (int tick = startTick; tick < endTick; ++tick) {
            for (Layer layer : this.song.layers()) {
                float volume;
                Note note = layer.notes().get(tick);
                if (note == null || (volume = this.songVolume * (float)layer.volume() * 0.01f) <= 0.0f) continue;
                BatchNote inst = new BatchNote(note, frameOffset, volume, layer.panning());
                batches.computeIfAbsent(inst, _inst -> new ArrayList()).add(inst);
            }
            float tickSeconds = 1.0f / this.song.tempo().tempoAt(tick);
            int n = (int)Math.ceil(tickSeconds * sampleRate);
            frameOffset += n;
        }
        return frameOffset;
    }

    private void dispatchParallel(Map<BatchNote, List<BatchNote>> batches) {
        ArrayList<Map.Entry<BatchNote, List<BatchNote>>> jobs = new ArrayList<Map.Entry<BatchNote, List<BatchNote>>>(batches.entrySet());
        int jobCount = batches.size();
        int assignedWorkers = Math.min(this.workerCount, jobCount);
        int batchJobs = (int)Math.ceil((float)jobCount / (float)assignedWorkers);
        Thread[] workers = new Thread[assignedWorkers];
        for (int i = 0; i < assignedWorkers; ++i) {
            Thread worker;
            int jobStart = i * batchJobs;
            int jobEnd = Math.min(jobStart + batchJobs, jobCount);
            workers[i] = worker = this.createWorker(jobStart, jobEnd, this.soundMixer.getWorkerScope(i), jobs);
        }
        for (Thread worker : workers) {
            try {
                worker.join();
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.soundMixer.combineScopes();
    }

    @NotNull
    private Thread createWorker(int jobStart, int jobEnd, Scope scope, ArrayList<Map.Entry<BatchNote, List<BatchNote>>> jobs) {
        return Thread.startVirtualThread(() -> {
            for (int j = jobStart; j < jobEnd; ++j) {
                Map.Entry batch = (Map.Entry)jobs.get(j);
                BatchNote batchNote = (BatchNote)batch.getKey();
                Note note = batchNote.note;
                int frameCount = this.soundMixer.bindSample(note, batchNote.volume, batchNote.panning, scope);
                if (frameCount < 0) continue;
                for (BatchNote inst : (List)batch.getValue()) {
                    if (this.soundMixer.mixSample(inst.frameOffset, frameCount, scope)) continue;
                }
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private record BatchNote(Note note, int frameOffset, float volume, short panning) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BatchNote that = (BatchNote)o;
            return this.volume == that.volume && this.panning == that.panning && this.note.equals(that.note);
        }

        @Override
        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.note.hashCode();
            hash = 31 * hash + Float.hashCode(this.volume);
            hash = 31 * hash + this.panning;
            return hash;
        }
    }
}

