/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GainReduction {
    private final float thresholdLn;
    private final float slope;
    private final float crestCoeff;
    private final float gainEstimateLn;
    private final float adaptCoeff;
    private final float attackSamples;
    private final float releaseSamples;
    private final int lookaheadSamples;
    @Nullable
    private final Condensator condensator;
    private float lastPeak = 0.0f;
    private float lastRms = 0.0f;
    private float lastAttack = 0.0f;
    private float lastRelease = 0.0f;
    private float lastGainDev = 0.0f;

    public GainReduction(int sampleRate, float lookaheadSec, float thresholdDb, float attackSec, float releaseSec, float holdSec, float ratio, float crestReleaseSec, float adaptationSec) {
        this.thresholdLn = (float)Math.log(10.0) * 0.05f * thresholdDb;
        this.attackSamples = Math.max(1.0f, attackSec * (float)sampleRate);
        this.releaseSamples = Math.max(1.0f, releaseSec * (float)sampleRate);
        this.lookaheadSamples = Math.max(0, Math.round(lookaheadSec * (float)sampleRate));
        this.slope = 1.0f / ratio - 1.0f;
        this.crestCoeff = (float)Math.exp(-1.0f / (crestReleaseSec * (float)sampleRate));
        this.adaptCoeff = (float)Math.exp(-1.0f / (adaptationSec * (float)sampleRate));
        this.gainEstimateLn = this.thresholdLn * -0.5f * this.slope;
        int holdSamples = Math.max(0, Math.round(holdSec * (float)sampleRate));
        this.condensator = this.lookaheadSamples > 0 && holdSamples > 1 ? new Condensator(holdSamples) : null;
    }

    public void lookAheadGainReduction(float[] samples, float[] next, float[] sideChain) {
        int frames = sideChain.length - this.lookaheadSamples;
        this.computeLinearSideChain(samples, sideChain, 0, frames);
        this.computeLinearSideChain(next, sideChain, frames, this.lookaheadSamples);
        float[] crest = new float[sideChain.length];
        this.computeCrestFactor(sideChain, crest);
        if (this.condensator != null) {
            this.toLogarithmicCondensate(sideChain, this.condensator);
        } else {
            this.toLogarithmic(sideChain);
        }
        this.computeLookaheadGainReduction(sideChain, crest, frames);
    }

    private void computeLinearSideChain(float[] in, float[] out, int outOffset, int len) {
        int i;
        for (i = 0; i < len; ++i) {
            out[outOffset + i] = Math.abs(in[i]);
        }
        for (i = 0; i < len; ++i) {
            out[outOffset + i] = Math.max(out[outOffset + i], Math.abs(in[i + len]));
        }
    }

    private void computeCrestFactor(float[] sideChain, float[] crest) {
        float peak = this.lastPeak;
        float rms = this.lastRms;
        for (int i = 0; i < sideChain.length; ++i) {
            float sampleSq = Math.clamp(sideChain[i] * sideChain[i], 1.0E-6f, 1000000.0f);
            peak = Math.max(peak, GainReduction.lerp(this.crestCoeff, sampleSq, peak));
            rms = GainReduction.lerp(this.crestCoeff, sampleSq, rms);
            crest[i] = peak / rms;
        }
        this.lastPeak = peak;
        this.lastRms = rms;
    }

    private void toLogarithmic(float[] sideChain) {
        for (int i = 0; i < sideChain.length; ++i) {
            float sample = sideChain[i];
            sideChain[i] = (float)Math.log(Math.max(1.0E-6f, sample));
        }
    }

    private void toLogarithmicCondensate(float[] sideChain, Condensator condensator) {
        for (int i = 0; i < sideChain.length; ++i) {
            float sample = sideChain[i];
            float logSample = (float)Math.log(Math.max(1.0E-6f, sample));
            sideChain[i] = condensator.feed(logSample);
        }
    }

    private void computeLookaheadGainReduction(float[] sideChain, float[] crest, int len) {
        float releaseEnvelope = this.lastRelease;
        float attackEnvelope = this.lastAttack;
        float smoothedGainDeviation = this.lastGainDev;
        for (int i = 0; i < len; ++i) {
            float knee = Math.max(0.0f, 2.5f * (smoothedGainDeviation * this.gainEstimateLn));
            float kneeHalf = 0.5f * knee;
            int lookAheadIndex = i + this.lookaheadSamples;
            float overShoot = sideChain[lookAheadIndex] - this.thresholdLn;
            float gainReduction = this.calcGainReduction(overShoot, kneeHalf);
            float crestVal = crest[i];
            float attackSamples = 2.0f * this.attackSamples / crestVal;
            float attackCoeff = (float)Math.exp(-1.0f / attackSamples);
            float releaseSamples = 2.0f * this.releaseSamples / crestVal - attackSamples;
            float releaseCoeff = (float)Math.exp(-1.0f / releaseSamples);
            float attenuation = -this.slope * gainReduction;
            releaseEnvelope = Math.max(attenuation, GainReduction.lerp(releaseCoeff, attenuation, releaseEnvelope));
            attackEnvelope = GainReduction.lerp(attackCoeff, releaseEnvelope, attackEnvelope);
            smoothedGainDeviation = GainReduction.lerp(this.adaptCoeff, -1.0f * (attackEnvelope + this.gainEstimateLn), smoothedGainDeviation);
            smoothedGainDeviation = Math.max(smoothedGainDeviation, sideChain[i] - attackEnvelope - this.thresholdLn - this.gainEstimateLn);
            float postGain = -(smoothedGainDeviation + this.gainEstimateLn);
            sideChain[i] = (float)Math.exp(postGain - attackEnvelope);
        }
        this.lastRelease = releaseEnvelope;
        this.lastAttack = attackEnvelope;
        this.lastGainDev = smoothedGainDeviation;
    }

    private float calcGainReduction(float overShoot, float kneeHalf) {
        if (overShoot <= -kneeHalf) {
            return 0.0f;
        }
        if (overShoot > -kneeHalf && overShoot < kneeHalf) {
            return (overShoot + kneeHalf) * (overShoot + kneeHalf) / (kneeHalf * 4.0f);
        }
        return overShoot;
    }

    public void reset() {
        this.lastPeak = 0.0f;
        this.lastRms = 0.0f;
        this.lastAttack = 0.0f;
        this.lastRelease = 0.0f;
        this.lastGainDev = 0.0f;
    }

    private static float lerp(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    @Generated
    public int getLookaheadSamples() {
        return this.lookaheadSamples;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Condensator {
        private final int holdSamples;
        private final float[] peaks;
        private final int[] expireTimes;
        private int time;
        private int hi;

        private Condensator(int holdSamples) {
            this.holdSamples = holdSamples;
            this.peaks = new float[holdSamples];
            this.expireTimes = new int[holdSamples];
            this.hi = 0;
            this.time = 0;
            this.peaks[this.hi] = Float.NEGATIVE_INFINITY;
            this.expireTimes[this.hi] = holdSamples;
        }

        public float feed(float sample) {
            int t;
            if ((t = this.time++) >= this.expireTimes[this.hi]) {
                this.hi = (this.hi + 1) % this.holdSamples;
            }
            if (sample >= this.peaks[this.hi]) {
                this.peaks[this.hi] = sample;
                this.expireTimes[this.hi] = t + this.holdSamples;
                return sample;
            }
            for (int i = 1; i < this.holdSamples; ++i) {
                int j = (this.hi + i) % this.holdSamples;
                if (!(sample >= this.peaks[j]) && t < this.expireTimes[j]) continue;
                this.peaks[j] = sample;
                this.expireTimes[j] = t + this.holdSamples;
                break;
            }
            return this.peaks[this.hi];
        }
    }
}

