/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1111;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4228;
import net.minecraft.class_5819;
import net.minecraft.class_5912;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import work.lclpnet.notica.api.InstrumentSoundProvider;
import work.lclpnet.notica.api.data.CustomInstrument;
import work.lclpnet.notica.api.data.Instruments;
import work.lclpnet.notica.impl.DirectSoundManager;
import work.lclpnet.notica.impl.mix.SoundRef;
import work.lclpnet.notica.impl.mix.SoundSample;
import work.lclpnet.notica.impl.mix.SoundSampleProvider;

@Environment(value=EnvType.CLIENT)
public class FabricSoundSampleProvider
implements SoundSampleProvider {
    private final Instruments instruments;
    private final InstrumentSoundProvider soundProvider;
    private final class_1144 soundManager;
    private final DirectSoundManager directSoundManager;
    private final class_5912 resourceFactory;
    private final Logger logger;
    private final class_5819 random = class_5819.method_43049((long)42L);

    public FabricSoundSampleProvider(Instruments instruments, InstrumentSoundProvider soundProvider, class_1144 soundManager, DirectSoundManager directSoundManager, class_5912 resourceFactory, Logger logger) {
        this.instruments = instruments;
        this.soundProvider = soundProvider;
        this.soundManager = soundManager;
        this.directSoundManager = directSoundManager;
        this.resourceFactory = resourceFactory;
        this.logger = logger;
    }

    @Override
    public Optional<SoundRef> getSample(byte instrument) {
        class_1111 sound = this.getSound(instrument);
        if (sound == null || sound == class_1144.field_42936) {
            return Optional.empty();
        }
        if (sound.method_4769()) {
            this.logger.warn("Instrument sound {} is a streamed sound and will not be loaded into memory", (Object)sound.method_4766());
            return Optional.empty();
        }
        float volume = sound.method_4771().method_33920(this.random);
        float pitch = sound.method_4772().method_33920(this.random);
        return Optional.of(new Ref(sound.method_4766(), volume, pitch));
    }

    @Nullable
    private class_1111 getSound(byte instrument) {
        CustomInstrument custom = this.instruments.custom(instrument);
        class_3414 soundEvent = custom != null ? this.soundProvider.getCustomInstrumentSound(custom) : this.soundProvider.getVanillaInstrumentSound(instrument);
        if (soundEvent == null) {
            return null;
        }
        class_1146 soundSet = this.soundManager.method_4869(soundEvent.comp_3319());
        if (soundSet == null) {
            soundSet = this.directSoundManager.getSoundSet(soundEvent.comp_3319());
        }
        if (soundSet == null) {
            return null;
        }
        return soundSet.method_4887(this.random);
    }

    @Environment(value=EnvType.CLIENT)
    private class Ref
    implements SoundRef {
        private final class_2960 location;
        private final float volume;
        private final float pitch;

        private Ref(class_2960 location, float volume, float pitch) {
            this.location = location;
            this.volume = volume;
            this.pitch = pitch;
        }

        @Override
        public CompletableFuture<SoundSample> load() {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return this.loadUnifiedSoundSync();
                }
                catch (IOException | UnsupportedAudioFileException e) {
                    throw new RuntimeException("Failed to load sound " + String.valueOf(this.location), e);
                }
            });
        }

        private SoundSample loadUnifiedSoundSync() throws IOException, UnsupportedAudioFileException {
            try (class_4228 audioIn = new class_4228(FabricSoundSampleProvider.this.resourceFactory.open(this.location));){
                ByteBuffer sample = audioIn.method_59757();
                SoundSample soundSample = new SoundSample(sample, audioIn.method_19719());
                return soundSample;
            }
        }

        @Override
        public float volume() {
            return this.volume;
        }

        @Override
        public float pitch() {
            return this.pitch;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Ref that = (Ref)obj;
            return Objects.equals(this.location, that.location) && Float.floatToIntBits(this.volume) == Float.floatToIntBits(that.volume) && Float.floatToIntBits(this.pitch) == Float.floatToIntBits(that.pitch);
        }

        public int hashCode() {
            return Objects.hash(this.location, Float.valueOf(this.volume), Float.valueOf(this.pitch));
        }

        public String toString() {
            return "Ref[location=%s, volume=%s, pitch=%s]".formatted(this.location, Float.valueOf(this.volume), Float.valueOf(this.pitch));
        }
    }
}

