/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import work.lclpnet.notica.impl.mix.GainReduction;
import work.lclpnet.notica.impl.mix.UnifiedSoundLoader;

@Environment(value=EnvType.CLIENT)
public record Compressor(GainReduction gainReduction, AudioFormat format) {
    public void process(int frameCount, float[] samples, float[] next, ByteBuffer output) {
        int i;
        int lookaheadSamples = this.gainReduction.getLookaheadSamples();
        float[] sideChain = new float[frameCount + lookaheadSamples];
        this.gainReduction.lookAheadGainReduction(samples, next, sideChain);
        for (i = 0; i < frameCount; ++i) {
            int n = i;
            samples[n] = samples[n] * sideChain[i];
        }
        for (i = 0; i < frameCount; ++i) {
            int n = i + frameCount;
            samples[n] = samples[n] * sideChain[i];
        }
        output.position(0);
        output.limit(output.capacity());
        UnifiedSoundLoader.toInterleavedBytes(samples, frameCount, output, this.format);
        output.flip();
    }

    public void reset() {
        this.gainReduction.reset();
    }
}

