/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import javax.sound.sampled.AudioFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import work.lclpnet.notica.api.StereoMode;
import work.lclpnet.notica.api.data.CustomInstrument;
import work.lclpnet.notica.api.data.Instruments;
import work.lclpnet.notica.api.data.Note;
import work.lclpnet.notica.impl.mix.NoteSampler;
import work.lclpnet.notica.impl.mix.SoundSampleManager;
import work.lclpnet.notica.util.NoteHelper;

@Environment(value=EnvType.CLIENT)
public class CatmullRomNoteSampler
implements NoteSampler {
    private final SoundSampleManager sampleManager;
    private final AudioFormat format;
    private final StereoMode stereoMode;
    private final Instruments instruments;

    public CatmullRomNoteSampler(SoundSampleManager sampleManager, AudioFormat format, StereoMode stereoMode, Instruments instruments) {
        this.sampleManager = sampleManager;
        this.format = format;
        this.stereoMode = stereoMode;
        this.instruments = instruments;
    }

    public static float[] paddedSample(float[] sample) {
        if (sample.length % 2 == 1) {
            throw new IllegalArgumentException("Non stereo sample");
        }
        float[] padded = new float[sample.length + 8];
        int frames = sample.length / 2;
        System.arraycopy(sample, 0, padded, 2, frames);
        padded[0] = padded[1] = padded[2];
        padded[frames + 1] = padded[frames] = padded[frames - 1];
        System.arraycopy(sample, frames, padded, frames + 4, frames);
        float f = padded[frames + 4];
        padded[frames + 3] = f;
        padded[frames + 2] = f;
        float f2 = padded[sample.length - 5];
        padded[sample.length - 6] = f2;
        padded[sample.length + 7] = f2;
        return padded;
    }

    public static float[] changePitch(float[] sample, float pitch, AudioFormat targetFormat) {
        if (pitch == 1.0f) {
            return sample;
        }
        int baseSamples = sample.length;
        int transformedSamples = (int)((float)baseSamples / pitch);
        float[] paddedSrc = CatmullRomNoteSampler.paddedSample(sample);
        float[] transformed = new float[transformedSamples];
        CatmullRomNoteSampler.resample(paddedSrc, transformed, pitch, targetFormat);
        return transformed;
    }

    @Override
    public int sample(Note note, float volume, short layerPanning, float[] out) {
        float[] in = this.sampleManager.getSample(note.instrument());
        if (in.length == 0) {
            return -1;
        }
        if ((volume *= (float)note.velocity() * 0.01f) <= 0.0f) {
            return -1;
        }
        float pitch = this.getPitch(note);
        int outFrames = CatmullRomNoteSampler.resample(in, out, pitch, this.format);
        float panning = NoteHelper.normalizePanning(layerPanning, note.panning());
        CatmullRomNoteSampler.applyVolumePanning(out, outFrames, volume, panning, this.stereoMode);
        return outFrames;
    }

    public static int resample(float[] in, float[] out, float pitch, AudioFormat format) {
        int capacity;
        int channels = format.getChannels();
        int inFrames = (in.length - 8) / channels;
        int outFrames = (int)((float)inFrames / pitch);
        if (outFrames > (capacity = out.length / channels)) {
            return -1;
        }
        float[] xs = new float[outFrames];
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = (float)i * pitch;
        }
        CatmullRomNoteSampler.resample(outFrames, xs, in, out, 0, 0);
        CatmullRomNoteSampler.resample(outFrames, xs, in, out, inFrames + 4, outFrames);
        return outFrames;
    }

    public static void applyVolumePanning(float[] out, int outFrames, float volume, float panning, StereoMode stereoMode) {
        float rightPanning;
        float leftPanning;
        if (volume == 1.0f && panning == 0.0f) {
            return;
        }
        if (stereoMode == StereoMode.SPATIAL) {
            if (panning < 0.0f) {
                leftPanning = 1.0f - -panning / 8.0f;
                rightPanning = 0.0f;
            } else if (panning > 0.0f) {
                leftPanning = 0.0f;
                rightPanning = 1.0f - panning / 8.0f;
            } else {
                leftPanning = (float)Math.cos(0.7853981633974483);
                rightPanning = (float)Math.sin(0.7853981633974483);
            }
        } else {
            leftPanning = (float)Math.cos((double)(panning + 1.0f) * Math.PI / 4.0);
            rightPanning = (float)Math.sin((double)(panning + 1.0f) * Math.PI / 4.0);
        }
        CatmullRomNoteSampler.mul(out, 0, outFrames, volume * leftPanning);
        CatmullRomNoteSampler.mul(out, outFrames, outFrames, volume * rightPanning);
    }

    private static void resample(int len, float[] xs, float[] y_in, float[] y_out, int in_offset, int out_offset) {
        for (int i = 0; i < len; ++i) {
            float x = xs[i];
            int j = (int)x;
            float t = x - (float)j;
            float p0 = y_in[in_offset + j + 1];
            float p1 = y_in[in_offset + j + 2];
            float p2 = y_in[in_offset + j + 3];
            float p3 = y_in[in_offset + j + 4];
            float t2 = t * t;
            float t3 = t2 * t;
            float a = Math.fma(-p0 + p2, t, 2.0f * p1);
            float b = Math.fma(2.0f * p0 - 5.0f * p1 + 4.0f * p2 - p3, t2, a);
            float c = Math.fma(-p0 + 3.0f * p1 - 3.0f * p2 + p3, t3, b);
            y_out[out_offset + i] = 0.5f * c;
        }
    }

    private static void mul(float[] vals, int offset, int len, float volume) {
        for (int i = 0; i < len; ++i) {
            int n = offset + i;
            vals[n] = vals[n] * volume;
        }
    }

    private float getPitch(Note note) {
        byte instrument = note.instrument();
        CustomInstrument custom = this.instruments.custom(instrument);
        byte key = custom != null ? (byte)(note.key() + custom.key() - 45) : note.key();
        return NoteHelper.openAlPitch((short)(key * 100 + note.pitch()));
    }
}

