/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.ds;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import work.lclpnet.notica.impl.ds.SendReceive;

@Environment(value=EnvType.CLIENT)
public class BlockingSendReceive<T>
implements SendReceive<T> {
    private final BlockingQueue<T> queue;
    private final int offerTimeoutMs;

    public BlockingSendReceive(int capacity, int offerTimeoutMs) {
        this.queue = new LinkedBlockingQueue<T>(capacity);
        this.offerTimeoutMs = offerTimeoutMs;
    }

    @Override
    public boolean offer(T item) throws InterruptedException {
        return this.queue.offer(item, this.offerTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public T take() throws InterruptedException {
        return this.queue.take();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }
}

