/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_4224;
import net.minecraft.class_4225;
import net.minecraft.class_4234;
import net.minecraft.class_4235;
import org.slf4j.Logger;
import work.lclpnet.kibu.hook.Hook;
import work.lclpnet.notica.api.IndividualSongPlayback;
import work.lclpnet.notica.api.SongPlayback;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.PlaybackTimeTracker;
import work.lclpnet.notica.impl.mix.SongAudioStream;
import work.lclpnet.notica.impl.mix.SoundSampleManager;
import work.lclpnet.notica.type.NoticaSource;
import work.lclpnet.notica.type.NoticaSourceManager;

@Environment(value=EnvType.CLIENT)
public class StreamSongPlayback
implements SongPlayback {
    private static final int TIMEOUT_MS = 10000;
    private final Supplier<SongAudioStream> streamSupplier;
    private final SoundSampleManager sampleManager;
    private final Song song;
    private final class_4235 channel;
    private final Logger logger;
    private final Executor mutexExecutor = Executors.newSingleThreadExecutor();
    private volatile Hook<Runnable> onComplete = null;
    private class_4235.class_4236 sourceManager = null;
    private PlaybackTimeTracker timeTracker = null;
    private boolean stopped = false;
    private Runnable onStopped = null;
    private int playbackOffsetTicks = 0;

    public StreamSongPlayback(Supplier<SongAudioStream> streamSupplier, SoundSampleManager sampleManager, Song song, class_4235 channel, Logger logger) {
        this.streamSupplier = streamSupplier;
        this.sampleManager = sampleManager;
        this.song = song;
        this.channel = channel;
        this.logger = logger;
    }

    @Override
    public void start(int startTick) {
        this.mutexExecutor.execute(() -> this.mutexNewPlayback(startTick));
    }

    private CompletableFuture<Void> prepareFirstBuffer(SongAudioStream stream) {
        return stream.startProducer(4);
    }

    @Override
    public synchronized void stop() {
        if (this.sourceManager == null) {
            return;
        }
        this.stopped = true;
        this.sourceManager.method_19735(class_4224::method_19655);
        this.sourceManager = null;
    }

    @Override
    public void seekTo(int tick, boolean absolute) {
        this.mutexExecutor.execute(() -> this.mutexSeekTo(tick, absolute));
    }

    @Override
    public boolean wasStoppedManually() {
        return this.stopped;
    }

    @Override
    public void whenDone(Runnable action) {
        this.getOrCreateHook().register((Object)action);
    }

    private CompletableFuture<Void> playSound(SongAudioStream stream) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ((CompletableFuture)this.channel.method_19723(class_4225.class_4105.field_18353).thenAccept(sourceManager -> {
            this.sourceManager = sourceManager;
            float bufferSeconds = stream.getBufferSeconds();
            this.timeTracker = new PlaybackTimeTracker((class_4235.class_4236)sourceManager, bufferSeconds);
            this.timeTracker.init();
            this.onStopped = () -> {
                if (this.onComplete != null) {
                    ((Runnable)this.onComplete.invoker()).run();
                }
            };
            ((NoticaSourceManager)sourceManager).notica$onStopped(this.onStopped);
            sourceManager.method_19735(source -> {
                ((NoticaSource)source).notica$setNoticaSource();
                source.method_19649(true);
                source.method_19641(class_243.field_1353);
                source.method_19643((class_4234)stream);
                source.method_19650();
                future.complete(null);
            });
        })).exceptionally(err -> {
            future.completeExceptionally((Throwable)err);
            return null;
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hook<Runnable> getOrCreateHook() {
        if (this.onComplete != null) {
            return this.onComplete;
        }
        StreamSongPlayback streamSongPlayback = this;
        synchronized (streamSongPlayback) {
            if (this.onComplete != null) {
                return this.onComplete;
            }
            this.onComplete = IndividualSongPlayback.runnableHook();
        }
        return this.onComplete;
    }

    private int currentPlaybackTick() {
        if (this.timeTracker == null) {
            return 0;
        }
        float playbackSeconds = this.timeTracker.getPlaybackSeconds();
        int passedTicks = this.song.tempo().durationTicks(this.playbackOffsetTicks, playbackSeconds);
        return (this.playbackOffsetTicks + passedTicks) % this.song.durationTicks();
    }

    private void mutexNewPlayback(int startTick) {
        this.playbackOffsetTicks = startTick;
        SongAudioStream stream = this.streamSupplier.get();
        stream.setTick(startTick).join();
        this.sampleManager.loadAll();
        CompletableFuture<Void> firstBufferFuture = this.prepareFirstBuffer(stream);
        try {
            firstBufferFuture.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Waiting for first buffer to be prepared", e);
        }
        catch (TimeoutException e) {
            this.logger.error("Preparing the first buffer took too long, aborting...", (Throwable)e);
            return;
        }
        this.playSound(stream).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mutexSeekTo(int tick, boolean absolute) {
        int startTick;
        CompletableFuture future = new CompletableFuture();
        StreamSongPlayback streamSongPlayback = this;
        synchronized (streamSongPlayback) {
            if (this.sourceManager == null) {
                return;
            }
            int currentPlaybackTick = this.currentPlaybackTick();
            startTick = Math.max(0, absolute ? tick : currentPlaybackTick + tick);
            this.sourceManager.method_19735(source -> {
                if (source.method_19656()) {
                    return;
                }
                ((NoticaSourceManager)this.sourceManager).notica$onStopped(null);
                ((NoticaSource)source).notica$setStopped();
                ((NoticaSource)source).notica$onTick(null);
                source.method_19655();
                this.sourceManager = null;
                this.onStopped = null;
                this.timeTracker = null;
                future.complete(null);
            });
        }
        future.join();
        this.mutexNewPlayback(startTick);
    }

    public void reload() {
        this.seekTo(0, false);
    }
}

