/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.Set;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import work.lclpnet.notica.api.InstrumentSoundProvider;
import work.lclpnet.notica.api.NotePlayer;
import work.lclpnet.notica.api.PlayerConfig;
import work.lclpnet.notica.api.data.CustomInstrument;
import work.lclpnet.notica.api.data.Layer;
import work.lclpnet.notica.api.data.Note;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.SongPlayerRef;
import work.lclpnet.notica.util.NoteHelper;

public class ServerBasicNotePlayer
implements NotePlayer {
    private final InstrumentSoundProvider soundProvider;
    private final float volume;
    private final Set<SongPlayerRef> players;

    public ServerBasicNotePlayer(Set<SongPlayerRef> players, InstrumentSoundProvider soundProvider, float volume) {
        this.soundProvider = soundProvider;
        this.volume = Math.max(0.0f, Math.min(1.0f, volume));
        this.players = players;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playNote(Song song, Layer layer, Note note) {
        byte key;
        class_3414 sound;
        if (this.players.isEmpty()) {
            return;
        }
        byte instrument = note.instrument();
        CustomInstrument custom = song.instruments().custom(instrument);
        if (custom != null) {
            sound = this.soundProvider.getCustomInstrumentSound(custom);
            key = (byte)(note.key() + custom.key() - 45);
        } else {
            sound = this.soundProvider.getVanillaInstrumentSound(instrument);
            key = note.key();
        }
        if (sound == null) {
            return;
        }
        float volume = (float)(layer.volume() * note.velocity()) * 1.0E-4f * this.volume;
        float panning = NoteHelper.normalizePanning(layer.panning(), note.panning());
        short pitch = note.pitch();
        if (volume <= 0.0f) {
            return;
        }
        ServerBasicNotePlayer serverBasicNotePlayer = this;
        synchronized (serverBasicNotePlayer) {
            for (SongPlayerRef playerRef : this.players) {
                this.playSoundFor(playerRef, panning, sound, volume, key, pitch);
            }
        }
    }

    private void playSoundFor(SongPlayerRef playerRef, float panning, class_3414 sound, float volume, byte key, short pitch) {
        float vanillaPitch;
        class_3222 player = playerRef.getPlayer();
        PlayerConfig config = playerRef.getConfig();
        if (NoteHelper.isOutsideVanillaRange(key, pitch) && config.isExtendedRangeSupported()) {
            sound = this.soundProvider.getExtendedSound(sound, key, pitch);
            vanillaPitch = NoteHelper.normalizedPitch(key, pitch);
        } else {
            vanillaPitch = NoteHelper.transposedPitch(key, pitch);
        }
        volume *= config.getVolume();
        if (volume <= 0.0f) {
            return;
        }
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        if ((double)Math.abs(panning) >= 0.001) {
            double yaw = Math.toRadians(player.method_36454() - 90.0f);
            x += Math.sin(yaw) * (double)panning * 2.0;
            z -= Math.cos(yaw) * (double)panning * 2.0;
        }
        class_2767 packet = new class_2767(class_7923.field_41172.method_47983((Object)sound), class_3419.field_15247, x, y, z, volume, vanillaPitch, player.method_59922().method_43055());
        player.field_13987.method_14364((class_2596)packet);
    }

    public void removePlayer(SongPlayerRef player) {
        this.players.remove(player);
    }
}

