/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.HashMap;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import work.lclpnet.notica.api.Index;
import work.lclpnet.notica.api.IndexPointer;
import work.lclpnet.notica.api.NoteEvent;
import work.lclpnet.notica.api.SongSlice;
import work.lclpnet.notica.api.data.Instruments;
import work.lclpnet.notica.api.data.LayerInfo;
import work.lclpnet.notica.api.data.LoopConfig;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.api.data.SongMeta;
import work.lclpnet.notica.api.data.SongTempo;
import work.lclpnet.notica.impl.FixedIndex;
import work.lclpnet.notica.impl.MutableLayer;
import work.lclpnet.notica.impl.data.ImmutableSongMeta;
import work.lclpnet.notica.network.SongHeader;

@Environment(value=EnvType.CLIENT)
public class PendingSong
implements Song {
    private final int durationTicks;
    private final SongTempo tempo;
    private final LoopConfig loopConfig;
    private final Index<MutableLayer> layers;
    private final Instruments instruments;
    private final boolean stereo;
    private final byte signature;
    private final byte[] checksum;
    private int startTick;

    public PendingSong(SongHeader header) {
        this(header, new byte[0], 0);
    }

    public PendingSong(SongHeader header, byte[] checksum, int startTick) {
        this.durationTicks = header.durationTicks();
        this.tempo = header.tempo();
        this.loopConfig = header.loopConfig();
        this.instruments = header.instruments();
        this.stereo = header.stereo();
        this.signature = header.signature();
        this.checksum = checksum;
        this.startTick = startTick;
        Index<? extends LayerInfo> layerInfo = header.layerInfo();
        HashMap<Integer, MutableLayer> layers = new HashMap<Integer, MutableLayer>(layerInfo.size());
        for (IndexPointer<? extends LayerInfo> entry : layerInfo.iterateOrdered()) {
            LayerInfo info = entry.value();
            MutableLayer layer = new MutableLayer(info.volume(), info.panning(), info.locked());
            layers.put(entry.index(), layer);
        }
        this.layers = new FixedIndex(layers);
    }

    @Override
    public int durationTicks() {
        return this.durationTicks;
    }

    @Override
    public SongTempo tempo() {
        return this.tempo;
    }

    @Override
    public SongMeta metaData() {
        return ImmutableSongMeta.EMPTY;
    }

    @Override
    public LoopConfig loopConfig() {
        return this.loopConfig;
    }

    public Index<MutableLayer> layers() {
        return this.layers;
    }

    @Override
    public Instruments instruments() {
        return this.instruments;
    }

    @Override
    public boolean stereo() {
        return this.stereo;
    }

    @Override
    public byte signature() {
        return this.signature;
    }

    public byte[] checksum() {
        return this.checksum;
    }

    public void accept(SongSlice slice) {
        this.startTick = Math.max(0, Math.min(slice.tickStart(), this.startTick));
        for (NoteEvent noteEvent : slice) {
            MutableLayer layer = this.layers.get(noteEvent.layer());
            if (layer == null) continue;
            layer.accept(noteEvent);
        }
    }

    @Generated
    public int getStartTick() {
        return this.startTick;
    }
}

