/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import work.lclpnet.notica.Notica;
import work.lclpnet.notica.api.CheckedSong;
import work.lclpnet.notica.api.InstrumentSoundProvider;
import work.lclpnet.notica.api.PlaybackOptions;
import work.lclpnet.notica.api.PlayerStoppedPlaybackListener;
import work.lclpnet.notica.api.SongHandle;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.FabricInstrumentSoundProvider;
import work.lclpnet.notica.impl.ServerSongHandle;
import work.lclpnet.notica.impl.SongPlayerRef;
import work.lclpnet.notica.network.NoticaNetworking;
import work.lclpnet.notica.network.packet.MusicOptionsS2CPacket;
import work.lclpnet.notica.util.PlayerConfigContainer;
import work.lclpnet.notica.util.PlayerConfigEntry;

@ApiStatus.Internal
public class NoticaImpl
implements Notica {
    private static NoticaImpl instance = null;
    private static Logger logger = null;
    private static Path songsDir = null;
    private static Path playerConfigDir = null;
    private final MinecraftServer server;
    private final InstrumentSoundProvider soundProvider;
    private final PlayerConfigContainer playerConfigs;
    private final Map<UUID, SongPlayerRef> playerRefs = new HashMap<UUID, SongPlayerRef>();
    private final Map<class_2960, Song> songsById = new HashMap<class_2960, Song>();
    private final Set<SongHandle> handles = new HashSet<SongHandle>();
    private final Multimap<class_2960, SongHandle> handlesById = ArrayListMultimap.create();
    private final Set<PlayerStoppedPlaybackListener> playbackListeners = new HashSet<PlayerStoppedPlaybackListener>();

    public static void configure(Path songsDir, Path playerConfigDir, Logger logger) {
        NoticaImpl.songsDir = Objects.requireNonNull(songsDir, "Songs directory is null");
        NoticaImpl.playerConfigDir = Objects.requireNonNull(playerConfigDir, "Player Config directory is null");
        NoticaImpl.logger = Objects.requireNonNull(logger, "Logger is null");
    }

    private NoticaImpl(MinecraftServer server) {
        if (logger == null || songsDir == null || playerConfigDir == null) {
            throw new IllegalStateException("Not configured yet. NoticaImpl::configure should be called first");
        }
        this.server = server;
        this.soundProvider = new FabricInstrumentSoundProvider(server);
        this.playerConfigs = new PlayerConfigContainer(playerConfigDir, logger);
    }

    @Override
    public synchronized SongHandle playSong(CheckedSong song, PlaybackOptions options, int startTick, Collection<? extends class_3222> players) {
        if (players.isEmpty()) {
            throw new IllegalArgumentException("Listeners are empty");
        }
        class_2960 id = song.id();
        this.songsById.put(id, song.song());
        ServerSongHandle handle = new ServerSongHandle(song, options, startTick);
        HashSet<SongPlayerRef> moddedPlayers = new HashSet<SongPlayerRef>();
        HashSet<SongPlayerRef> vanillaPlayers = new HashSet<SongPlayerRef>();
        for (class_3222 class_32222 : players) {
            this.getPlayingSong(class_32222, id).ifPresent(other -> other.remove(player));
            SongPlayerRef ref = this.createRef(class_32222);
            if (this.hasModInstalled(class_32222)) {
                moddedPlayers.add(ref);
                continue;
            }
            vanillaPlayers.add(ref);
        }
        handle.onDestroy(() -> {
            NoticaImpl noticaImpl = this;
            synchronized (noticaImpl) {
                this.handles.remove(handle);
                this.playbackListeners.remove(handle);
                this.handlesById.remove((Object)id, (Object)handle);
                this.cleanSong(id);
            }
        });
        this.handles.add(handle);
        this.playbackListeners.add(handle);
        this.handlesById.put((Object)id, (Object)handle);
        handle.start(vanillaPlayers, moddedPlayers, this.soundProvider);
        return handle;
    }

    private synchronized void cleanSong(class_2960 id) {
        if (!this.handlesById.containsKey((Object)id)) {
            this.songsById.remove(id);
        }
    }

    @Override
    public synchronized Set<SongHandle> getPlayingSongs() {
        return Collections.unmodifiableSet(this.handles);
    }

    @Override
    public synchronized Set<SongHandle> getPlayingSongs(class_3222 player) {
        return this.getPlayingSongs().stream().filter(handle -> handle.isListener(player)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public synchronized Set<SongHandle> getPlayingSongs(class_2960 songId) {
        return this.getPlayingSongs().stream().filter(handle -> handle.getSongId().equals((Object)songId)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public synchronized Optional<SongHandle> getPlayingSong(class_3222 player, class_2960 songId) {
        return this.getPlayingSongs().stream().filter(handle -> handle.isListener(player) && handle.getSongId().equals((Object)songId)).findAny();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlayerJoin(class_3222 player) {
        NoticaImpl noticaImpl = this;
        synchronized (noticaImpl) {
            this.playerConfigs.onPlayerJoin(player);
        }
        this.syncPlayerConfig(player);
    }

    public synchronized void onPlayerQuit(class_3222 player) {
        this.playerConfigs.onPlayerQuit(player);
        this.playerRefs.remove(player.method_5667());
        for (SongHandle handle : this.handles) {
            handle.remove(player);
        }
    }

    public void onPlayerChange(class_3222 to) {
        UUID uuid = to.method_5667();
        SongPlayerRef ref = this.playerRefs.get(uuid);
        if (ref != null) {
            ref.updatePlayer(to);
        }
    }

    public boolean hasModInstalled(class_3222 player) {
        return NoticaNetworking.getInstance().understandsProtocol(player);
    }

    public static NoticaImpl getInstance(MinecraftServer server) {
        Objects.requireNonNull(server, "Server must not be null");
        if (instance == null || NoticaImpl.instance.server != server) {
            instance = new NoticaImpl(server);
        }
        return instance;
    }

    public void syncPlayerConfig(class_3222 player) {
        if (!this.hasModInstalled(player)) {
            return;
        }
        PlayerConfigEntry config = this.getPlayerConfigs().get(player);
        MusicOptionsS2CPacket packet = new MusicOptionsS2CPacket(config);
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    private synchronized SongPlayerRef createRef(class_3222 player) {
        return this.playerRefs.computeIfAbsent(player.method_5667(), uuid -> {
            PlayerConfigEntry config = this.playerConfigs.get(player);
            return new SongPlayerRef(player, config);
        });
    }

    public Optional<Song> getSong(class_2960 id) {
        return Optional.ofNullable(this.songsById.get(id));
    }

    public void notifySongStopped(class_3222 player, class_2960 songId) {
        HashSet<PlayerStoppedPlaybackListener> listeners = new HashSet<PlayerStoppedPlaybackListener>(this.playbackListeners);
        for (PlayerStoppedPlaybackListener listener : listeners) {
            if (!listener.getSongId().equals((Object)songId) || !listener.isListener(player)) continue;
            listener.onStoppedPlayback(player);
        }
    }

    @Generated
    public PlayerConfigContainer getPlayerConfigs() {
        return this.playerConfigs;
    }
}

