/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import work.lclpnet.notica.impl.PendingSong;

@Environment(value=EnvType.CLIENT)
public class ClientSongRepository {
    private final Map<Checksum, PendingSong> byChecksum = new HashMap<Checksum, PendingSong>();
    private final Map<class_2960, Checksum> byId = new HashMap<class_2960, Checksum>();
    private final Map<Checksum, List<class_2960>> references = new HashMap<Checksum, List<class_2960>>();

    @Nullable
    public synchronized PendingSong get(byte[] checksum) {
        return this.byChecksum.get(new Checksum(checksum));
    }

    @Nullable
    public synchronized PendingSong get(class_2960 id) {
        Checksum checksum = this.byId.get(id);
        if (checksum == null) {
            return null;
        }
        return this.byChecksum.get(checksum);
    }

    public synchronized void add(PendingSong pendingSong) {
        Objects.requireNonNull(pendingSong, "Song must not be null");
        Checksum key = new Checksum(pendingSong.checksum());
        this.byChecksum.put(key, pendingSong);
    }

    public synchronized void bind(PendingSong song, class_2960 id) {
        Checksum key = new Checksum(song.checksum());
        if (!this.byChecksum.containsKey(key)) {
            throw new IllegalArgumentException("Song isn't added to the repository");
        }
        this.byId.put(id, key);
        List boundIds = this.references.computeIfAbsent(key, _key -> new ArrayList(1));
        boundIds.add(id);
    }

    public synchronized void unbind(PendingSong song, class_2960 id) {
        Checksum key = new Checksum(song.checksum());
        List<class_2960> boundIds = this.references.get(key);
        if (boundIds == null || !boundIds.remove(id)) {
            return;
        }
        if (!boundIds.contains(id)) {
            this.byId.remove(id);
        }
        if (!boundIds.isEmpty()) {
            return;
        }
        this.byChecksum.remove(key);
        this.references.remove(key);
    }

    @Environment(value=EnvType.CLIENT)
    private record Checksum(byte[] checksum) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Checksum that = (Checksum)o;
            return Arrays.equals(this.checksum, that.checksum);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.checksum);
        }
    }
}

