/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4235;
import net.minecraft.class_4237;
import net.minecraft.class_5912;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import work.lclpnet.kibu.config.ConfigManager;
import work.lclpnet.notica.api.IndividualSongPlayback;
import work.lclpnet.notica.api.InstrumentSoundProvider;
import work.lclpnet.notica.api.PlaybackOptions;
import work.lclpnet.notica.api.PlaybackVariant;
import work.lclpnet.notica.api.SongPlayback;
import work.lclpnet.notica.api.StereoMode;
import work.lclpnet.notica.config.NoticaClientConfig;
import work.lclpnet.notica.config.PlaybackVariantOverride;
import work.lclpnet.notica.config.StereoModeOverride;
import work.lclpnet.notica.impl.ClientAggregatingNotePlayer;
import work.lclpnet.notica.impl.ClientSongRepository;
import work.lclpnet.notica.impl.DirectSoundManager;
import work.lclpnet.notica.impl.PendingSong;
import work.lclpnet.notica.impl.StreamSongPlayback;
import work.lclpnet.notica.impl.mix.CatmullRomNoteSampler;
import work.lclpnet.notica.impl.mix.FabricSoundSampleProvider;
import work.lclpnet.notica.impl.mix.ParallelBatchSongMixer;
import work.lclpnet.notica.impl.mix.SongAudioStream;
import work.lclpnet.notica.impl.mix.SoundMixer;
import work.lclpnet.notica.impl.mix.SoundSampleManager;
import work.lclpnet.notica.impl.mix.UnifiedSoundLoader;
import work.lclpnet.notica.mixin.client.SoundLoaderAccessor;
import work.lclpnet.notica.mixin.client.SoundManagerAccessor;
import work.lclpnet.notica.mixin.client.SoundSystemAccessor;
import work.lclpnet.notica.network.packet.StopSongBidiPacket;
import work.lclpnet.notica.util.PlayerConfigEntry;

@Environment(value=EnvType.CLIENT)
public class ClientMusicBackend {
    private final ClientSongRepository songRepository;
    private final InstrumentSoundProvider soundProvider;
    private final PlayerConfigEntry playerConfig;
    private final ConfigManager<NoticaClientConfig> configManager;
    private final Logger logger;
    private final Map<class_2960, SongPlayback> playing = new HashMap<class_2960, SongPlayback>();
    private final DirectSoundManager directSoundManager = new DirectSoundManager();
    private final AudioFormat unifiedAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 2, 4, 48000.0f, false);
    private final UnifiedSoundLoader unifiedSoundLoader;

    public ClientMusicBackend(ClientSongRepository songRepository, InstrumentSoundProvider soundProvider, PlayerConfigEntry playerConfig, ConfigManager<NoticaClientConfig> configManager, Logger logger) {
        this.songRepository = songRepository;
        this.soundProvider = soundProvider;
        this.playerConfig = playerConfig;
        this.configManager = configManager;
        this.logger = logger;
        this.unifiedSoundLoader = new UnifiedSoundLoader(this.unifiedAudioFormat, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSong(PendingSong song, class_2960 songId, PlaybackOptions options, int startTick) {
        SongPlayback playback;
        this.songRepository.bind(song, songId);
        this.stopSong(songId);
        NoticaClientConfig config = (NoticaClientConfig)this.configManager.config();
        PlaybackVariant variant = Optional.ofNullable(config.getPlaybackVariantOverride()).map(PlaybackVariantOverride::variant).orElseGet(options::variant);
        if (variant == PlaybackVariant.STREAMED) {
            StereoMode stereoMode = Optional.ofNullable(config.getStereoModeOverride()).map(StereoModeOverride::stereoMode).orElseGet(options::stereoMode);
            playback = this.createStreamPlayback(song, options.volume(), stereoMode);
        } else {
            playback = this.createIndividualPlayback(song, options.volume());
        }
        playback.whenDone(() -> {
            this.songRepository.unbind(song, songId);
            if (playback.wasStoppedManually()) {
                return;
            }
            this.removePlaying(songId);
            this.notifySongStopped(songId);
        });
        ClientMusicBackend clientMusicBackend = this;
        synchronized (clientMusicBackend) {
            this.playing.put(songId, playback);
        }
        playback.start(startTick);
    }

    @NotNull
    private IndividualSongPlayback createIndividualPlayback(PendingSong song, float volume) {
        ClientAggregatingNotePlayer notePlayer = new ClientAggregatingNotePlayer(this.soundProvider, volume, this.playerConfig, this.directSoundManager);
        return new IndividualSongPlayback(song, notePlayer);
    }

    private StreamSongPlayback createStreamPlayback(PendingSong song, float volume, StereoMode stereoMode) {
        class_310 client = class_310.method_1551();
        class_1144 soundManager = client.method_1483();
        class_1140 soundSystem = ((SoundManagerAccessor)soundManager).getSoundSystem();
        SoundSystemAccessor soundSystemAccess = (SoundSystemAccessor)soundSystem;
        class_4235 channel = soundSystemAccess.getChannel();
        class_4237 soundLoader = soundSystemAccess.getSoundLoader();
        class_5912 resourceFactory = ((SoundLoaderAccessor)soundLoader).getResourceFactory();
        FabricSoundSampleProvider sampleProvider = new FabricSoundSampleProvider(song.instruments(), this.soundProvider, soundManager, this.directSoundManager, resourceFactory, this.logger);
        SoundSampleManager sampleManager = new SoundSampleManager(song.instruments(), sampleProvider, this.unifiedSoundLoader, CatmullRomNoteSampler::paddedSample);
        CatmullRomNoteSampler noteSampler = new CatmullRomNoteSampler(sampleManager, this.unifiedAudioFormat, stereoMode, song.instruments());
        return new StreamSongPlayback(() -> {
            int bufferBytes = SongAudioStream.getByteSize(this.unifiedAudioFormat, 1.0f);
            int workerCount = Runtime.getRuntime().availableProcessors();
            SoundMixer soundMixer = new SoundMixer(this.unifiedAudioFormat, noteSampler, bufferBytes, workerCount);
            ParallelBatchSongMixer songMixer = new ParallelBatchSongMixer(soundMixer, song, workerCount);
            SongAudioStream audioStream = new SongAudioStream(this.unifiedAudioFormat, soundMixer, songMixer, song, soundMixer::applyCompressor, this.logger, bufferBytes, true, false);
            audioStream.setOnUpdate(() -> {
                float categoryVolume = client.field_1690.method_71978(class_3419.field_15247);
                float totalVolume = Math.max(0.0f, Math.min(1.0f, volume * categoryVolume * this.playerConfig.getVolume()));
                songMixer.setSongVolume(totalVolume);
            });
            return audioStream;
        }, sampleManager, song, channel, this.logger);
    }

    public void stopSong(class_2960 songId) {
        SongPlayback playback = this.removePlaying(songId);
        if (playback == null) {
            return;
        }
        playback.stop();
    }

    @Nullable
    private synchronized SongPlayback removePlaying(class_2960 songId) {
        return this.playing.remove(songId);
    }

    private void notifySongStopped(class_2960 songId) {
        if (!ClientPlayNetworking.canSend(StopSongBidiPacket.ID)) {
            return;
        }
        StopSongBidiPacket packet = new StopSongBidiPacket(songId);
        ClientPlayNetworking.send((class_8710)packet);
    }

    public Set<class_2960> getPlayingSongs() {
        return new HashSet<class_2960>(this.playing.keySet());
    }

    public void stopAll() {
        for (class_2960 songId : this.getPlayingSongs()) {
            this.stopSong(songId);
        }
    }

    public synchronized void seekSongTo(class_2960 songId, int ticks, boolean absolute) {
        SongPlayback playback = this.playing.get(songId);
        if (playback == null) {
            return;
        }
        playback.seekTo(ticks, absolute);
    }

    public synchronized void reload() {
        for (SongPlayback playback : this.playing.values()) {
            if (!(playback instanceof StreamSongPlayback)) continue;
            StreamSongPlayback streamPlayback = (StreamSongPlayback)playback;
            streamPlayback.reload();
        }
    }

    public boolean isSongPlaying() {
        return !this.playing.isEmpty();
    }
}

