/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ConfigOption {
    private final Field field;
    @Nullable
    private final Method getter;
    @Nullable
    private final Method setter;

    public ConfigOption(Field field, Class<?> srcClass) {
        this.field = field;
        this.getter = ConfigOption.findGetter(field, srcClass);
        this.setter = ConfigOption.findSetter(field, srcClass);
    }

    public Field field() {
        return this.field;
    }

    public Object get(Object src) {
        if (this.getter == null) {
            return null;
        }
        try {
            return this.getter.invoke(src, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public void set(Object src, Object value) {
        if (this.setter == null) {
            return;
        }
        try {
            this.setter.invoke(src, value);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static String ucfirst(String s) {
        int len = s.length();
        if (len == 0) {
            return s;
        }
        char c = Character.toTitleCase(s.charAt(0));
        if (len == 1) {
            return String.valueOf(c);
        }
        return c + s.substring(1);
    }

    @Nullable
    private static Method findGetter(Field field, Class<?> srcClass) {
        String getterName = (field.getType() == Boolean.TYPE ? "is" : "get") + ConfigOption.ucfirst(field.getName());
        try {
            Method getter = srcClass.getDeclaredMethod(getterName, new Class[0]);
            getter.setAccessible(true);
            return getter;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private static Method findSetter(Field field, Class<?> srcClass) {
        String setterName = "set" + ConfigOption.ucfirst(field.getName());
        try {
            Method setterMethod = srcClass.getDeclaredMethod(setterName, field.getType());
            setterMethod.setAccessible(true);
            return setterMethod;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean isValue(Class<?> type) {
        return type.isPrimitive() || type.isArray() || type.isEnum() || type.isAssignableFrom(Collection.class);
    }
}

