/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.api;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import work.lclpnet.notica.api.Index;
import work.lclpnet.notica.api.IoHelper;
import work.lclpnet.notica.api.data.CustomInstrument;
import work.lclpnet.notica.api.data.Instruments;
import work.lclpnet.notica.api.data.Layer;
import work.lclpnet.notica.api.data.Note;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.api.data.SongTempo;
import work.lclpnet.notica.api.data.TempoChange;
import work.lclpnet.notica.impl.FixedIndex;
import work.lclpnet.notica.impl.data.ImmutableCustomInstrument;
import work.lclpnet.notica.impl.data.ImmutableInstruments;
import work.lclpnet.notica.impl.data.ImmutableLayer;
import work.lclpnet.notica.impl.data.ImmutableLoopConfig;
import work.lclpnet.notica.impl.data.ImmutableNote;
import work.lclpnet.notica.impl.data.ImmutableSong;
import work.lclpnet.notica.impl.data.ImmutableSongMeta;
import work.lclpnet.notica.impl.data.ImmutableSongTempo;

public class SongDecoder {
    public static final int VANILLA_INSTRUMENT_COUNT_1_14 = 16;
    public static final String TEMPO_CHANGER_NAME = "Tempo Changer";

    private SongDecoder() {
    }

    public static Song parse(InputStream input) throws IOException {
        return SongDecoder.parse(input, 16);
    }

    public static Song parse(InputStream input, int vanillaInstrumentCount) throws IOException {
        return SongDecoder.parse(input, vanillaInstrumentCount, true);
    }

    public static Song parse(InputStream input, int vanillaInstrumentCount, boolean optimize) throws IOException {
        int jump;
        byte customInstrumentOffset;
        byte songVanillaInstrumentCount;
        byte version;
        DataInputStream in = new DataInputStream(input);
        int durationTicks = IoHelper.readUnsignedShortLE(in);
        if (durationTicks == 0) {
            version = in.readByte();
            songVanillaInstrumentCount = in.readByte();
            customInstrumentOffset = (byte)(vanillaInstrumentCount - songVanillaInstrumentCount);
            if (version >= 3) {
                durationTicks = IoHelper.readUnsignedShortLE(in);
            }
        } else {
            version = 0;
            songVanillaInstrumentCount = 10;
            customInstrumentOffset = 0;
        }
        int layerCount = IoHelper.readUnsignedShortLE(in);
        ImmutableSongMeta meta = SongDecoder.readMetaData(in);
        float ticksPerSecond = (float)IoHelper.readUnsignedShortLE(in) / 100.0f;
        in.readBoolean();
        in.readByte();
        byte timeSignature = in.readByte();
        IoHelper.readIntLE(in);
        IoHelper.readIntLE(in);
        IoHelper.readIntLE(in);
        IoHelper.readIntLE(in);
        IoHelper.readIntLE(in);
        IoHelper.readString(in);
        ImmutableLoopConfig loopConfig = SongDecoder.readLoopConfig(version, in);
        HashMap<Integer, Map<Integer, Note>> layerNotes = new HashMap<Integer, Map<Integer, Note>>(layerCount);
        boolean stereo = false;
        int tick = -1;
        int maxInstrument = songVanillaInstrumentCount - 1;
        while ((jump = IoHelper.readUnsignedShortLE(in)) != 0) {
            tick += jump;
            int layer = -1;
            while ((jump = IoHelper.readUnsignedShortLE(in)) != 0) {
                short pitch;
                short panning;
                byte velocity;
                layer += jump;
                byte instrument = in.readByte();
                maxInstrument = Math.max(maxInstrument, instrument);
                if (customInstrumentOffset > 0 && instrument >= songVanillaInstrumentCount) {
                    instrument = (byte)(instrument + customInstrumentOffset);
                }
                byte key = in.readByte();
                if (version >= 4) {
                    velocity = in.readByte();
                    panning = (short)(200 - in.readUnsignedByte());
                    if (panning != 100) {
                        stereo = true;
                    }
                    pitch = IoHelper.readShortLE(in);
                } else {
                    velocity = 100;
                    panning = 100;
                    pitch = 0;
                }
                if (optimize && velocity <= 0) continue;
                Map notes = layerNotes.computeIfAbsent(layer, i -> new HashMap());
                ImmutableNote note = new ImmutableNote(instrument, key, velocity, panning, pitch);
                notes.put(tick, note);
            }
        }
        durationTicks = switch (version) {
            case 1, 2 -> tick;
            default -> durationTicks;
        };
        LayerResult layerResult = SongDecoder.readLayers(layerCount, layerNotes, in, version, optimize);
        ImmutableInstruments instruments = SongDecoder.readInstruments(in, customInstrumentOffset, songVanillaInstrumentCount, maxInstrument);
        SongTempo tempo = SongDecoder.buildSongTempo(ticksPerSecond, instruments, layerResult.layers());
        return new ImmutableSong(durationTicks, tempo, meta, loopConfig, layerResult.layers(), instruments, stereo |= layerResult.stereo(), timeSignature);
    }

    @NotNull
    private static LayerResult readLayers(int layerCount, Map<Integer, Map<Integer, Note>> layerNotes, DataInputStream in, byte version, boolean optimize) throws IOException {
        HashMap<Integer, ImmutableLayer> layers = new HashMap<Integer, ImmutableLayer>(layerCount);
        boolean stereo = false;
        for (int i = 0; i < layerCount; ++i) {
            short panning;
            Map<Integer, Note> notes = layerNotes.get(i);
            String name = IoHelper.readString(in);
            boolean locked = false;
            if (version >= 4) {
                locked = in.readByte() == 1;
            }
            byte volume = in.readByte();
            if (version >= 2) {
                panning = (short)(200 - in.readUnsignedByte());
                if (panning != 100) {
                    stereo = true;
                }
            } else {
                panning = 100;
            }
            if (notes == null || optimize && (locked || volume <= 0)) continue;
            layers.put(i, new ImmutableLayer(name, volume, panning, locked, new FixedIndex<Note>(notes)));
        }
        return new LayerResult(new FixedIndex<Layer>(layers), stereo);
    }

    @NotNull
    private static ImmutableInstruments readInstruments(DataInputStream in, byte customInstrumentOffset, byte songVanillaInstrumentCount, int maxInstrument) throws IOException {
        int customInstrumentCount = in.readByte();
        CustomInstrument[] customInstruments = new ImmutableCustomInstrument[customInstrumentCount];
        for (int i = 0; i < customInstrumentCount; ++i) {
            String name = IoHelper.readString(in);
            String file = IoHelper.readString(in);
            byte key = in.readByte();
            customInstruments[i] = new ImmutableCustomInstrument(name, file, key);
            in.readByte();
        }
        if (customInstrumentOffset < 0) {
            throw new IOException("Tried to load song for a later game version");
        }
        if (customInstrumentCount == 0) {
            songVanillaInstrumentCount = (byte)Math.max(maxInstrument + 1, songVanillaInstrumentCount);
        }
        byte customBegin = (byte)(songVanillaInstrumentCount + customInstrumentOffset);
        return new ImmutableInstruments(customInstruments, customBegin);
    }

    @NotNull
    private static ImmutableLoopConfig readLoopConfig(byte version, DataInputStream in) throws IOException {
        if (version < 4) {
            return new ImmutableLoopConfig(false, 0, 0);
        }
        boolean loopEnabled = in.readByte() == 1;
        byte loopCount = in.readByte();
        int loopStartTick = IoHelper.readUnsignedShortLE(in);
        return new ImmutableLoopConfig(loopEnabled, loopCount, loopStartTick);
    }

    @NotNull
    private static ImmutableSongMeta readMetaData(DataInputStream in) throws IOException {
        String name = IoHelper.readString(in);
        String author = IoHelper.readString(in);
        String originalAuthor = IoHelper.readString(in);
        String description = IoHelper.readString(in);
        return new ImmutableSongMeta(name, author, originalAuthor, description);
    }

    private static SongTempo buildSongTempo(float ticksPerSecond, Instruments instruments, Index<Layer> layers) {
        CustomInstrument[] customInstruments = instruments.custom();
        ArrayList<TempoChange> tempoChanges = new ArrayList<TempoChange>();
        tempoChanges.add(new TempoChange(0, ticksPerSecond));
        OptionalInt tempoChangerIndex = IntStream.range(0, customInstruments.length).filter(i -> TEMPO_CHANGER_NAME.equals(customInstruments[i].name())).findAny();
        if (tempoChangerIndex.isEmpty()) {
            return new ImmutableSongTempo(tempoChanges);
        }
        byte tempoChangerInstrument = (byte)(tempoChangerIndex.getAsInt() + instruments.customBegin());
        layers.stream().flatMap(layer -> layer.notes().streamKeysOrdered().boxed().flatMap(time -> {
            Note note = layer.notes().get((int)time);
            if (note == null || note.instrument() != tempoChangerInstrument) {
                return Stream.empty();
            }
            return Stream.of(new TempoChange((int)time, SongDecoder.bpm2tps(note.pitch())));
        })).forEachOrdered(tempoChanges::add);
        return new ImmutableSongTempo(tempoChanges);
    }

    private static float bpm2tps(short bpm) {
        return (float)Math.abs(bpm) / 15.0f;
    }

    private record LayerResult(Index<Layer> layers, boolean stereo) {
    }
}

