/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica;

import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import work.lclpnet.kibu.hook.player.PlayerConnectionHooks;
import work.lclpnet.kibu.translate.Translations;
import work.lclpnet.kibu.translate.util.ModTranslations;
import work.lclpnet.notica.cmd.MusicCommand;
import work.lclpnet.notica.config.ConfigManager;
import work.lclpnet.notica.event.ResourcePackStatusCallback;
import work.lclpnet.notica.impl.NoticaImpl;
import work.lclpnet.notica.network.NoticaNetworking;
import work.lclpnet.notica.util.NoticaServerPackManager;

public class NoticaInit
implements ModInitializer {
    public static final String MOD_ID = "notica";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"notica");
    private NoticaServerPackManager serverPackManager = null;

    public void onInitialize() {
        Path configDir = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
        Path songsDir = this.createSongsDirectory(configDir);
        Path playerConfigsDir = configDir.resolve("players");
        Path configPath = configDir.resolve("config.json");
        NoticaImpl.configure(songsDir, playerConfigsDir, LOGGER);
        Translations translations = NoticaInit.getTranslations();
        ConfigManager configManager = NoticaInit.getConfigManager(configPath);
        this.serverPackManager = new NoticaServerPackManager(configManager, translations, LOGGER);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> new MusicCommand(songsDir, translations, this.serverPackManager, LOGGER).register((CommandDispatcher<class_2168>)dispatcher));
        NoticaNetworking networking = new NoticaNetworking(LOGGER);
        networking.register();
        PlayerConnectionHooks.JOIN.register(this::onPlayerJoin);
        PlayerConnectionHooks.QUIT.register(this::onPlayerQuit);
        ServerPlayerEvents.COPY_FROM.register(this::copyFromPlayer);
        ResourcePackStatusCallback.HOOK.register(this.serverPackManager::onResourcePackStatus);
        LOGGER.info("Initialized.");
    }

    private void onPlayerJoin(class_3222 player) {
        NoticaImpl.getInstance(player.method_5682()).onPlayerJoin(player);
    }

    private void onPlayerQuit(class_3222 player) {
        NoticaImpl.getInstance(player.method_5682()).onPlayerQuit(player);
        this.serverPackManager.onPlayerQuit(player);
    }

    private void copyFromPlayer(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        NoticaImpl.getInstance(newPlayer.method_5682()).onPlayerChange(newPlayer);
    }

    private static Translations getTranslations() {
        ModTranslations.Result result = ModTranslations.fromAssets((String)MOD_ID, (Logger)LOGGER);
        Translations translations = result.translations();
        result.whenLoaded().thenRun(() -> LOGGER.info("{} translations loaded.", (Object)MOD_ID));
        return translations;
    }

    private static ConfigManager getConfigManager(Path configPath) {
        ConfigManager configManager = new ConfigManager(configPath, LOGGER);
        configManager.init().thenRun(() -> LOGGER.info("{} config loaded.", (Object)MOD_ID));
        return configManager;
    }

    private Path createSongsDirectory(Path configDir) {
        Path dir = configDir.resolve("songs");
        CompletableFuture.runAsync(() -> this.createDirectory(dir));
        return dir;
    }

    private void createDirectory(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create directory {}", (Object)dir, (Object)e);
        }
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static String permission(String suffix) {
        return suffix + "." + suffix;
    }
}

