/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.networking;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.FCC;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImplClient;
import me.fzzyhmstrs.fzzy_config.impl.ValidScopesArgumentType;
import me.fzzyhmstrs.fzzy_config.impl.ValidSubScopesArgumentType;
import me.fzzyhmstrs.fzzy_config.networking.ConfigPermissionsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateC2SCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.DynamicIdsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.api.ClientPlayNetworkContext;
import me.fzzyhmstrs.fzzy_config.networking.api.NetworkApi;
import me.fzzyhmstrs.fzzy_config.registry.ClientConfigRegistry;
import me.fzzyhmstrs.fzzy_config.screen.PopupController;
import me.fzzyhmstrs.fzzy_config.screen.context.ContextType;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.PortingUtils;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4325;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ7\u0010\u0013\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\"\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\"\u0010#J\u001d\u0010%\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\n\u00a2\u0006\u0004\b'\u0010\u0003J\u001d\u0010+\u001a\u00020\n2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002\u00a2\u0006\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lme/fzzyhmstrs/fzzy_config/networking/NetworkEventsClient;", "", "<init>", "()V", "", "update", "Ljava/util/UUID;", "player", "scope", "summary", "", "forwardSetting", "(Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "", "serializedConfigs", "", "changeHistory", "", "playerPerm", "updateServer", "(Ljava/util/Map;Ljava/util/List;I)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigSyncS2CCustomPayload;", "payload", "Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;", "context", "receiveSync", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigSyncS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigPermissionsS2CCustomPayload;", "receivePerms", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigPermissionsS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateS2CCustomPayload;", "receiveUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;", "receiveForward", "(Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/DynamicIdsS2CCustomPayload;", "receiveDynamicIds", "(Lme/fzzyhmstrs/fzzy_config/networking/DynamicIdsS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "registerClient", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "dispatcher", "registerClientCommands", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nNetworkEventsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkEventsClient.kt\nme/fzzyhmstrs/fzzy_config/networking/NetworkEventsClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
public final class NetworkEventsClient {
    @NotNull
    public static final NetworkEventsClient INSTANCE = new NetworkEventsClient();

    private NetworkEventsClient() {
    }

    public final void forwardSetting(@NotNull String update, @NotNull UUID player, @NotNull String scope, @NotNull String summary) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        NetworkApi networkApi = ConfigApi.INSTANCE.network();
        class_2960 class_29602 = SettingForwardCustomPayload.Companion.getType().comp_2242();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"id(...)");
        if (!networkApi.canSend(class_29602, null)) {
            class_746 class_7462 = class_310.method_1551().field_1724;
            if (class_7462 != null) {
                PortingUtils.INSTANCE.sendChat((class_1657)class_7462, (class_2561)FcText.INSTANCE.translate("fc.config.forwarded_error.c2s", new Object[0]));
            }
            FC.INSTANCE.getLOGGER$fzzy_config().error("Can't forward setting; not connected to a server or server isn't accepting this type of data");
            FC.INSTANCE.getLOGGER$fzzy_config().error("Setting not sent:");
            FC.INSTANCE.getLOGGER$fzzy_config().warn(scope);
            FC.INSTANCE.getLOGGER$fzzy_config().warn(summary);
            return;
        }
        ConfigApi.INSTANCE.network().send(new SettingForwardCustomPayload(update, player, scope, summary), null);
    }

    public final void updateServer(@NotNull Map<String, String> serializedConfigs, @NotNull List<String> changeHistory, int playerPerm) {
        Intrinsics.checkNotNullParameter(serializedConfigs, (String)"serializedConfigs");
        Intrinsics.checkNotNullParameter(changeHistory, (String)"changeHistory");
        NetworkApi networkApi = ConfigApi.INSTANCE.network();
        class_2960 class_29602 = ConfigUpdateC2SCustomPayload.Companion.getType().comp_2242();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"id(...)");
        if (!networkApi.canSend(class_29602, null)) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Can't send Config Update; not connected to a server or server isn't accepting this type of data");
            FC.INSTANCE.getLOGGER$fzzy_config().error("changes not sent:");
            for (String change : changeHistory) {
                FC.INSTANCE.getLOGGER$fzzy_config().warn(change);
            }
            return;
        }
        ConfigApi.INSTANCE.network().send(new ConfigUpdateC2SCustomPayload(serializedConfigs, changeHistory, playerPerm), null);
    }

    public final void receiveSync(@NotNull ConfigSyncS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receiveSync$fzzy_config(payload.getId(), payload.getSerializedConfig(), arg_0 -> NetworkEventsClient.receiveSync$lambda$0(context, arg_0));
    }

    public final void receivePerms(@NotNull ConfigPermissionsS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receivePerms$fzzy_config(payload.getId(), payload.getPermissions());
    }

    public final void receiveUpdate(@NotNull ConfigUpdateS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receiveUpdate$fzzy_config(payload.getUpdates(), (class_1657)context.player());
    }

    public final void receiveForward(@NotNull SettingForwardCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.handleForwardedUpdate$fzzy_config(payload.getUpdate(), payload.getPlayer(), payload.getScope(), payload.getSummary());
    }

    public final void receiveDynamicIds(@NotNull DynamicIdsS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ValidatedIdentifier.Companion.receiveSync$fzzy_config(payload);
    }

    public final void registerClient() {
        ContextType.Companion.init$fzzy_config();
        ClientCommandRegistrationCallback.EVENT.register(NetworkEventsClient::registerClient$lambda$1);
        Consumer<String> scopeConsumer = NetworkEventsClient::registerClient$lambda$2;
        Function<Boolean, Boolean> restartFunction = NetworkEventsClient::registerClient$lambda$3;
        ClientTickEvents.START_CLIENT_TICK.register(arg_0 -> NetworkEventsClient.registerClient$lambda$4(scopeConsumer, restartFunction, arg_0));
        ClientConfigurationNetworking.registerGlobalReceiver(ConfigSyncS2CCustomPayload.Companion.getType(), NetworkEventsClient::registerClient$lambda$6);
    }

    private final void registerClientCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"configure").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"base_scope", (ArgumentType)new ValidScopesArgumentType()).executes(NetworkEventsClient::registerClientCommands$lambda$7)).then(ClientCommandManager.argument((String)"sub_scope", (ArgumentType)new ValidSubScopesArgumentType()).executes(NetworkEventsClient::registerClientCommands$lambda$9))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fzzy_config_restart").executes(NetworkEventsClient::registerClientCommands$lambda$10));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fzzy_config_leave_game").executes(NetworkEventsClient::registerClientCommands$lambda$11));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fzzy_config_reload_resources").executes(NetworkEventsClient::registerClientCommands$lambda$12));
    }

    private static final void receiveSync$lambda$0(ClientPlayNetworkContext $context, class_2561 text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $context.disconnect(text);
    }

    private static final void registerClient$lambda$1(CommandDispatcher dispatcher, class_7157 class_71572) {
        Intrinsics.checkNotNull((Object)dispatcher);
        INSTANCE.registerClientCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher);
    }

    private static final void registerClient$lambda$2(String scopeToOpen) {
        Intrinsics.checkNotNullParameter((Object)scopeToOpen, (String)"scopeToOpen");
        if (!Intrinsics.areEqual((Object)scopeToOpen, (Object)"")) {
            ConfigApiImplClient.INSTANCE.openScreen$fzzy_config(scopeToOpen);
        }
    }

    private static final Boolean registerClient$lambda$3(Boolean openRestartScreen) {
        Intrinsics.checkNotNullParameter((Object)openRestartScreen, (String)"openRestartScreen");
        return openRestartScreen != false ? ConfigApiImplClient.INSTANCE.openRestartScreen$fzzy_config() : false;
    }

    private static final void registerClient$lambda$4(Consumer $scopeConsumer, Function $restartFunction, class_310 class_3102) {
        FCC.INSTANCE.withScope($scopeConsumer);
        FCC.INSTANCE.withRestart($restartFunction);
        PopupController.Companion.popAll$fzzy_config();
    }

    private static final void registerClient$lambda$6$lambda$5(ClientConfigurationNetworking.Context $handler, class_2561 text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $handler.responseSender().disconnect(text);
    }

    private static final void registerClient$lambda$6(ConfigSyncS2CCustomPayload payload, ClientConfigurationNetworking.Context handler) {
        ClientConfigRegistry.INSTANCE.receiveSync$fzzy_config(payload.getId(), payload.getSerializedConfig(), arg_0 -> NetworkEventsClient.registerClient$lambda$6$lambda$5(handler, arg_0));
    }

    private static final int registerClientCommands$lambda$7(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        String scope = ValidScopesArgumentType.Companion.getValidScope(context, "base_scope");
        String string = scope;
        if (string == null) {
            string = "";
        }
        FCC.INSTANCE.openScopedScreen(string);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int registerClientCommands$lambda$9(CommandContext context) {
        Object object;
        FCC fCC;
        block7: {
            block4: {
                String string;
                Object object2;
                block6: {
                    block5: {
                        void it;
                        Intrinsics.checkNotNull((Object)context);
                        String scope = ValidScopesArgumentType.Companion.getValidScope(context, "base_scope");
                        String subScope = ValidSubScopesArgumentType.Companion.getValidSubScope(context, "sub_scope");
                        fCC = FCC.INSTANCE;
                        object = scope;
                        if (object == null) break block4;
                        object2 = subScope;
                        if (object2 == null) break block5;
                        String string2 = object2;
                        String string3 = object;
                        FCC fCC2 = fCC;
                        boolean bl = false;
                        String string4 = "." + (String)it;
                        fCC = fCC2;
                        string = string3;
                        String string5 = string4;
                        object2 = string5;
                        if (string5 != null) break block6;
                    }
                    object2 = "";
                }
                if ((object = string + (String)object2) != null) break block7;
            }
            object = "";
        }
        fCC.openScopedScreen((String)object);
        return 1;
    }

    private static final int registerClientCommands$lambda$10(CommandContext commandContext) {
        class_310.method_1551().method_1592();
        return 1;
    }

    private static final int registerClientCommands$lambda$11(CommandContext commandContext) {
        class_310 c = class_310.method_1551();
        boolean sp = c.method_1542();
        class_642 serverInfo = c.method_1558();
        class_638 class_6383 = c.field_1687;
        if (class_6383 != null) {
            class_6383.method_8525(class_638.field_61021);
        }
        class_442 titleScreen = new class_442();
        if (sp) {
            c.method_18096((class_437)titleScreen, false);
        } else if (serverInfo != null && serverInfo.method_52811()) {
            c.method_18096((class_437)new class_4325((class_437)titleScreen), false);
        } else {
            c.method_18096((class_437)new class_500((class_437)titleScreen), false);
        }
        return 1;
    }

    private static final int registerClientCommands$lambda$12(CommandContext commandContext) {
        class_310.method_1551().method_1521();
        return 1;
    }
}

