/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.util;

import java.util.HashMap;
import java.util.Stack;
import java.util.UUID;
import me.roundaround.armorstands.network.ArmorStandFlag;
import me.roundaround.armorstands.network.EulerAngleParameter;
import me.roundaround.armorstands.network.PosePart;
import me.roundaround.armorstands.util.Pose;
import me.roundaround.armorstands.util.actions.AdjustPoseAction;
import me.roundaround.armorstands.util.actions.ArmorStandAction;
import me.roundaround.armorstands.util.actions.FlagAction;
import me.roundaround.armorstands.util.actions.MoveAction;
import me.roundaround.armorstands.util.actions.PoseAction;
import me.roundaround.armorstands.util.actions.RotateAction;
import me.roundaround.armorstands.util.actions.ScaleAction;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class ArmorStandEditor {
    private static final HashMap<UUID, class_3545<UUID, ArmorStandEditor>> editors = new HashMap();
    private final class_3222 player;
    private final class_1531 armorStand;
    private final SizeLimitedStack<ArmorStandAction> actions = new SizeLimitedStack(30);
    private final SizeLimitedStack<ArmorStandAction> undos = new SizeLimitedStack(30);

    public static ArmorStandEditor get(class_3222 class_32222, class_1531 class_15312) {
        class_3545<UUID, ArmorStandEditor> class_35452;
        UUID uUID = class_32222.method_5667();
        if (!editors.containsKey(uUID)) {
            editors.put(uUID, (class_3545<UUID, ArmorStandEditor>)new class_3545((Object)class_15312.method_5667(), (Object)new ArmorStandEditor(class_32222, class_15312)));
        }
        if (!((UUID)(class_35452 = editors.get(uUID)).method_15442()).equals(class_15312.method_5667())) {
            editors.put(uUID, (class_3545<UUID, ArmorStandEditor>)new class_3545((Object)class_15312.method_5667(), (Object)new ArmorStandEditor(class_32222, class_15312)));
        }
        return (ArmorStandEditor)editors.get(uUID).method_15441();
    }

    public static void remove(class_3222 class_32222) {
        editors.remove(class_32222.method_5667());
    }

    private ArmorStandEditor(class_3222 class_32222, class_1531 class_15312) {
        this.player = class_32222;
        this.armorStand = class_15312;
    }

    public class_1531 getArmorStand() {
        return this.armorStand;
    }

    public void applyAction(ArmorStandAction armorStandAction) {
        if (armorStandAction == null) {
            return;
        }
        armorStandAction.apply((class_1657)this.player, this.armorStand);
        this.actions.push(armorStandAction);
        this.undos.clear();
    }

    public boolean undo() {
        if (this.actions.isEmpty()) {
            return false;
        }
        ArmorStandAction armorStandAction = (ArmorStandAction)this.actions.pop();
        if (armorStandAction == null) {
            return false;
        }
        armorStandAction.undo((class_1657)this.player, this.armorStand);
        this.undos.push(armorStandAction);
        return true;
    }

    public boolean redo() {
        if (this.undos.isEmpty()) {
            return false;
        }
        ArmorStandAction armorStandAction = (ArmorStandAction)this.undos.pop();
        if (armorStandAction == null) {
            return false;
        }
        armorStandAction.apply((class_1657)this.player, this.armorStand);
        this.actions.push(armorStandAction);
        return true;
    }

    public void movePos(class_2350 class_23502, int n) {
        this.movePos(new class_243(class_23502.method_23955()).method_1021((double)n * 0.0625), true);
    }

    public void movePos(class_243 class_2432) {
        this.movePos(class_2432, false);
    }

    public void movePos(class_243 class_2432, boolean bl) {
        this.applyAction(MoveAction.relative(class_2432, bl));
    }

    public void setPos(double d, double d2, double d3) {
        this.setPos(new class_243(d, d2, d3));
    }

    public void setPos(class_243 class_2432) {
        this.applyAction(MoveAction.absolute(class_2432));
    }

    public void rotate(float f) {
        this.applyAction(RotateAction.relative(f));
    }

    public void setRotation(float f) {
        this.applyAction(RotateAction.absolute(f));
    }

    public void scale(float f) {
        this.applyAction(ScaleAction.relative(f));
    }

    public void setScale(float f) {
        this.applyAction(ScaleAction.absolute(f));
    }

    public void toggleFlag(ArmorStandFlag armorStandFlag) {
        this.applyAction(FlagAction.toggle(armorStandFlag));
    }

    public void setFlag(ArmorStandFlag armorStandFlag, boolean bl) {
        this.applyAction(FlagAction.set(armorStandFlag, bl));
    }

    public void setPose(Pose pose) {
        this.applyAction(PoseAction.fromPose(pose));
    }

    public void setPose(class_2379 class_23792, class_2379 class_23793, class_2379 class_23794, class_2379 class_23795, class_2379 class_23796, class_2379 class_23797) {
        this.setPose(new Pose(class_23792, class_23793, class_23794, class_23795, class_23796, class_23797));
    }

    public void adjustPose(PosePart posePart, EulerAngleParameter eulerAngleParameter, float f) {
        this.applyAction(AdjustPoseAction.absolute(posePart, eulerAngleParameter, f));
    }

    private static class SizeLimitedStack<T>
    extends Stack<T> {
        private final int limit;

        public SizeLimitedStack(int n) {
            this.limit = n;
        }

        @Override
        public T push(T t) {
            while (this.size() >= this.limit) {
                this.remove(0);
            }
            return super.push(t);
        }
    }
}

