/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.server;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.roundaround.armorstands.network.Networking;
import me.roundaround.armorstands.roundalib.config.option.StringListConfigOption;
import me.roundaround.armorstands.server.config.ServerSideConfig;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_3176;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;

public class ArmorStandUsers {
    public static final int PERMISSION_LEVEL = 2;

    private ArmorStandUsers() {
    }

    public static boolean canEditArmorStands(class_3222 class_32222) {
        MinecraftServer minecraftServer = class_32222.method_5682();
        if (!(minecraftServer instanceof class_3176)) {
            return true;
        }
        if (!ServerPlayNetworking.canSend((class_3222)class_32222, Networking.PongS2C.ID)) {
            return false;
        }
        ServerSideConfig serverSideConfig = ServerSideConfig.getInstance();
        if (!((Boolean)serverSideConfig.enforcePermissions.getValue()).booleanValue()) {
            return true;
        }
        if (((Boolean)serverSideConfig.opsHavePermissions.getValue()).booleanValue() && class_32222.method_64475(2)) {
            return true;
        }
        return ArmorStandUsers.contains(class_32222.method_7334());
    }

    public static boolean contains(GameProfile gameProfile) {
        return ((List)ServerSideConfig.getInstance().allowedUsers.getValue()).contains(gameProfile.getId().toString());
    }

    public static void add(GameProfile gameProfile) {
        StringListConfigOption stringListConfigOption = ServerSideConfig.getInstance().allowedUsers;
        String string = gameProfile.getId().toString();
        if (((List)stringListConfigOption.getValue()).stream().noneMatch(string2 -> string2.equalsIgnoreCase(string))) {
            stringListConfigOption.add(string);
        }
    }

    public static void remove(GameProfile gameProfile) {
        ServerSideConfig.getInstance().allowedUsers.remove(gameProfile.getId().toString());
    }

    public static void reload() {
        ServerSideConfig.getInstance().syncWithStore();
    }

    public static Collection<String> getNamesAndUuids(MinecraftServer minecraftServer) {
        List list = (List)ServerSideConfig.getInstance().allowedUsers.getValue();
        ArrayList<String> arrayList = new ArrayList<String>(list);
        class_3324 class_33242 = minecraftServer.method_3760();
        arrayList.addAll(list.stream().map(arg_0 -> ((class_3324)class_33242).method_14566(arg_0)).filter(Objects::nonNull).map(class_1657::method_7334).map(GameProfile::getName).collect(Collectors.toSet()));
        return arrayList;
    }
}

