/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.toml;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.CharsWrapper;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.ParsingException;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.Utils;

final class TemporalParser {
    private static final char[] ALLOWED_DT_SEPARATORS = new char[]{'T', 't', ' '};
    private static final char[] OFFSET_INDICATORS = new char[]{'Z', 'z', '+', '-'};

    static Temporal parse(CharsWrapper charsWrapper) {
        charsWrapper = charsWrapper.trimmedView();
        try {
            if (charsWrapper.get(2) == ':') {
                return TemporalParser.parseTime(charsWrapper);
            }
            LocalDate localDate = TemporalParser.parseDate(charsWrapper);
            if (charsWrapper.length() == 10) {
                return localDate;
            }
            char c = charsWrapper.get(10);
            if (!Utils.arrayContains(ALLOWED_DT_SEPARATORS, c)) {
                throw new ParsingException("Invalid separator between date and time: '" + c + "'.");
            }
            CharsWrapper charsWrapper2 = charsWrapper.subView(11);
            int n = charsWrapper2.indexOfFirst(OFFSET_INDICATORS);
            if (n == -1) {
                LocalTime localTime = TemporalParser.parseTime(charsWrapper2);
                return LocalDateTime.of(localDate, localTime);
            }
            if (charsWrapper2.get(n) == 'z') {
                charsWrapper2.set(n, 'Z');
            }
            LocalTime localTime = TemporalParser.parseTime(charsWrapper2.subView(0, n));
            ZoneOffset zoneOffset = ZoneOffset.of(charsWrapper2.subView(n).trimmedView().toString());
            return OffsetDateTime.of(localDate, localTime, zoneOffset);
        }
        catch (ArrayIndexOutOfBoundsException | DateTimeException runtimeException) {
            throw new ParsingException("Invalid temporal value " + String.valueOf(charsWrapper), runtimeException);
        }
    }

    private static LocalDate parseDate(CharsWrapper charsWrapper) {
        CharsWrapper charsWrapper2 = charsWrapper.subView(0, 4);
        CharsWrapper charsWrapper3 = charsWrapper.subView(5, 7);
        CharsWrapper charsWrapper4 = charsWrapper.subView(8, 10);
        int n = Utils.parseInt(charsWrapper2, 10);
        int n2 = Utils.parseInt(charsWrapper3, 10);
        int n3 = Utils.parseInt(charsWrapper4, 10);
        return LocalDate.of(n, n2, n3);
    }

    private static LocalTime parseTime(CharsWrapper charsWrapper) {
        int n;
        CharsWrapper charsWrapper2 = charsWrapper.subView(0, 2);
        CharsWrapper charsWrapper3 = charsWrapper.subView(3, 5);
        CharsWrapper charsWrapper4 = charsWrapper.subView(6, 8);
        int n2 = Utils.parseInt(charsWrapper2, 10);
        int n3 = Utils.parseInt(charsWrapper3, 10);
        int n4 = Utils.parseInt(charsWrapper4, 10);
        if (charsWrapper.length() > 8) {
            CharsWrapper charsWrapper5 = new CharsWrapper(charsWrapper.subView(9));
            if (charsWrapper5.length() > 9) {
                charsWrapper5 = charsWrapper5.subView(0, 9);
            }
            int n5 = Utils.parseInt(charsWrapper5, 10);
            int n6 = (int)Math.pow(10.0, 9 - charsWrapper5.length());
            n = n5 * n6;
        } else {
            n = 0;
        }
        return LocalTime.of(n2, n3, n4, n);
    }

    private TemporalParser() {
    }
}

