/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.toml;

import me.roundaround.armorstands.roundalib.nightconfig.core.io.CharacterInput;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.CharsWrapper;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.ParsingException;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.Utils;
import me.roundaround.armorstands.roundalib.nightconfig.toml.Toml;
import me.roundaround.armorstands.roundalib.nightconfig.toml.TomlParser;

final class StringParser {
    private static final char[] SINGLE_QUOTE = new char[]{'\''};
    private static final char[] SINGLE_QUOTE_OR_NEWLINE = new char[]{'\'', '\n', '\r'};

    static String parseBasic(CharacterInput characterInput, TomlParser tomlParser) {
        char c;
        CharsWrapper.Builder builder = tomlParser.createBuilder();
        boolean bl = false;
        while ((c = characterInput.readChar()) != '\"' || bl) {
            if (bl) {
                builder.write(StringParser.unescape(c, characterInput));
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (c == '\n' || c == '\r') {
                throw new ParsingException("Invalid newline in basic string, you should use a multiline string or escape the newline by writing \\n. The string begins with: \"" + String.valueOf(builder) + "\"");
            }
            if (c != '\t' && Toml.isControlChar(c)) {
                String string = "\\u" + Integer.toHexString(c).toUpperCase();
                throw new ParsingException("Invalid control character '" + c + "' in string, you should escape it by writing " + string);
            }
            builder.write(c);
        }
        return builder.toString();
    }

    static String parseLiteral(CharacterInput characterInput, TomlParser tomlParser) {
        String string = characterInput.readCharsUntil(SINGLE_QUOTE_OR_NEWLINE).toString();
        char c = characterInput.readChar();
        if (c != '\'') {
            throw new ParsingException("Invalid newline in literal string, you should use a multiline string. The string is '" + string + "'");
        }
        string.codePoints().forEach(n -> {
            if (n != 9 && Toml.isControlChar(n)) {
                String string2 = "\\u" + Integer.toHexString(n).toUpperCase();
                CharsWrapper charsWrapper = new CharsWrapper(Character.toChars(n));
                throw new ParsingException("Invalid control character '" + String.valueOf(charsWrapper) + "' in literal string '" + string + "', you should escape it by writing " + string2);
            }
        });
        return string;
    }

    static String parseMultiBasic(CharacterInput characterInput, TomlParser tomlParser) {
        char c;
        CharsWrapper.Builder builder = tomlParser.createBuilder();
        while ((c = characterInput.readChar()) != '\"' || characterInput.peek() != 34 || characterInput.peek(1) != 34) {
            if (c == '\\') {
                char c2 = characterInput.readChar();
                if (c2 == '\n' || c2 == '\r' && characterInput.peekChar() == '\n' || (c2 == '\t' || c2 == ' ') && StringParser.isWhitespace(Toml.readLine(characterInput))) {
                    char c3 = Toml.readNonSpaceChar(characterInput, true);
                    characterInput.pushBack(c3);
                    continue;
                }
                if (c2 == '\t' || c2 == ' ') {
                    throw new ParsingException("Invalid escapement: \\" + c2);
                }
                builder.write(StringParser.unescape(c2, characterInput));
                continue;
            }
            if (c != '\n' && c != '\r' && c != '\t' && Toml.isControlChar(c)) {
                String string = "\\u" + Integer.toHexString(c).toUpperCase();
                throw new ParsingException("Invalid control character '" + c + "' in multiline string, you should escape it by writing " + string);
            }
            builder.write(c);
        }
        characterInput.skipPeeks();
        if (characterInput.peek() == 34) {
            characterInput.skipPeeks();
            builder.write('\"');
        }
        if (characterInput.peek() == 34) {
            characterInput.skipPeeks();
            builder.write('\"');
        }
        return StringParser.buildMultilineString(builder);
    }

    static String parseMultiLiteral(CharacterInput characterInput, TomlParser tomlParser) {
        char c;
        CharsWrapper.Builder builder = tomlParser.createBuilder();
        while ((c = characterInput.readChar()) != '\'' || characterInput.peek() != 39 || characterInput.peek(1) != 39) {
            if (c != '\n' && c != '\r' && c != '\t' && Toml.isControlChar(c)) {
                String string = "\\u" + Integer.toHexString(c).toUpperCase();
                throw new ParsingException("Invalid control character '" + c + "' in multiline literal string, you should escape it by writing " + string);
            }
            builder.append(c);
        }
        characterInput.skipPeeks();
        if (characterInput.peek() == 39) {
            characterInput.skipPeeks();
            builder.write('\'');
        }
        if (characterInput.peek() == 39) {
            characterInput.skipPeeks();
            builder.write('\'');
        }
        return StringParser.buildMultilineString(builder);
    }

    private static String buildMultilineString(CharsWrapper.Builder builder) {
        if (builder.get(0) == '\n') {
            return builder.toString(1);
        }
        if (builder.get(0) == '\r' && builder.get(1) == '\n') {
            return builder.toString(2);
        }
        return builder.toString();
    }

    private static String unescape(char c, CharacterInput characterInput) {
        switch (c) {
            case '\"': 
            case '\\': {
                return String.valueOf(c);
            }
            case 'b': {
                return "\b";
            }
            case 'f': {
                return "\f";
            }
            case 'n': {
                return "\n";
            }
            case 'r': {
                return "\r";
            }
            case 't': {
                return "\t";
            }
            case 'u': {
                CharsWrapper charsWrapper = characterInput.readChars(4);
                return StringParser.parseUnicodeCodepoint(charsWrapper);
            }
            case 'U': {
                CharsWrapper charsWrapper = characterInput.readChars(8);
                return StringParser.parseUnicodeCodepoint(charsWrapper);
            }
        }
        throw new ParsingException("Invalid escapement: \\" + c);
    }

    private static String parseUnicodeCodepoint(CharsWrapper charsWrapper) {
        try {
            int n = Utils.parseInt(charsWrapper, 16);
            if (!Toml.isValidCodePoint(n)) {
                throw new ParsingException("Invalid unicode codepoint: " + String.valueOf(charsWrapper));
            }
            return new String(new int[]{n}, 0, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParsingException("Invalid unicode codepoint: " + String.valueOf(charsWrapper), illegalArgumentException);
        }
    }

    private static boolean isWhitespace(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    private StringParser() {
    }
}

