/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.AbstractObserved;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.ObservedEntry;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.ObservedSet;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.TransformingSet;

public final class ObservedMap<K, V>
extends AbstractObserved
implements Map<K, V> {
    private final Map<K, V> map;

    public ObservedMap(Map<K, V> map, Runnable runnable) {
        super(runnable);
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.map.get(object);
    }

    @Override
    public V put(K k, V v) {
        V v2 = this.map.put(k, v);
        this.callback.run();
        return v2;
    }

    @Override
    public V remove(Object object) {
        V v = this.map.remove(object);
        this.callback.run();
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.map.putAll(map);
        this.callback.run();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        this.map.replaceAll(biFunction);
        this.callback.run();
    }

    @Override
    public V putIfAbsent(K k, V v) {
        V v2 = this.map.putIfAbsent(k, v);
        if (v2 != v) {
            this.callback.run();
        }
        return v2;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        boolean bl = this.map.remove(object, object2);
        if (bl) {
            this.callback.run();
        }
        return bl;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        boolean bl = this.map.replace(k, v, v2);
        if (bl) {
            this.callback.run();
        }
        return bl;
    }

    @Override
    public V replace(K k, V v) {
        V v2 = this.map.replace(k, v);
        if (v2 != v) {
            this.callback.run();
        }
        return v2;
    }

    @Override
    public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        V v = this.map.computeIfAbsent((K)k, function);
        if (v != null) {
            this.callback.run();
        }
        return v;
    }

    @Override
    public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        V v = this.map.computeIfPresent((K)k, (BiFunction<? super K, ? extends V, ? extends V>)biFunction);
        this.callback.run();
        return v;
    }

    @Override
    public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        V v = this.map.compute((K)k, (BiFunction<? super K, ? extends V, ? extends V>)biFunction);
        this.callback.run();
        return v;
    }

    @Override
    public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        V v2 = this.map.merge(k, (V)v, (BiFunction<? extends V, ? extends V, ? extends V>)biFunction);
        this.callback.run();
        return v2;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.callback.run();
    }

    @Override
    public Set<K> keySet() {
        return new ObservedSet<K>(this.map.keySet(), this.callback);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Function<Map.Entry, ObservedEntry> function = entry -> new ObservedEntry(entry, this.callback);
        Function<ObservedEntry, Map.Entry> function2 = observedEntry -> observedEntry.entry;
        Function<Object, Object> function3 = object -> {
            if (object instanceof ObservedEntry) {
                ObservedEntry observedEntry = (ObservedEntry)object;
                return observedEntry.entry;
            }
            return object;
        };
        TransformingSet<Map.Entry, ObservedEntry> transformingSet = new TransformingSet<Map.Entry, ObservedEntry>(this.map.entrySet(), function, function2, function3);
        return new ObservedSet<Map.Entry<K, V>>(this.map.entrySet(), this.callback);
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

