/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core.io;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.roundaround.armorstands.roundalib.nightconfig.core.Config;
import me.roundaround.armorstands.roundalib.nightconfig.core.IncompatibleIntermediaryLevelException;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.StringUtils;

public enum ParsingMode {
    REPLACE(Config::clear, Config::set, Map::put),
    MERGE(config -> {}, (config, list, object) -> {
        try {
            return config.set(list, object);
        }
        catch (IncompatibleIntermediaryLevelException incompatibleIntermediaryLevelException) {
            for (int i = list.size(); i > 0; --i) {
                List<String> list2 = list.subList(0, i);
                config.remove(list2);
                try {
                    return config.set(list, object);
                }
                catch (IncompatibleIntermediaryLevelException incompatibleIntermediaryLevelException2) {
                    continue;
                }
            }
            return null;
        }
    }, Map::put),
    ADD(config -> {}, (config, list, object) -> {
        try {
            config.add(list, object);
        }
        catch (IncompatibleIntermediaryLevelException incompatibleIntermediaryLevelException) {
            // empty catch block
        }
        return null;
    }, Map::putIfAbsent);

    private final Consumer<? super Config> preparationAction;
    private final PutAction putAction;
    private final MapPutAction mapPutAction;

    private ParsingMode(Consumer<? super Config> consumer, PutAction putAction, MapPutAction mapPutAction) {
        this.preparationAction = consumer;
        this.putAction = putAction;
        this.mapPutAction = mapPutAction;
    }

    public void prepareParsing(Config config) {
        this.preparationAction.accept(config);
    }

    public Object put(Config config, List<String> list, Object object) {
        return this.putAction.put(config, list, object);
    }

    public Object put(Config config, String string, Object object) {
        return this.putAction.put(config, string, object);
    }

    public Object put(Map<String, Object> map, String string, Object object) {
        return this.mapPutAction.put(map, string, object);
    }

    @FunctionalInterface
    private static interface PutAction {
        public Object put(Config var1, List<String> var2, Object var3);

        default public Object put(Config config, String string, Object object) {
            return this.put(config, StringUtils.split(string, '.'), object);
        }
    }

    @FunctionalInterface
    private static interface MapPutAction {
        public Object put(Map<String, Object> var1, String var2, Object var3);
    }
}

