/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.AbstractCommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.AbstractConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.Config;
import me.roundaround.armorstands.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.InMemoryCommentedFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableCommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.concurrent.ConcurrentCommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.concurrent.StampedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.TransformingMap;

public final class SynchronizedConfig
implements ConcurrentCommentedConfig {
    private DataHolder dataHolder;
    final Object rootMonitor;

    public static SynchronizedConfig convert(Config config) {
        return SynchronizedConfig.convert(config, null);
    }

    private static SynchronizedConfig convert(Config config, SynchronizedConfig synchronizedConfig) {
        if (config instanceof SynchronizedConfig) {
            return (SynchronizedConfig)config;
        }
        SynchronizedConfig synchronizedConfig2 = new SynchronizedConfig(config.configFormat(), Config.getDefaultMapCreator(false), synchronizedConfig);
        CommentedConfig commentedConfig = CommentedConfig.fake(config);
        SynchronizedConfig.convertSubConfigs(commentedConfig, synchronizedConfig2);
        synchronizedConfig2.putAll(commentedConfig);
        synchronizedConfig2.putAllComments(commentedConfig);
        return synchronizedConfig2;
    }

    private static void convertSubConfigs(Config config, SynchronizedConfig synchronizedConfig) {
        if (config instanceof AbstractConfig) {
            AbstractConfig abstractConfig = (AbstractConfig)config;
            abstractConfig.valueMap().replaceAll((string, object) -> SynchronizedConfig.convertValue(object, synchronizedConfig));
        } else {
            for (Config.Entry entry : config.entrySet()) {
                Object object2;
                Object t = entry.getRawValue();
                if (t == (object2 = SynchronizedConfig.convertValue(t, synchronizedConfig))) continue;
                entry.setValue(object2);
            }
        }
    }

    private static Object convertValue(Object object2, SynchronizedConfig synchronizedConfig) {
        if (object2 instanceof Config) {
            SynchronizedConfig synchronizedConfig2 = SynchronizedConfig.convert((Config)object2, synchronizedConfig);
            SynchronizedConfig.convertSubConfigs(synchronizedConfig2, synchronizedConfig2);
            return synchronizedConfig2;
        }
        if (object2 instanceof List) {
            List list = (List)object2;
            ArrayList arrayList = new ArrayList(list);
            arrayList.replaceAll(object -> SynchronizedConfig.convertValue(object, synchronizedConfig));
            return arrayList;
        }
        return object2;
    }

    public SynchronizedConfig() {
        this(InMemoryCommentedFormat.defaultInstance(), Config.getDefaultMapCreator(false));
    }

    public SynchronizedConfig(ConfigFormat<?> configFormat, Supplier<Map<String, Object>> supplier) {
        this.rootMonitor = new Object();
        this.dataHolder = new DataHolder(this, configFormat, supplier);
    }

    public SynchronizedConfig(ConfigFormat<?> configFormat, Supplier<Map<String, Object>> supplier, SynchronizedConfig synchronizedConfig) {
        this.rootMonitor = synchronizedConfig == null ? new Object() : synchronizedConfig.rootMonitor;
        this.dataHolder = new DataHolder(synchronizedConfig == null ? this : synchronizedConfig, configFormat, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceContentBy(SynchronizedConfig synchronizedConfig) {
        Object object = this.rootMonitor;
        synchronized (object) {
            Object object2 = synchronizedConfig.rootMonitor;
            synchronized (object2) {
                this.dataHolder = synchronizedConfig.dataHolder;
                synchronizedConfig.dataHolder = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceContentBy(Config config) {
        if (config instanceof SynchronizedConfig) {
            this.replaceContentBy((SynchronizedConfig)config);
        } else {
            Object object;
            if (config instanceof StampedConfig) {
                throw new UnsupportedOperationException("SynchronizedConfig.replaceContentBy(StampedConfig) is illegal (and useless anyway).");
            }
            CommentedConfig commentedConfig = CommentedConfig.fake(config);
            Supplier<Map<String, Object>> supplier = null;
            if (config instanceof StampedConfig.Accumulator) {
                supplier = ((StampedConfig.Accumulator)config).mapSupplier();
            } else if (config instanceof AbstractConfig) {
                try {
                    object = ((AbstractConfig)config).valueMap();
                    if (object instanceof HashMap) {
                        supplier = HashMap::new;
                    } else if (object instanceof LinkedHashMap) {
                        supplier = LinkedHashMap::new;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    supplier = null;
                }
            }
            if (supplier == null) {
                supplier = Config.getDefaultMapCreator(false);
            }
            object = this.rootMonitor;
            synchronized (object) {
                DataHolder dataHolder = new DataHolder(this, config.configFormat(), supplier);
                dataHolder.putAll(commentedConfig);
                dataHolder.putAllComments(commentedConfig);
                SynchronizedConfig.convertSubConfigs(dataHolder, this);
                this.dataHolder = dataHolder;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R bulkCommentedRead(Function<? super UnmodifiableCommentedConfig, R> function) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return function.apply(this.dataHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> function) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return function.apply(this.dataHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(List<String> list, Object object) {
        Object object2 = this.rootMonitor;
        synchronized (object2) {
            return this.dataHolder.add(list, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearComments() {
        Object object = this.rootMonitor;
        synchronized (object) {
            this.dataHolder.clearComments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> commentMap() {
        Object object = this.rootMonitor;
        synchronized (object) {
            return new SynchronizedMap<String, String>(this.dataHolder.commentMap(), this.rootMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String removeComment(List<String> list) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.removeComment(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setComment(List<String> list, String string) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.setComment(list, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsComment(List<String> list) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.containsComment(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComment(List<String> list) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.getComment(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFormat<?> configFormat() {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.configFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.rootMonitor;
        synchronized (object) {
            this.dataHolder.clear();
        }
    }

    @Override
    public SynchronizedConfig createSubConfig() {
        return this.dataHolder.createSubConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends CommentedConfig.Entry> entrySet() {
        Object object = this.rootMonitor;
        synchronized (object) {
            return new SynchronizedSet<CommentedConfig.Entry>(this.dataHolder.entrySet(), this.rootMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T remove(List<String> list) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.remove(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T set(List<String> list, Object object) {
        Object object2 = this.rootMonitor;
        synchronized (object2) {
            return this.dataHolder.set(list, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.rootMonitor;
        synchronized (object) {
            return "SynchronizedConfig{" + this.dataHolder.toString() + "}";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(List<String> list) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.contains(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        Object object2 = this.rootMonitor;
        synchronized (object2) {
            return this.dataHolder.equals(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getRaw(List<String> list) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.getRaw(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Map<String, Object> valueMap() {
        Object object2 = this.rootMonitor;
        synchronized (object2) {
            TransformingMap<String, Object, Object> transformingMap = new TransformingMap<String, Object, Object>(this.dataHolder.valueMap(), object -> object, object -> SynchronizedConfig.convertValue(object, this), object -> object);
            return new SynchronizedMap<String, Object>(transformingMap, this.rootMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String string, Object object) {
        Object object2 = this.rootMonitor;
        synchronized (object2) {
            return this.dataHolder.add(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(UnmodifiableConfig unmodifiableConfig) {
        Object object = this.rootMonitor;
        synchronized (object) {
            this.dataHolder.addAll(unmodifiableConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(UnmodifiableConfig unmodifiableConfig) {
        Object object = this.rootMonitor;
        synchronized (object) {
            this.dataHolder.putAll(unmodifiableConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T remove(String string) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(UnmodifiableConfig unmodifiableConfig) {
        Object object = this.rootMonitor;
        synchronized (object) {
            this.dataHolder.removeAll(unmodifiableConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T set(String string, Object object) {
        Object object2 = this.rootMonitor;
        synchronized (object2) {
            return this.dataHolder.set(string, object);
        }
    }

    @Override
    public UnmodifiableCommentedConfig unmodifiable() {
        return this.dataHolder.unmodifiable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(List<String> list, Object object) {
        Object object2 = this.rootMonitor;
        synchronized (object2) {
            this.dataHolder.update(list, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T apply(List<String> list) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.apply(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(List<String> list) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.get(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNull(List<String> list) {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.isNull(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UnmodifiableCommentedConfig.CommentNode> getComments() {
        Object object = this.rootMonitor;
        synchronized (object) {
            return this.dataHolder.getComments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getComments(Map<String, UnmodifiableCommentedConfig.CommentNode> map) {
        Object object = this.rootMonitor;
        synchronized (object) {
            this.dataHolder.getComments(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAllComments(Map<String, UnmodifiableCommentedConfig.CommentNode> map) {
        Object object = this.rootMonitor;
        synchronized (object) {
            this.dataHolder.putAllComments(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAllComments(UnmodifiableCommentedConfig unmodifiableCommentedConfig) {
        Object object = this.rootMonitor;
        synchronized (object) {
            this.dataHolder.putAllComments(unmodifiableCommentedConfig);
        }
    }

    private static final class DataHolder
    extends AbstractCommentedConfig {
        private SynchronizedConfig syncConfig;
        private final ConfigFormat<?> format;

        DataHolder(SynchronizedConfig synchronizedConfig) {
            super(synchronizedConfig.dataHolder.mapCreator);
            this.format = synchronizedConfig.configFormat();
            this.syncConfig = synchronizedConfig;
        }

        DataHolder(SynchronizedConfig synchronizedConfig, ConfigFormat<?> configFormat, Supplier<Map<String, Object>> supplier) {
            super(supplier);
            this.format = configFormat;
            this.syncConfig = synchronizedConfig;
        }

        @Override
        public AbstractCommentedConfig clone() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SynchronizedConfig createSubConfig() {
            Object object = this.syncConfig.rootMonitor;
            synchronized (object) {
                return new SynchronizedConfig(this.format, this.mapCreator, this.syncConfig);
            }
        }

        @Override
        public ConfigFormat<?> configFormat() {
            return this.format;
        }
    }

    private static final class SynchronizedMap<K, V>
    implements Map<K, V> {
        private final Map<K, V> map;
        private final Object rootMonitor;

        SynchronizedMap(Map<K, V> map, Object object) {
            this.map = map;
            this.rootMonitor = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.rootMonitor;
            synchronized (object2) {
                return this.map.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.map.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.map.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.rootMonitor;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.rootMonitor;
            synchronized (object2) {
                return this.map.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = this.rootMonitor;
            synchronized (object2) {
                return this.map.containsValue(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return new SynchronizedSet<Map.Entry<K, V>>(this.map.entrySet(), this.rootMonitor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = this.rootMonitor;
            synchronized (object2) {
                return this.map.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.map.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.map.keySet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.rootMonitor;
            synchronized (object) {
                this.map.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object object) {
            Object object2 = this.rootMonitor;
            synchronized (object2) {
                return this.map.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.map.values();
            }
        }
    }

    private static final class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        SynchronizedSet(Set<E> set, Object object) {
            super(set, object);
        }
    }

    private static final class SynchronizedIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iter;
        private final Object rootMonitor;

        SynchronizedIterator(Iterator<E> iterator, Object object) {
            this.iter = iterator;
            this.rootMonitor = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            Object object = this.rootMonitor;
            synchronized (object) {
                this.iter.forEachRemaining(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.iter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.iter.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Object object = this.rootMonitor;
            synchronized (object) {
                this.iter.remove();
            }
        }
    }

    private static class SynchronizedCollection<E>
    implements Collection<E> {
        private final Collection<E> coll;
        private final Object rootMonitor;

        SynchronizedCollection(Collection<E> collection, Object object) {
            this.coll = collection;
            this.rootMonitor = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.rootMonitor;
            synchronized (object) {
                this.coll.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.rootMonitor;
            synchronized (object2) {
                return this.coll.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return new SynchronizedIterator<E>(this.coll.iterator(), this.rootMonitor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.rootMonitor;
            synchronized (object2) {
                return this.coll.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.toArray(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            Object object = this.rootMonitor;
            synchronized (object) {
                return this.coll.removeIf(predicate);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super E> consumer) {
            Object object = this.rootMonitor;
            synchronized (object) {
                this.coll.forEach(consumer);
            }
        }
    }
}

