/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core.concurrent;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.AbstractCommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.AbstractConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.Config;
import me.roundaround.armorstands.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.InMemoryCommentedFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.IncompatibleIntermediaryLevelException;
import me.roundaround.armorstands.roundalib.nightconfig.core.NullObject;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableCommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.concurrent.ConcurrentCommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.TransformingSet;

public final class StampedConfig
implements ConcurrentCommentedConfig {
    private final ConfigFormat<?> configFormat;
    private final Supplier<Map<String, Object>> mapSupplier;
    private Map<String, Object> values;
    private Map<String, String> comments;
    private final StampedLock lock = new StampedLock();
    private final ThreadLocal<ThreadConfigState> state = ThreadLocal.withInitial(() -> ThreadConfigState.NORMAL);

    public StampedConfig() {
        this(InMemoryCommentedFormat.defaultInstance(), Config.getDefaultMapCreator(false));
    }

    public StampedConfig(ConfigFormat<?> configFormat, Supplier<Map<String, Object>> supplier) {
        this.configFormat = configFormat;
        this.mapSupplier = supplier;
        this.values = supplier.get();
        this.comments = supplier.get();
    }

    StampedConfig(ConfigFormat<?> configFormat, Supplier<Map<String, Object>> supplier, Map<String, Object> map, Map<String, String> map2) {
        this.configFormat = configFormat;
        this.mapSupplier = supplier;
        this.values = map;
        this.comments = map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceContentBy(StampedConfig stampedConfig) {
        this.checkStateForNormalOp();
        long l = this.lock.writeLock();
        try {
            long l2 = stampedConfig.lock.writeLock();
            try {
                this.values = stampedConfig.values;
                this.comments = stampedConfig.comments;
                stampedConfig.values = null;
                stampedConfig.comments = null;
            }
            finally {
                stampedConfig.lock.unlockWrite(l2);
            }
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceContentBy(Accumulator accumulator) {
        this.checkStateForNormalOp();
        long l = this.lock.writeLock();
        try {
            accumulator.prepareReplacement();
            this.values = accumulator.values();
            this.comments = accumulator.comments();
            accumulator.invalidate();
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    public Accumulator newAccumulator() {
        return new Accumulator(this.configFormat, this.mapSupplier);
    }

    public Accumulator newAccumulatorCopy() {
        Accumulator accumulator = (Accumulator)this.copyValueInAccumulator(this);
        return accumulator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object copyValueInAccumulator(Object object2) {
        if (object2 instanceof StampedConfig) {
            StampedConfig stampedConfig = (StampedConfig)object2;
            stampedConfig.checkStateForNormalOp();
            long l = stampedConfig.lock.readLock();
            try {
                Map<String, Object> map = this.mapSupplier.get();
                map.putAll(stampedConfig.values);
                map.replaceAll((string, object) -> this.copyValueInAccumulator(object));
                Map<String, Object> map2 = this.mapSupplier.get();
                map2.putAll(stampedConfig.comments);
                Accumulator accumulator = new Accumulator(map, map2, this.mapSupplier, this.configFormat);
                return accumulator;
            }
            finally {
                stampedConfig.lock.unlockRead(l);
            }
        }
        if (object2 instanceof List) {
            List list = (List)object2;
            ArrayList arrayList = new ArrayList(list);
            arrayList.replaceAll(object -> this.copyValueInAccumulator(object));
            return arrayList;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V mapLockGet(Map<String, V> map, StampedLock stampedLock, String string) {
        long l = stampedLock.tryOptimisticRead();
        V v = map.get(string);
        if (!stampedLock.validate(l)) {
            this.checkStateForNormalOp();
            l = stampedLock.readLock();
            try {
                v = map.get(string);
            }
            finally {
                stampedLock.unlockRead(l);
            }
        } else assert (this.state.get() == ThreadConfigState.NORMAL) : "invalid state " + String.valueOf((Object)this.state.get()) + " are you using bulk operations / iterators properly?";
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> boolean mapLockContains(Map<String, V> map, StampedLock stampedLock, String string) {
        long l = stampedLock.tryOptimisticRead();
        boolean bl = map.containsKey(string);
        if (!stampedLock.validate(l)) {
            this.checkStateForNormalOp();
            l = stampedLock.readLock();
            try {
                bl = map.containsKey(string);
            }
            finally {
                stampedLock.unlockRead(l);
            }
        }
        assert (this.state.get() == ThreadConfigState.NORMAL) : "invalid state " + String.valueOf((Object)this.state.get()) + " are you using bulk operations / iterators properly?";
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V mapLockRemove(Map<String, V> map, StampedLock stampedLock, String string) {
        long l = stampedLock.tryWriteLock();
        if (l == 0L) {
            this.checkStateForNormalOp();
            l = stampedLock.writeLock();
        }
        assert (this.state.get() == ThreadConfigState.NORMAL) : "invalid state " + String.valueOf((Object)this.state.get()) + " are you using bulk operations / iterators properly?";
        try {
            V v = map.remove(string);
            return v;
        }
        finally {
            stampedLock.unlockWrite(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V mapLockPut(Map<String, V> map, StampedLock stampedLock, String string, V v) {
        long l = stampedLock.tryWriteLock();
        if (l == 0L) {
            this.checkStateForNormalOp();
            l = stampedLock.writeLock();
        }
        assert (this.state.get() == ThreadConfigState.NORMAL) : "invalid state " + String.valueOf((Object)this.state.get()) + " are you using bulk operations / iterators properly?";
        try {
            V v2 = map.put(string, v);
            return v2;
        }
        finally {
            stampedLock.unlockWrite(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V mapLockPutIfAbsent(Map<String, V> map, StampedLock stampedLock, String string, V v) {
        long l = stampedLock.tryWriteLock();
        if (l == 0L) {
            this.checkStateForNormalOp();
            l = stampedLock.writeLock();
        }
        assert (this.state.get() == ThreadConfigState.NORMAL) : "invalid state " + String.valueOf((Object)this.state.get()) + " are you using bulk operations / iterators properly?";
        try {
            V v2 = map.putIfAbsent(string, v);
            return v2;
        }
        finally {
            stampedLock.unlockWrite(l);
        }
    }

    private StampedConfig getExistingConfig(List<String> list, boolean bl) {
        StampedConfig stampedConfig = this;
        for (String string : list) {
            Object object = this.mapLockGet(stampedConfig.values, stampedConfig.lock, string);
            if (object == null) {
                return null;
            }
            if (object instanceof StampedConfig) {
                stampedConfig = (StampedConfig)object;
                continue;
            }
            if (bl) {
                throw new IncompatibleIntermediaryLevelException("Cannot get entry with parent path " + String.valueOf(list) + " because of an incompatible intermediary value of type: " + String.valueOf(object.getClass()));
            }
            return null;
        }
        return stampedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StampedConfig getOrCreateConfig(List<String> list) {
        assert (this.state.get() == ThreadConfigState.NORMAL) : "invalid state " + String.valueOf((Object)this.state.get()) + " are you using bulk operations / iterators properly?";
        StampedConfig stampedConfig = this;
        for (String string : list) {
            StampedLock stampedLock = stampedConfig.lock;
            Map<String, Object> map = stampedConfig.values;
            long l = stampedLock.tryOptimisticRead();
            boolean bl = false;
            try {
                Object object = map.get(string);
                if (!stampedLock.validate(l)) {
                    this.checkStateForNormalOp();
                    l = stampedLock.readLock();
                    bl = true;
                    object = map.get(string);
                }
                if (object == null) {
                    if ((l = stampedLock.tryConvertToWriteLock(l)) == 0L) {
                        this.checkStateForNormalOp();
                        l = stampedLock.writeLock();
                    }
                    bl = true;
                    stampedConfig = this.createSubConfig();
                    map.put(string, stampedConfig);
                    continue;
                }
                if (object instanceof StampedConfig) {
                    stampedConfig = (StampedConfig)object;
                    continue;
                }
                throw new IncompatibleIntermediaryLevelException("Cannot get/create entry with parent path " + String.valueOf(list) + " because of an incompatible intermediary value of type: " + String.valueOf(object.getClass()));
            }
            finally {
                if (!bl) continue;
                stampedLock.unlock(l);
            }
        }
        return stampedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long l = this.lock.tryOptimisticRead();
        int n = this.values.size();
        if (!this.lock.validate(l)) {
            this.checkStateForNormalOp();
            l = this.lock.readLock();
            try {
                n = this.values.size();
            }
            finally {
                this.lock.unlockRead(l);
            }
        }
        return n;
    }

    @Override
    public StampedConfig createSubConfig() {
        return new StampedConfig(this.configFormat, this.mapSupplier);
    }

    @Override
    public ConfigFormat<?> configFormat() {
        return this.configFormat;
    }

    @Override
    public Map<String, Object> valueMap() {
        throw new UnsupportedOperationException("StampedConfig does not support valueMap() yet.");
    }

    @Override
    public void clear() {
        long l = this.lock.tryWriteLock();
        if (l == 0L) {
            this.checkStateForNormalOp();
            l = this.lock.writeLock();
        }
        try {
            this.values.clear();
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    @Override
    public <T> T getRaw(List<String> list) {
        switch (list.size()) {
            case 0: {
                throw new IllegalArgumentException("empty entry path");
            }
            case 1: {
                return (T)this.mapLockGet(this.values, this.lock, list.get(0));
            }
        }
        int n = list.size() - 1;
        List<String> list2 = list.subList(0, n);
        StampedConfig stampedConfig = this.getExistingConfig(list2, false);
        if (stampedConfig == null) {
            return null;
        }
        return (T)this.mapLockGet(stampedConfig.values, stampedConfig.lock, list.get(n));
    }

    @Override
    public boolean contains(List<String> list) {
        switch (list.size()) {
            case 0: {
                throw new IllegalArgumentException("empty entry path");
            }
            case 1: {
                return this.mapLockContains(this.values, this.lock, list.get(0));
            }
        }
        int n = list.size() - 1;
        List<String> list2 = list.subList(0, n);
        StampedConfig stampedConfig = this.getExistingConfig(list2, false);
        return stampedConfig != null && this.mapLockContains(stampedConfig.values, stampedConfig.lock, list.get(n));
    }

    @Override
    public boolean add(List<String> list, Object object) {
        Object object2 = object == null ? NullObject.NULL_OBJECT : object;
        switch (list.size()) {
            case 0: {
                throw new IllegalArgumentException("empty entry path");
            }
            case 1: {
                return this.mapLockPutIfAbsent(this.values, this.lock, list.get(0), object2) == null;
            }
        }
        int n = list.size() - 1;
        List<String> list2 = list.subList(0, n);
        StampedConfig stampedConfig = this.getOrCreateConfig(list2);
        Object object3 = this.mapLockPutIfAbsent(stampedConfig.values, stampedConfig.lock, list.get(n), object2);
        return object3 == null;
    }

    @Override
    public <T> T remove(List<String> list) {
        switch (list.size()) {
            case 0: {
                throw new IllegalArgumentException("empty entry path");
            }
            case 1: {
                return (T)this.mapLockRemove(this.values, this.lock, list.get(0));
            }
        }
        int n = list.size() - 1;
        List<String> list2 = list.subList(0, n);
        StampedConfig stampedConfig = this.getExistingConfig(list2, false);
        if (stampedConfig == null) {
            return null;
        }
        return (T)this.mapLockRemove(stampedConfig.values, stampedConfig.lock, list.get(n));
    }

    @Override
    public <T> T set(List<String> list, Object object) {
        Object object2 = object == null ? NullObject.NULL_OBJECT : object;
        switch (list.size()) {
            case 0: {
                throw new IllegalArgumentException("empty entry path");
            }
            case 1: {
                return (T)this.mapLockPut(this.values, this.lock, list.get(0), object2);
            }
        }
        int n = list.size() - 1;
        List<String> list2 = list.subList(0, n);
        StampedConfig stampedConfig = this.getOrCreateConfig(list2);
        return (T)this.mapLockPut(stampedConfig.values, stampedConfig.lock, list.get(n), object2);
    }

    private void convertSubConfigs(Config config) {
        if (config instanceof AbstractConfig) {
            AbstractConfig abstractConfig = (AbstractConfig)config;
            try {
                abstractConfig.valueMap().replaceAll((string, object) -> this.convertValue(object));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                abstractConfig.entrySet().forEach(entry -> entry.setValue(this.convertValue(entry.getRawValue())));
            }
        } else {
            for (Config.Entry entry2 : config.entrySet()) {
                Object object2;
                Object t = entry2.getRawValue();
                if (t == (object2 = this.convertValue(t))) continue;
                entry2.setValue(object2);
            }
        }
    }

    private Object convertValue(Object object2) {
        if (object2 instanceof StampedConfig) {
            return object2;
        }
        if (object2 instanceof Config) {
            Config config = (Config)object2;
            StampedConfig stampedConfig = this.createSubConfig();
            this.convertSubConfigs(config);
            stampedConfig.putAll(config);
            return stampedConfig;
        }
        if (object2 instanceof List) {
            List list = (List)object2;
            list.replaceAll(object -> this.convertValue(object));
            return list;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(UnmodifiableConfig unmodifiableConfig) {
        long l = this.lock.tryWriteLock();
        if (l == 0L) {
            this.checkStateForNormalOp();
            l = this.lock.writeLock();
        }
        try {
            this.unsafePutAll(unmodifiableConfig);
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsafePutAll(UnmodifiableConfig unmodifiableConfig) {
        if (unmodifiableConfig == this) {
            throw new IllegalArgumentException("I cannot putAll() into myself.");
        }
        if (unmodifiableConfig instanceof StampedConfig) {
            StampedConfig stampedConfig = (StampedConfig)unmodifiableConfig;
            long l = stampedConfig.lock.tryReadLock();
            if (l == 0L) {
                stampedConfig.checkStateForNormalOp();
                l = stampedConfig.lock.readLock();
            }
            try {
                this.values.putAll(stampedConfig.values);
            }
            finally {
                stampedConfig.lock.unlockRead(l);
            }
        }
        this.convertSubConfigs((Config)unmodifiableConfig);
        try {
            Map<String, Object> map = unmodifiableConfig.valueMap();
            this.values.putAll(map);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            unmodifiableConfig.entrySet().forEach(entry -> this.values.put(entry.getKey(), entry.getRawValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsafeRemoveAll(UnmodifiableConfig unmodifiableConfig) {
        if (unmodifiableConfig == this) {
            throw new IllegalArgumentException("I cannot removeAll() from myself.");
        }
        if (unmodifiableConfig instanceof StampedConfig) {
            StampedConfig stampedConfig = (StampedConfig)unmodifiableConfig;
            long l = stampedConfig.lock.tryReadLock();
            if (l == 0L) {
                stampedConfig.checkStateForNormalOp();
                l = stampedConfig.lock.readLock();
            }
            try {
                this.values.keySet().removeAll(stampedConfig.values.keySet());
            }
            finally {
                stampedConfig.lock.unlockRead(l);
            }
        }
        try {
            Set<String> set = unmodifiableConfig.valueMap().keySet();
            this.values.keySet().removeAll(set);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            unmodifiableConfig.entrySet().forEach(entry -> this.values.remove(entry.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(UnmodifiableConfig unmodifiableConfig) {
        long l = this.lock.tryWriteLock();
        if (l == 0L) {
            this.checkStateForNormalOp();
            l = this.lock.writeLock();
        }
        try {
            this.unsafeRemoveAll(unmodifiableConfig);
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    @Override
    public void clearComments() {
        this.checkStateForNormalOp();
        this.bulkCommentedUpdate((? super CommentedConfig commentedConfig) -> commentedConfig.clearComments());
    }

    @Override
    public String removeComment(List<String> list) {
        switch (list.size()) {
            case 0: {
                throw new IllegalArgumentException("empty entry path");
            }
            case 1: {
                return this.mapLockRemove(this.comments, this.lock, list.get(0));
            }
        }
        int n = list.size() - 1;
        List<String> list2 = list.subList(0, n);
        StampedConfig stampedConfig = this.getExistingConfig(list2, false);
        if (stampedConfig == null) {
            return null;
        }
        return this.mapLockRemove(stampedConfig.comments, stampedConfig.lock, list.get(n));
    }

    @Override
    public String setComment(List<String> list, String string) {
        switch (list.size()) {
            case 0: {
                throw new IllegalArgumentException("empty entry path");
            }
            case 1: {
                return this.mapLockPut(this.comments, this.lock, list.get(0), string);
            }
        }
        int n = list.size() - 1;
        List<String> list2 = list.subList(0, n);
        StampedConfig stampedConfig = this.getOrCreateConfig(list2);
        return this.mapLockPut(stampedConfig.comments, stampedConfig.lock, list.get(n), string);
    }

    @Override
    public boolean containsComment(List<String> list) {
        switch (list.size()) {
            case 0: {
                throw new IllegalArgumentException("empty entry path");
            }
            case 1: {
                return this.mapLockContains(this.comments, this.lock, list.get(0));
            }
        }
        int n = list.size() - 1;
        List<String> list2 = list.subList(0, n);
        StampedConfig stampedConfig = this.getExistingConfig(list2, false);
        return stampedConfig != null && this.mapLockContains(stampedConfig.comments, stampedConfig.lock, list.get(n));
    }

    @Override
    public String getComment(List<String> list) {
        switch (list.size()) {
            case 0: {
                throw new IllegalArgumentException("empty entry path");
            }
            case 1: {
                return this.mapLockGet(this.comments, this.lock, list.get(0));
            }
        }
        int n = list.size() - 1;
        List<String> list2 = list.subList(0, n);
        StampedConfig stampedConfig = this.getExistingConfig(list2, false);
        if (stampedConfig == null) {
            return null;
        }
        return this.mapLockGet(stampedConfig.comments, stampedConfig.lock, list.get(n));
    }

    @Override
    public Map<String, String> commentMap() {
        throw new UnsupportedOperationException("StampedConfig does not support commentMap() yet.");
    }

    @Override
    public void putAllComments(UnmodifiableCommentedConfig unmodifiableCommentedConfig) {
        if (unmodifiableCommentedConfig == this) {
            throw new IllegalArgumentException("I cannot putAllComments() into myself.");
        }
        this.bulkUpdate((? super Config config) -> {
            if (unmodifiableCommentedConfig instanceof StampedConfig) {
                StampedConfig stampedConfig = (StampedConfig)unmodifiableCommentedConfig;
                long l = stampedConfig.lock.tryReadLock();
                if (l == 0L) {
                    stampedConfig.checkStateForNormalOp();
                    l = stampedConfig.lock.readLock();
                }
                try {
                    this.comments.putAll(stampedConfig.comments);
                    for (CommentedConfig.Entry entry2 : stampedConfig.entrySet()) {
                        Object object;
                        Object t = entry2.getRawValue();
                        if (!(t instanceof StampedConfig) || !((object = this.values.get(entry2.getKey())) instanceof StampedConfig)) continue;
                        ((StampedConfig)object).putAllComments((StampedConfig)t);
                    }
                }
                finally {
                    stampedConfig.lock.unlockRead(l);
                }
            }
            try {
                Map<String, String> map = unmodifiableCommentedConfig.commentMap();
                this.comments.putAll(map);
                for (UnmodifiableCommentedConfig.Entry entry3 : unmodifiableCommentedConfig.entrySet()) {
                    Object object;
                    Object t = entry3.getRawValue();
                    if (!(t instanceof UnmodifiableCommentedConfig) || !((object = this.values.get(entry3.getKey())) instanceof StampedConfig)) continue;
                    ((StampedConfig)object).putAllComments((UnmodifiableCommentedConfig)t);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                unmodifiableCommentedConfig.entrySet().forEach(entry -> {
                    Object object;
                    this.comments.put(entry.getKey(), entry.getComment());
                    Object t = entry.getRawValue();
                    if (t instanceof UnmodifiableCommentedConfig && (object = this.values.get(entry.getKey())) instanceof StampedConfig) {
                        ((StampedConfig)object).putAllComments((UnmodifiableCommentedConfig)t);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAllComments(Map<String, UnmodifiableCommentedConfig.CommentNode> map) {
        long l = this.lock.tryWriteLock();
        if (l == 0L) {
            this.checkStateForNormalOp();
            l = this.lock.writeLock();
        }
        try {
            map.forEach((string, commentNode) -> {
                Object object;
                this.comments.put((String)string, commentNode.getComment());
                Map<String, UnmodifiableCommentedConfig.CommentNode> map = commentNode.getChildren();
                if (map != null && (object = this.values.get(string)) instanceof StampedConfig) {
                    ((StampedConfig)object).putAllComments(map);
                }
            });
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StampedConfig) {
            return this.bulkCommentedRead((? super UnmodifiableCommentedConfig unmodifiableCommentedConfig) -> ((StampedConfig)object).bulkCommentedRead((? super UnmodifiableCommentedConfig unmodifiableCommentedConfig2) -> unmodifiableCommentedConfig.equals(unmodifiableCommentedConfig2)));
        }
        if (object instanceof UnmodifiableConfig) {
            return this.bulkRead((? super UnmodifiableConfig unmodifiableConfig) -> unmodifiableConfig.equals(object));
        }
        return false;
    }

    public String toString() {
        return this.bulkRead((? super UnmodifiableConfig unmodifiableConfig) -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("StampedConfig{");
            for (UnmodifiableConfig.Entry entry : unmodifiableConfig.entrySet()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append('=');
                stringBuilder.append(String.valueOf(entry.getRawValue()));
                stringBuilder.append(", ");
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        });
    }

    @Override
    public Set<? extends CommentedConfig.Entry> entrySet() {
        return new EntrySet();
    }

    private void checkStateForBulkOp() {
        switch (this.state.get().ordinal()) {
            case 1: {
                throw new IllegalStateException("StampedConfig.{bulkRead, bulkUpdate, bulkCommentedRead, bulkCommentedUpdate} cannot be nested.");
            }
            case 2: {
                throw new IllegalStateException("Entries provided by StampedConfig.entrySet() cannot be used during another operation on the config nor on its entrySet, for thread-safety reasons (and to avoid deadlocks).");
            }
            case 3: {
                throw new IllegalStateException("This StampedConfig has been given to otherConfig.replaceContentBy() and cannot be used anymore.");
            }
        }
    }

    private void checkStateForNormalOp() {
        switch (this.state.get().ordinal()) {
            case 1: {
                throw new IllegalStateException("StampedConfig cannot be used inside of bulk operations, you must use the argument provided to your function by bulk, for example: bulkUpdate(bulkedConf -> {/* use bulkedConf here*/}).");
            }
            case 2: {
                throw new IllegalStateException("Entries provided by StampedConfig.entrySet() cannot be used during another operation on the config nor on its entrySet, for thread-safety reasons (and to avoid deadlocks).");
            }
            case 3: {
                throw new IllegalStateException("This StampedConfig has been given to otherConfig.replaceContentBy() and cannot be used anymore.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R bulkRead(Function<? super UnmodifiableConfig, R> function) {
        long l = this.lock.tryReadLock();
        if (l == 0L) {
            this.checkStateForBulkOp();
            l = this.lock.readLock();
        }
        try {
            this.checkStateForBulkOp();
        }
        catch (IllegalStateException illegalStateException) {
            this.lock.unlockRead(l);
            throw illegalStateException;
        }
        this.state.set(ThreadConfigState.IN_BULK_OP);
        ReadOnlyLockedView readOnlyLockedView = new ReadOnlyLockedView();
        try {
            R r = function.apply(readOnlyLockedView);
            return r;
        }
        finally {
            readOnlyLockedView.invalidate();
            this.state.set(ThreadConfigState.NORMAL);
            this.lock.unlockRead(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R bulkUpdate(Function<? super Config, R> function) {
        long l = this.lock.tryWriteLock();
        if (l == 0L) {
            this.checkStateForBulkOp();
            l = this.lock.writeLock();
        }
        try {
            this.checkStateForBulkOp();
        }
        catch (IllegalStateException illegalStateException) {
            this.lock.unlockWrite(l);
            throw illegalStateException;
        }
        this.state.set(ThreadConfigState.IN_BULK_OP);
        WritableLockedView writableLockedView = new WritableLockedView();
        try {
            R r = function.apply(writableLockedView);
            return r;
        }
        finally {
            writableLockedView.invalidate();
            this.state.set(ThreadConfigState.NORMAL);
            this.lock.unlockWrite(l);
        }
    }

    @Override
    public <R> R bulkCommentedRead(Function<? super UnmodifiableCommentedConfig, R> function) {
        return this.bulkRead(function);
    }

    @Override
    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> function) {
        return this.bulkUpdate(function);
    }

    public static final class Accumulator
    extends AbstractCommentedConfig {
        private final StampedConfig mirror;
        private boolean valid = true;

        Accumulator(Map<String, Object> map, Map<String, String> map2, Supplier<Map<String, Object>> supplier, ConfigFormat<?> configFormat) {
            super(map, map2);
            this.mirror = new StampedConfig(configFormat, supplier, map, map2);
        }

        Accumulator(ConfigFormat<?> configFormat, Supplier<Map<String, Object>> supplier) {
            super(supplier);
            this.mirror = new StampedConfig(configFormat, supplier, this.map, this.commentMap);
        }

        private void checkValid() {
            if (!this.valid) {
                throw new IllegalStateException("This StampedConfig.Accumulator is no longer valid after a call to replaceContentBy().");
            }
        }

        void invalidate() {
            this.valid = false;
        }

        Map<String, Object> values() {
            return this.map;
        }

        Map<String, String> comments() {
            return this.commentMap;
        }

        Supplier<Map<String, Object>> mapSupplier() {
            return this.mapCreator;
        }

        void prepareReplacement() {
            this.checkValid();
            this.map.replaceAll((string, object) -> this.replaceValue(object));
        }

        private Object replaceValue(Object object2) {
            if (object2 instanceof Accumulator) {
                Accumulator accumulator = (Accumulator)object2;
                accumulator.prepareReplacement();
                return accumulator.mirror;
            }
            if (object2 instanceof UnmodifiableConfig) {
                throw new IllegalStateException("Invalid sub-configuration of type " + object2.getClass().getSimpleName() + " in the Accumulator. Sub-configurations must always be created with createSubConfig().");
            }
            if (object2 instanceof List) {
                List list = (List)object2;
                ArrayList arrayList = new ArrayList(list);
                arrayList.replaceAll(object -> this.replaceValue(object));
                return arrayList;
            }
            return object2;
        }

        @Override
        public AbstractCommentedConfig clone() {
            Accumulator accumulator = new Accumulator(this.configFormat(), (Supplier<Map<String, Object>>)this.mapCreator);
            accumulator.map.putAll(this.map);
            accumulator.commentMap.putAll(this.commentMap);
            return accumulator;
        }

        @Override
        public CommentedConfig createSubConfig() {
            return new Accumulator(this.configFormat(), (Supplier<Map<String, Object>>)this.mapCreator);
        }

        @Override
        public ConfigFormat<?> configFormat() {
            this.checkValid();
            return this.mirror.configFormat();
        }
    }

    private static enum ThreadConfigState {
        NORMAL,
        IN_BULK_OP,
        IN_ITER_OP,
        CONSUMED;

    }

    private class EntrySet
    extends AbstractCollection<LazyEntry>
    implements Set<LazyEntry> {
        private EntrySet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<LazyEntry> iterator() {
            StampedConfig.this.checkStateForNormalOp();
            long l = StampedConfig.this.lock.readLock();
            try {
                StampedConfig.this.state.set(ThreadConfigState.IN_ITER_OP);
                LazyEntry[] lazyEntryArray = new LazyEntry[StampedConfig.this.values.size()];
                int n = 0;
                for (Map.Entry<String, Object> entry : StampedConfig.this.values.entrySet()) {
                    lazyEntryArray[n++] = new LockingLazyEntry(entry.getKey(), this);
                }
                EntryIterator entryIterator = new EntryIterator(lazyEntryArray);
                return entryIterator;
            }
            finally {
                StampedConfig.this.state.set(ThreadConfigState.NORMAL);
                StampedConfig.this.lock.unlockRead(l);
            }
        }

        @Override
        public int size() {
            return StampedConfig.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super LazyEntry> consumer) {
            long l = StampedConfig.this.lock.tryWriteLock();
            if (l == 0L) {
                StampedConfig.this.checkStateForNormalOp();
                l = StampedConfig.this.lock.writeLock();
            }
            try {
                StampedConfig.this.state.set(ThreadConfigState.IN_ITER_OP);
                StampedConfig.this.values.forEach((? super K string, ? super V object) -> {
                    InLockLazyEntry inLockLazyEntry = new InLockLazyEntry((String)string);
                    try {
                        consumer.accept(inLockLazyEntry);
                    }
                    finally {
                        inLockLazyEntry.invalidate();
                    }
                });
            }
            finally {
                StampedConfig.this.state.set(ThreadConfigState.NORMAL);
                StampedConfig.this.lock.unlockWrite(l);
            }
        }

        @Override
        public boolean add(LazyEntry lazyEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            StampedConfig.this.bulkCommentedUpdate(commentedConfig -> {
                commentedConfig.clear();
                commentedConfig.clearComments();
            });
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof UnmodifiableConfig.Entry) {
                UnmodifiableConfig.Entry entry = (UnmodifiableConfig.Entry)object;
                Object t = entry.getRawValue();
                Object t2 = StampedConfig.this.getRaw(Collections.singletonList(entry.getKey()));
                return t == null ? t2 == null : t.equals(t2);
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return StampedConfig.this.isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private class ReadOnlyLockedView
    implements UnmodifiableCommentedConfig {
        private boolean valid = true;

        private ReadOnlyLockedView() {
        }

        void invalidate() {
            this.valid = false;
        }

        protected void checkValid() {
            if (!this.valid) {
                throw new IllegalStateException("View provided by bulk operations are only valid in the scope of the bulkRead or bulkWrite method.To use the config elsewhere, use the actual config variable (not the one provided to your bulk action).");
            }
        }

        @Override
        public Map<String, String> commentMap() {
            throw new UnsupportedOperationException("The view provided by bulk operations on StampedConfig does not support commentMap()");
        }

        @Override
        public Set<? extends UnmodifiableCommentedConfig.Entry> entrySet() {
            this.checkValid();
            return new TransformingSet<Map.Entry, Entry>(StampedConfig.this.values.entrySet(), entry -> new Entry((Map.Entry<String, Object>)entry), entry -> null, object -> {
                this.checkValid();
                return object;
            });
        }

        @Override
        public boolean containsComment(List<String> list) {
            this.checkValid();
            switch (list.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty entry path");
                }
                case 1: {
                    String string = list.get(0);
                    return StampedConfig.this.comments.containsKey(string);
                }
            }
            Object object = StampedConfig.this.values.get(list.get(0));
            if (object instanceof StampedConfig) {
                StampedConfig stampedConfig = (StampedConfig)object;
                return stampedConfig.containsComment(list.subList(1, list.size()));
            }
            return false;
        }

        @Override
        public String getComment(List<String> list) {
            this.checkValid();
            switch (list.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty entry path");
                }
                case 1: {
                    String string = list.get(0);
                    return StampedConfig.this.comments.get(string);
                }
            }
            Object object = StampedConfig.this.values.get(list.get(0));
            if (object instanceof StampedConfig) {
                StampedConfig stampedConfig = (StampedConfig)object;
                return stampedConfig.getComment(list.subList(1, list.size()));
            }
            return null;
        }

        @Override
        public ConfigFormat<?> configFormat() {
            this.checkValid();
            return StampedConfig.this.configFormat;
        }

        @Override
        public boolean contains(List<String> list) {
            this.checkValid();
            switch (list.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty entry path");
                }
                case 1: {
                    String string = list.get(0);
                    return StampedConfig.this.values.containsKey(string);
                }
            }
            Object object = StampedConfig.this.values.get(list.get(0));
            if (object instanceof StampedConfig) {
                StampedConfig stampedConfig = (StampedConfig)object;
                return stampedConfig.contains(list.subList(1, list.size()));
            }
            return false;
        }

        @Override
        public <T> T getRaw(List<String> list) {
            this.checkValid();
            switch (list.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty entry path");
                }
                case 1: {
                    String string = list.get(0);
                    return (T)StampedConfig.this.values.get(string);
                }
            }
            Object object = StampedConfig.this.values.get(list.get(0));
            if (object instanceof StampedConfig) {
                StampedConfig stampedConfig = (StampedConfig)object;
                return stampedConfig.getRaw(list.subList(1, list.size()));
            }
            return null;
        }

        @Override
        public int size() {
            this.checkValid();
            return StampedConfig.this.values.size();
        }

        @Override
        public Map<String, Object> valueMap() {
            throw new UnsupportedOperationException("The view provided by bulk operations on StampedConfig does not support valueMap()");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("StampedConfig#LockedView{");
            for (UnmodifiableCommentedConfig.Entry entry : this.entrySet()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append('=');
                stringBuilder.append(String.valueOf(entry.getRawValue()));
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof UnmodifiableConfig)) {
                return false;
            }
            UnmodifiableConfig unmodifiableConfig = (UnmodifiableConfig)object;
            if (unmodifiableConfig.size() != this.size()) {
                return false;
            }
            for (UnmodifiableConfig.Entry entry : this.entrySet()) {
                Object t = entry.getValue();
                Object t2 = unmodifiableConfig.get(Collections.singletonList(entry.getKey()));
                if (!(t == null ? t2 != null : !t.equals(t2))) continue;
                return false;
            }
            return true;
        }

        protected class Entry
        implements UnmodifiableCommentedConfig.Entry {
            protected final Map.Entry<String, Object> mapEntry;

            Entry(Map.Entry<String, Object> entry) {
                this.mapEntry = entry;
                ReadOnlyLockedView.this.checkValid();
            }

            @Override
            public String getComment() {
                ReadOnlyLockedView.this.checkValid();
                return StampedConfig.this.comments.get(this.mapEntry.getKey());
            }

            @Override
            public String getKey() {
                ReadOnlyLockedView.this.checkValid();
                return this.mapEntry.getKey();
            }

            @Override
            public <T> T getRawValue() {
                ReadOnlyLockedView.this.checkValid();
                return (T)this.mapEntry.getValue();
            }
        }
    }

    private final class WritableLockedView
    extends ReadOnlyLockedView
    implements CommentedConfig {
        private WritableLockedView() {
        }

        @Override
        public void clear() {
            this.checkValid();
            StampedConfig.this.values.clear();
        }

        @Override
        public void removeAll(UnmodifiableConfig unmodifiableConfig) {
            this.checkValid();
            StampedConfig.this.unsafeRemoveAll(unmodifiableConfig);
        }

        @Override
        public void putAll(UnmodifiableConfig unmodifiableConfig) {
            this.checkValid();
            StampedConfig.this.unsafePutAll(unmodifiableConfig);
        }

        @Override
        public void clearComments() {
            this.checkValid();
            StampedConfig.this.comments.clear();
            for (Object object : StampedConfig.this.values.values()) {
                if (!(object instanceof StampedConfig)) continue;
                ((StampedConfig)object).clearComments();
            }
        }

        @Override
        public StampedConfig createSubConfig() {
            this.checkValid();
            return new StampedConfig(StampedConfig.this.configFormat, StampedConfig.this.mapSupplier);
        }

        @Override
        public Set<? extends CommentedConfig.Entry> entrySet() {
            this.checkValid();
            return new TransformingSet<Map.Entry, Entry>(StampedConfig.this.values.entrySet(), entry -> new Entry((Map.Entry<String, Object>)entry), entry -> null, object -> {
                this.checkValid();
                return object;
            });
        }

        @Override
        public <T> T remove(List<String> list) {
            this.checkValid();
            switch (list.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty entry path");
                }
                case 1: {
                    String string = list.get(0);
                    return (T)StampedConfig.this.values.remove(string);
                }
            }
            int n = list.size() - 1;
            Object t = this.getRaw(list.subList(0, n));
            if (t instanceof StampedConfig) {
                StampedConfig stampedConfig = (StampedConfig)t;
                String string = list.get(n);
                return (T)stampedConfig.values.remove(string);
            }
            return null;
        }

        @Override
        public String removeComment(List<String> list) {
            this.checkValid();
            switch (list.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty entry path");
                }
                case 1: {
                    String string = list.get(0);
                    return StampedConfig.this.comments.remove(string);
                }
            }
            int n = list.size() - 1;
            Object t = this.getRaw(list.subList(0, n));
            if (t instanceof StampedConfig) {
                StampedConfig stampedConfig = (StampedConfig)t;
                String string = list.get(n);
                return stampedConfig.comments.remove(string);
            }
            return null;
        }

        @Override
        public <T> T set(List<String> list, Object object) {
            this.checkValid();
            switch (list.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty entry path");
                }
                case 1: {
                    String string = list.get(0);
                    Object object2 = object == null ? NullObject.NULL_OBJECT : object;
                    return (T)StampedConfig.this.values.put(string, object2);
                }
            }
            String string = list.get(0);
            List<String> list2 = list.subList(1, list.size());
            Object object3 = StampedConfig.this.values.get(string);
            if (object3 == null) {
                StampedConfig stampedConfig = this.createSubConfig();
                StampedConfig.this.values.put(string, stampedConfig);
                return stampedConfig.set(list2, object);
            }
            if (object3 instanceof StampedConfig) {
                return ((StampedConfig)object3).set(list2, object);
            }
            throw new IncompatibleIntermediaryLevelException("Cannot add an element to an intermediary value of type: " + String.valueOf(object3.getClass()));
        }

        @Override
        public String setComment(List<String> list, String string) {
            this.checkValid();
            switch (list.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty entry path");
                }
                case 1: {
                    String string2 = list.get(0);
                    return StampedConfig.this.comments.put(string2, string);
                }
            }
            String string3 = list.get(0);
            List<String> list2 = list.subList(1, list.size());
            Object object = StampedConfig.this.values.get(string3);
            if (object == null) {
                StampedConfig stampedConfig = this.createSubConfig();
                StampedConfig.this.values.put(string3, stampedConfig);
                return stampedConfig.setComment(list2, string);
            }
            if (object instanceof StampedConfig) {
                return ((StampedConfig)object).setComment(list2, string);
            }
            throw new IncompatibleIntermediaryLevelException("Cannot add a comment to an intermediary value of type: " + String.valueOf(object.getClass()));
        }

        @Override
        public boolean add(List<String> list, Object object) {
            this.checkValid();
            switch (list.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty entry path");
                }
                case 1: {
                    String string = list.get(0);
                    Object object2 = object == null ? NullObject.NULL_OBJECT : object;
                    return StampedConfig.this.values.putIfAbsent(string, object2) == null;
                }
            }
            String string = list.get(0);
            List<String> list2 = list.subList(1, list.size());
            Object object3 = StampedConfig.this.values.get(string);
            if (object3 == null) {
                StampedConfig stampedConfig = this.createSubConfig();
                StampedConfig.this.values.put(string, stampedConfig);
                return stampedConfig.add(list2, object);
            }
            if (object3 instanceof StampedConfig) {
                return ((StampedConfig)object3).add(list2, object);
            }
            throw new IncompatibleIntermediaryLevelException("Cannot add an element to an intermediary value of type: " + String.valueOf(object3.getClass()));
        }

        protected class Entry
        extends ReadOnlyLockedView.Entry
        implements CommentedConfig.Entry {
            Entry(Map.Entry<String, Object> entry) {
                super(entry);
                WritableLockedView.this.checkValid();
            }

            @Override
            public String removeComment() {
                WritableLockedView.this.checkValid();
                return StampedConfig.this.comments.remove(this.mapEntry.getKey());
            }

            @Override
            public String setComment(String string) {
                WritableLockedView.this.checkValid();
                return StampedConfig.this.comments.put((String)this.mapEntry.getKey(), string);
            }

            @Override
            public <T> T setValue(Object object) {
                WritableLockedView.this.checkValid();
                return (T)this.mapEntry.setValue(object);
            }
        }
    }

    private final class InLockLazyEntry
    extends LazyEntry {
        private volatile boolean valid;

        private void checkValid() {
            if (!this.valid) {
                throw new IllegalStateException("Entries provided by StampedConfig.entrySet().forEach() are only valid in the scope of the forEach call, for thread-safety reasons (and to avoid deadlocks).");
            }
        }

        void invalidate() {
            this.valid = false;
        }

        protected InLockLazyEntry(String string) {
            super(StampedConfig.this, string);
            this.valid = true;
        }

        @Override
        public String removeComment() {
            this.checkValid();
            return StampedConfig.this.comments.remove(this.key);
        }

        @Override
        public String setComment(String string) {
            this.checkValid();
            return StampedConfig.this.comments.put(this.key, string);
        }

        @Override
        public <T> T setValue(Object object) {
            this.checkValid();
            return (T)StampedConfig.this.values.put(this.key, object);
        }

        @Override
        public String getKey() {
            this.checkValid();
            return this.key;
        }

        @Override
        public <T> T getRawValue() {
            this.checkValid();
            return (T)StampedConfig.this.values.get(this.key);
        }

        @Override
        public String getComment() {
            this.checkValid();
            return StampedConfig.this.comments.get(this.key);
        }

        public String toString() {
            this.checkValid();
            return "StampedConfig.InLockLazyEntry{key=\"" + this.key + "\"}";
        }
    }

    private final class LockingLazyEntry
    extends LazyEntry {
        private final EntrySet set;

        protected LockingLazyEntry(String string, EntrySet entrySet) {
            super(StampedConfig.this, string);
            this.set = entrySet;
        }

        @Override
        public String removeComment() {
            return StampedConfig.this.mapLockRemove(StampedConfig.this.comments, StampedConfig.this.lock, this.key);
        }

        @Override
        public String setComment(String string) {
            return StampedConfig.this.mapLockPut(StampedConfig.this.comments, StampedConfig.this.lock, this.key, string);
        }

        @Override
        public <T> T setValue(Object object) {
            return (T)StampedConfig.this.mapLockPut(StampedConfig.this.values, StampedConfig.this.lock, this.key, object);
        }

        @Override
        public String getKey() {
            StampedConfig.this.checkStateForNormalOp();
            return this.key;
        }

        @Override
        public <T> T getRawValue() {
            return (T)StampedConfig.this.mapLockGet(StampedConfig.this.values, StampedConfig.this.lock, this.key);
        }

        @Override
        public String getComment() {
            return StampedConfig.this.mapLockGet(StampedConfig.this.comments, StampedConfig.this.lock, this.key);
        }

        public String toString() {
            return "StampedConfig.LockingLazyEntry{key=\"" + this.key + "\"}";
        }
    }

    private abstract class LazyEntry
    implements CommentedConfig.Entry {
        protected final String key;

        protected LazyEntry(StampedConfig stampedConfig, String string) {
            this.key = string;
        }
    }

    private class EntryIterator
    implements Iterator<LazyEntry> {
        private final LazyEntry[] entries;
        private int nextPosition;
        private boolean removed;

        EntryIterator(LazyEntry[] lazyEntryArray) {
            this.entries = lazyEntryArray;
        }

        @Override
        public boolean hasNext() {
            return this.nextPosition < this.entries.length;
        }

        @Override
        public LazyEntry next() {
            this.removed = false;
            return this.entries[this.nextPosition++];
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException("remove() can be called only once per call to next()");
            }
            if (this.nextPosition == 0) {
                throw new IllegalStateException("next() must be called before remove()");
            }
            if (this.nextPosition - 1 >= this.entries.length) {
                throw new IllegalStateException("No more elements in this iterator");
            }
            this.removed = true;
            LazyEntry lazyEntry = this.entries[this.nextPosition - 1];
            StampedConfig.this.remove(Collections.singletonList(lazyEntry.key));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super LazyEntry> consumer) {
            long l = StampedConfig.this.lock.tryWriteLock();
            if (l == 0L) {
                StampedConfig.this.checkStateForNormalOp();
                l = StampedConfig.this.lock.writeLock();
            }
            try {
                StampedConfig.this.state.set(ThreadConfigState.IN_ITER_OP);
                for (int i = this.nextPosition; i < this.entries.length; ++i) {
                    LazyEntry lazyEntry = this.entries[i];
                    InLockLazyEntry inLockLazyEntry = lazyEntry instanceof InLockLazyEntry ? (InLockLazyEntry)lazyEntry : new InLockLazyEntry(lazyEntry.key);
                    try {
                        consumer.accept(inLockLazyEntry);
                        continue;
                    }
                    finally {
                        inLockLazyEntry.invalidate();
                    }
                }
            }
            finally {
                StampedConfig.this.state.set(ThreadConfigState.NORMAL);
                StampedConfig.this.lock.unlockWrite(l);
            }
        }
    }
}

