/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.EnumGetMethod;
import me.roundaround.armorstands.roundalib.nightconfig.core.NullObject;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.StringUtils;

public interface UnmodifiableConfig {
    default public <T> T get(String string) {
        return this.get(StringUtils.split(string, '.'));
    }

    default public <T> T get(List<String> list) {
        T t = this.getRaw(list);
        return t == NullObject.NULL_OBJECT ? null : (T)t;
    }

    default public <T> T getRaw(String string) {
        return this.getRaw(StringUtils.split(string, '.'));
    }

    public <T> T getRaw(List<String> var1);

    default public <T> Optional<T> getOptional(String string) {
        return this.getOptional(StringUtils.split(string, '.'));
    }

    default public <T> Optional<T> getOptional(List<String> list) {
        return Optional.ofNullable(this.get(list));
    }

    default public <T> T getOrElse(String string, T t) {
        return this.getOrElse(StringUtils.split(string, '.'), t);
    }

    default public <T> T getOrElse(List<String> list, T t) {
        T t2 = this.getRaw(list);
        return t2 == null || t2 == NullObject.NULL_OBJECT ? t : t2;
    }

    default public <T> T getOrElse(List<String> list, Supplier<T> supplier) {
        T t = this.getRaw(list);
        return t == null || t == NullObject.NULL_OBJECT ? supplier.get() : t;
    }

    default public <T> T getOrElse(String string, Supplier<T> supplier) {
        return this.getOrElse(StringUtils.split(string, '.'), supplier);
    }

    default public <T extends Enum<T>> T getEnum(String string, Class<T> clazz, EnumGetMethod enumGetMethod) {
        return this.getEnum(StringUtils.split(string, '.'), clazz, enumGetMethod);
    }

    default public <T extends Enum<T>> T getEnum(String string, Class<T> clazz) {
        return this.getEnum(StringUtils.split(string, '.'), clazz, EnumGetMethod.NAME_IGNORECASE);
    }

    default public <T extends Enum<T>> T getEnum(List<String> list, Class<T> clazz, EnumGetMethod enumGetMethod) {
        T t = this.getRaw(list);
        return enumGetMethod.get(t, clazz);
    }

    default public <T extends Enum<T>> T getEnum(List<String> list, Class<T> clazz) {
        return this.getEnum(list, clazz, EnumGetMethod.NAME_IGNORECASE);
    }

    default public <T extends Enum<T>> Optional<T> getOptionalEnum(String string, Class<T> clazz, EnumGetMethod enumGetMethod) {
        return this.getOptionalEnum(StringUtils.split(string, '.'), clazz, enumGetMethod);
    }

    default public <T extends Enum<T>> Optional<T> getOptionalEnum(String string, Class<T> clazz) {
        return this.getOptionalEnum(string, clazz, EnumGetMethod.NAME_IGNORECASE);
    }

    default public <T extends Enum<T>> Optional<T> getOptionalEnum(List<String> list, Class<T> clazz, EnumGetMethod enumGetMethod) {
        return Optional.ofNullable(this.getEnum(list, clazz, enumGetMethod));
    }

    default public <T extends Enum<T>> Optional<T> getOptionalEnum(List<String> list, Class<T> clazz) {
        return this.getOptionalEnum(list, clazz, EnumGetMethod.NAME_IGNORECASE);
    }

    default public <T extends Enum<T>> T getEnumOrElse(String string, T t, EnumGetMethod enumGetMethod) {
        return this.getEnumOrElse(StringUtils.split(string, '.'), t, enumGetMethod);
    }

    default public <T extends Enum<T>> T getEnumOrElse(String string, T t) {
        return this.getEnumOrElse(string, t, EnumGetMethod.NAME_IGNORECASE);
    }

    default public <T extends Enum<T>> T getEnumOrElse(List<String> list, T t, EnumGetMethod enumGetMethod) {
        T t2 = this.getEnum(list, t.getDeclaringClass(), enumGetMethod);
        return t2 == null ? t : t2;
    }

    default public <T extends Enum<T>> T getEnumOrElse(List<String> list, T t) {
        return this.getEnumOrElse(list, t, EnumGetMethod.NAME_IGNORECASE);
    }

    default public <T extends Enum<T>> T getEnumOrElse(String string, Class<T> clazz, EnumGetMethod enumGetMethod, Supplier<T> supplier) {
        return this.getEnumOrElse(StringUtils.split(string, '.'), clazz, enumGetMethod, supplier);
    }

    default public <T extends Enum<T>> T getEnumOrElse(String string, Class<T> clazz, Supplier<T> supplier) {
        return this.getEnumOrElse(string, clazz, EnumGetMethod.NAME_IGNORECASE, supplier);
    }

    default public <T extends Enum<T>> T getEnumOrElse(List<String> list, Class<T> clazz, EnumGetMethod enumGetMethod, Supplier<T> supplier) {
        T t = this.getEnum(list, clazz, enumGetMethod);
        return (T)(t == null ? (Enum)supplier.get() : t);
    }

    default public <T extends Enum<T>> T getEnumOrElse(List<String> list, Class<T> clazz, Supplier<T> supplier) {
        return this.getEnumOrElse(list, clazz, EnumGetMethod.NAME_IGNORECASE, supplier);
    }

    default public int getInt(String string) {
        return ((Number)this.get(string)).intValue();
    }

    default public int getInt(List<String> list) {
        return ((Number)this.getRaw(list)).intValue();
    }

    default public OptionalInt getOptionalInt(String string) {
        return this.getOptionalInt(StringUtils.split(string, '.'));
    }

    default public OptionalInt getOptionalInt(List<String> list) {
        Number number = (Number)this.get(list);
        return number == null ? OptionalInt.empty() : OptionalInt.of(number.intValue());
    }

    default public int getIntOrElse(String string, int n) {
        return this.getIntOrElse(StringUtils.split(string, '.'), n);
    }

    default public int getIntOrElse(List<String> list, int n) {
        Number number = (Number)this.get(list);
        return number == null ? n : number.intValue();
    }

    default public int getIntOrElse(String string, IntSupplier intSupplier) {
        return this.getIntOrElse(StringUtils.split(string, '.'), intSupplier);
    }

    default public int getIntOrElse(List<String> list, IntSupplier intSupplier) {
        Number number = (Number)this.get(list);
        return number == null ? intSupplier.getAsInt() : number.intValue();
    }

    default public long getLong(String string) {
        return ((Number)this.getRaw(string)).longValue();
    }

    default public long getLong(List<String> list) {
        return ((Number)this.getRaw(list)).longValue();
    }

    default public OptionalLong getOptionalLong(String string) {
        return this.getOptionalLong(StringUtils.split(string, '.'));
    }

    default public OptionalLong getOptionalLong(List<String> list) {
        Number number = (Number)this.get(list);
        return number == null ? OptionalLong.empty() : OptionalLong.of(number.longValue());
    }

    default public long getLongOrElse(String string, long l) {
        return this.getLongOrElse(StringUtils.split(string, '.'), l);
    }

    default public long getLongOrElse(List<String> list, long l) {
        Number number = (Number)this.get(list);
        return number == null ? l : number.longValue();
    }

    default public long getLongOrElse(String string, LongSupplier longSupplier) {
        return this.getLongOrElse(StringUtils.split(string, '.'), longSupplier);
    }

    default public long getLongOrElse(List<String> list, LongSupplier longSupplier) {
        Number number = (Number)this.get(list);
        return number == null ? longSupplier.getAsLong() : number.longValue();
    }

    default public byte getByte(String string) {
        return ((Number)this.getRaw(string)).byteValue();
    }

    default public byte getByte(List<String> list) {
        return ((Number)this.getRaw(list)).byteValue();
    }

    default public byte getByteOrElse(String string, byte by) {
        return this.getByteOrElse(StringUtils.split(string, '.'), by);
    }

    default public byte getByteOrElse(List<String> list, byte by) {
        Number number = (Number)this.get(list);
        return number == null ? by : number.byteValue();
    }

    default public short getShort(String string) {
        return ((Number)this.getRaw(string)).shortValue();
    }

    default public short getShort(List<String> list) {
        return ((Number)this.getRaw(list)).shortValue();
    }

    default public short getShortOrElse(String string, short s) {
        return this.getShortOrElse(StringUtils.split(string, '.'), s);
    }

    default public short getShortOrElse(List<String> list, short s) {
        Number number = (Number)this.get(list);
        return number == null ? s : number.shortValue();
    }

    default public char getChar(String string) {
        return (char)this.getInt(string);
    }

    default public char getChar(List<String> list) {
        Object t = this.getRaw(list);
        if (t instanceof Number) {
            return (char)((Number)t).intValue();
        }
        if (t instanceof CharSequence) {
            return ((CharSequence)t).charAt(0);
        }
        return ((Character)t).charValue();
    }

    default public char getCharOrElse(String string, char c) {
        return this.getCharOrElse(StringUtils.split(string, '.'), c);
    }

    default public char getCharOrElse(List<String> list, char c) {
        Object t = this.getRaw(list);
        if (t == null || t == NullObject.NULL_OBJECT) {
            return c;
        }
        if (t instanceof Number) {
            return (char)((Number)t).intValue();
        }
        if (t instanceof CharSequence) {
            return ((CharSequence)t).charAt(0);
        }
        return ((Character)t).charValue();
    }

    default public boolean contains(String string) {
        return this.contains(StringUtils.split(string, '.'));
    }

    public boolean contains(List<String> var1);

    default public boolean isNull(String string) {
        return this.isNull(StringUtils.split(string, '.'));
    }

    default public boolean isNull(List<String> list) {
        return this.getRaw(list) == NullObject.NULL_OBJECT;
    }

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public Map<String, Object> valueMap();

    public Set<? extends Entry> entrySet();

    public ConfigFormat<?> configFormat();

    default public <T> T apply(String string) {
        return this.get(string);
    }

    default public <T> T apply(List<String> list) {
        return this.get(list);
    }

    public static interface Entry {
        public String getKey();

        public <T> T getRawValue();

        default public <T> T getValue() {
            T t = this.getRawValue();
            return t == NullObject.NULL_OBJECT ? null : (T)t;
        }

        default public boolean isNull() {
            return this.getRawValue() == NullObject.NULL_OBJECT;
        }

        default public <T> Optional<T> getOptional() {
            return Optional.ofNullable(this.getValue());
        }

        default public <T> T getOrElse(T t) {
            T t2 = this.getRawValue();
            return t2 == null || t2 == NullObject.NULL_OBJECT ? t : t2;
        }

        default public int getInt() {
            return ((Number)this.getRawValue()).intValue();
        }

        default public OptionalInt getOptionalInt() {
            Number number = (Number)this.getRawValue();
            return number == null ? OptionalInt.empty() : OptionalInt.of(number.intValue());
        }

        default public int getIntOrElse(int n) {
            Number number = (Number)this.getRawValue();
            return number == null ? n : number.intValue();
        }

        default public long getLong() {
            return ((Number)this.getRawValue()).longValue();
        }

        default public OptionalLong getOptionalLong() {
            Number number = (Number)this.getRawValue();
            return number == null ? OptionalLong.empty() : OptionalLong.of(number.longValue());
        }

        default public long getLongOrElse(long l) {
            Number number = (Number)this.getRawValue();
            return number == null ? l : number.longValue();
        }

        default public byte getByte() {
            return ((Number)this.getRawValue()).byteValue();
        }

        default public byte getByteOrElse(byte by) {
            Number number = (Number)this.getRawValue();
            return number == null ? by : number.byteValue();
        }

        default public short getShort() {
            return ((Number)this.getRawValue()).shortValue();
        }

        default public short getShortOrElse(short s) {
            Number number = (Number)this.getRawValue();
            return number == null ? s : number.shortValue();
        }

        default public char getChar() {
            Object t = this.getRawValue();
            if (t instanceof Number) {
                return (char)((Number)t).intValue();
            }
            if (t instanceof CharSequence) {
                return ((CharSequence)t).charAt(0);
            }
            return ((Character)t).charValue();
        }

        default public char getCharOrElse(char c) {
            Object t = this.getRawValue();
            if (t == null) {
                return c;
            }
            if (t instanceof Number) {
                return (char)((Number)t).intValue();
            }
            if (t instanceof CharSequence) {
                return ((CharSequence)t).charAt(0);
            }
            return ((Character)t).charValue();
        }
    }
}

