/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.Config;
import me.roundaround.armorstands.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.NullObject;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.ConfigParser;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.ConfigWriter;

public final class InMemoryFormat
implements ConfigFormat<Config> {
    static final Predicate<Class<?>> DEFAULT_PREDICATE = clazz -> clazz == null || clazz.isPrimitive() || clazz == Byte.class || clazz == Short.class || clazz == Character.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Boolean.class || clazz == String.class || clazz == NullObject.class || Collection.class.isAssignableFrom((Class<?>)clazz) || Config.class.isAssignableFrom((Class<?>)clazz) || Enum.class.isAssignableFrom((Class<?>)clazz);
    private static final InMemoryFormat DEFAULT_INSTANCE = new InMemoryFormat(DEFAULT_PREDICATE);
    private static final InMemoryFormat UNIVERSAL_INSTANCE = new InMemoryFormat(clazz -> true);
    private final Predicate<Class<?>> supportPredicate;

    public static InMemoryFormat defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static InMemoryFormat withSupport(Predicate<Class<?>> predicate) {
        return new InMemoryFormat(predicate);
    }

    public static InMemoryFormat withUniversalSupport() {
        return UNIVERSAL_INSTANCE;
    }

    private InMemoryFormat(Predicate<Class<?>> predicate) {
        this.supportPredicate = predicate;
    }

    @Override
    public ConfigWriter createWriter() {
        throw new UnsupportedOperationException("In memory configurations aren't meant to be written.");
    }

    @Override
    public ConfigParser<Config> createParser() {
        throw new UnsupportedOperationException("In memory configurations aren't meant to be parsed.");
    }

    @Override
    public Config createConfig(Supplier<Map<String, Object>> supplier) {
        return Config.of(supplier, this);
    }

    @Override
    public boolean supportsComments() {
        return false;
    }

    @Override
    public boolean supportsType(Class<?> clazz) {
        return this.supportPredicate.test(clazz);
    }

    @Override
    public boolean isInMemory() {
        return true;
    }
}

