/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.config.option;

import java.util.Optional;
import me.roundaround.armorstands.roundalib.config.ConfigPath;
import me.roundaround.armorstands.roundalib.config.option.ConfigOption;
import me.roundaround.armorstands.roundalib.config.panic.IllegalArgumentPanic;
import me.roundaround.armorstands.roundalib.config.panic.Panic;
import net.minecraft.class_3532;

public class FloatConfigOption
extends ConfigOption<Float> {
    private final Float minValue;
    private final Float maxValue;
    private final boolean slider;
    private final Float step;

    protected FloatConfigOption(Builder builder) {
        super(builder);
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.slider = builder.slider;
        this.step = builder.step;
    }

    @Override
    public void deserialize(Object object) {
        this.setValue(Float.valueOf(((Double)object).floatValue()));
    }

    public Float getMinValue() {
        return this.minValue;
    }

    public Float getMaxValue() {
        return this.maxValue;
    }

    public boolean useSlider() {
        return this.slider;
    }

    public float getStep() {
        if (this.step != null) {
            return this.step.floatValue();
        }
        if (this.getMinValue() != null && this.getMaxValue() != null) {
            return (this.getMaxValue().floatValue() - this.getMinValue().floatValue()) / 10.0f;
        }
        return 20.0f;
    }

    @Override
    public boolean areValuesEqual(Float f, Float f2) {
        return Math.abs(f.floatValue() - f2.floatValue()) < 9.765625E-4f;
    }

    public boolean step(int n) {
        float f = ((Float)this.getPendingValue()).floatValue();
        float f2 = Optional.ofNullable(this.getMinValue()).orElse(Float.valueOf(Float.MIN_VALUE)).floatValue();
        float f3 = Optional.ofNullable(this.getMaxValue()).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue();
        float f4 = class_3532.method_15363((float)(f + this.getStep() * (float)n), (float)f2, (float)f3);
        if (f4 == f) {
            return false;
        }
        this.setValue(Float.valueOf(f4));
        return true;
    }

    public static Builder builder(ConfigPath configPath) {
        return new Builder(configPath);
    }

    public static Builder sliderBuilder(ConfigPath configPath) {
        return FloatConfigOption.builder(configPath).setUseSlider(true);
    }

    public static class Builder
    extends ConfigOption.AbstractBuilder<Float, FloatConfigOption, Builder> {
        private Float minValue = null;
        private Float maxValue = null;
        private boolean slider = false;
        private Float step = null;

        private Builder(ConfigPath configPath) {
            super(configPath);
        }

        @Override
        public Builder setDefaultValue(float f) {
            this.defaultValue = Float.valueOf(f);
            return this;
        }

        public Builder setMinValue(float f) {
            this.minValue = Float.valueOf(f);
            return this;
        }

        public Builder setMinValue(Float f) {
            this.minValue = f;
            return this;
        }

        public Builder setMaxValue(float f) {
            this.maxValue = Float.valueOf(f);
            return this;
        }

        public Builder setMaxValue(Float f) {
            this.maxValue = f;
            return this;
        }

        public Builder setUseSlider(boolean bl) {
            this.slider = bl;
            return this;
        }

        public Builder setStep(float f) {
            this.step = Float.valueOf(f);
            return this;
        }

        public Builder setStep(Float f) {
            this.step = f;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.maxValue != null) {
                this.validators.addFirst((f, configOption) -> f.floatValue() <= this.maxValue.floatValue());
                if (this.minValue != null && this.minValue.floatValue() > this.maxValue.floatValue()) {
                    Panic.panic(new IllegalArgumentPanic("Min value cannot be larger than max value for FloatConfigOption"));
                }
            }
            if (this.minValue != null) {
                this.validators.addFirst((f, configOption) -> f.floatValue() >= this.minValue.floatValue());
            }
            if (this.slider && (this.minValue == null || this.maxValue == null)) {
                Panic.panic(new IllegalArgumentPanic("Min and max values must be defined to use slider control for FloatConfigOption"));
            }
        }

        @Override
        protected FloatConfigOption buildInternal() {
            return new FloatConfigOption(this);
        }
    }
}

